package org.postgresforest.tool.util;

import java.text.MessageFormat;

import org.postgresforest.tool.ForestToolCommandLine;

public class MessagesCommandLine {
	/**
	 * Returns the formatted message for the given key in
	 * the resource bundle. 
	 *
	 * @param key the resource name
	 * @param args the message arguments
	 * @return the string
	 */	
	public static String getString(String key, Object[] args) {

		return MessageFormat.format(getString(key),args);
	}
	
	/**
	 * Returns the resource object with the given key in
	 * the resource bundle. If there isn't any value under
	 * the given key, the key is returned.
	 *
	 * @param key the resource name
	 * @return the string
	 */	
	public static String getString(String key) {
		return ForestToolCommandLine.getResourceString(key);
	}
	
	public static String getString(String key, String arg) {

		String[] args = {arg};
		return getString(key, args);
	
	}

}
