/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.util;

import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

/**
 * R\[o̓NX
 *
 * R\[r[ɃOyсAX^bNg[Xo͂
 */
public class ConsoleLog {
	
    static MessageConsoleStream m_stream = getMessageConsoleStream();

    /**
     * @param message
     * @since 
     */
    public static void print(String message) {
        m_stream.print(message);
    }
    /**
     * 
     * @since 
     */
    public static void println() {
        m_stream.println();
    }
    /**
     * @param message
     * @since 
     */
    public static void println(String message) {
        m_stream.println(message);
    }
	
	/**
	 * R\[r[ɃX^bNg[Xo͂
	 * 
	 * @param e
	 */
	public static void printStackTrace(Throwable e){
		//R\[Xg[擾
	    MessageConsoleStream stream = getMessageConsoleStream();
	    
	    //ZLqo
	    String message = e.toString();
	    
	    //X^bNg[Xo
        StackTraceElement[] trace = e.getStackTrace();
        for (int i=0; i < trace.length; i++){
        	message = message + "\n\tat " + trace[i];
        }

        stream.print(message + "\n");
	}
	
	/**
	 * R\[Xg[擾
	 * 
	 * @return
	 */
	public static MessageConsoleStream getMessageConsoleStream(){
		//ZbVvpeBR\[擾
		MessageConsole console = (MessageConsole)SessionProperty.get("console");
		if(console == null){
		    //R\[}l[WɃR\[ǉ
		    IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager(); 
		    console = new MessageConsole(Messages.getString("title.name"), null);
		    consoleManager.addConsoles(new IConsole[] {console});
		    
			//ZbVvpeBɃR\[ݒ
		    SessionProperty.set("console", console);
		}
	    MessageConsoleStream stream = console.newMessageStream();

	    return stream;
	}
}
