/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.addgsc;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.util.Messages;

/**
 * O[oVXeJ^O쐬_CAONX
 *
 */
public class AddGscDialog extends CommonDialog {
	
	private Text m_dbNameTxt = null;
	private Combo m_instanceCmb = null;
	private ArrayList m_serveList = null;
	
	private String m_dbName;
	private int m_instanceIndex;
	private int m_selectedInstanceIndex = 0;
	
	/* ( Javadoc)
	 * @see org.postgresforest.tool.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {
	

		GridLayout layout = new GridLayout(2, true);
		parent.setLayout(layout);
		GridData gridData;

		//DB
		new Label(parent,SWT.NONE).setText(Messages.getString("form.db.name"));
		m_dbNameTxt = new Text(parent, SWT.BORDER );
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_dbNameTxt.setLayoutData(gridData);
		
		//CX^X
		new Label(parent,SWT.NONE).setText(Messages.getString("form.instance"));
		m_instanceCmb = new Combo(parent, SWT.READ_ONLY);		   

		//R{{bNXɃCX^Xݒ肷
		for (Iterator iter = m_serveList.iterator(); iter.hasNext();) {
			ServerInfo info = (ServerInfo) iter.next();
			m_instanceCmb.add(info.getHost() + ":" + info.getPort());
		}
		m_instanceCmb.select(m_selectedInstanceIndex);

		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_instanceCmb.setLayoutData(gridData);
		
		
		
	}
	/* ( Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed() {
		m_dbName = m_dbNameTxt.getText();
		m_instanceIndex = m_instanceCmb.getSelectionIndex();
		super.okPressed();
	}
	/* ( Javadoc)
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("title.admin.gsc"));

	
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.dialog.CommonDialog#getOkButtonText()
	 */
	protected String getOkButtonText() {
		// TODO ꂽ\bhEX^u
		return Messages.getString("button.make");
	}
	/**
	 * @param serveList serveList ݒB
	 */
	public void setServeList(ArrayList serveList) {
		m_serveList = serveList;
	}
	/**
	 * @return dbName ߂܂B
	 */
	public String getDbName() {
		return m_dbName;
	}
	/**
	 * @return instanceIndex ߂܂B
	 */
	public int getInstanceIndex() {
		return m_instanceIndex;
	}
	//TODOMASU ZbgDBI
	public void setServerInfoSelection(String l_Id){
		int index = 0;
		for(Iterator ite = m_serveList.iterator(); ite.hasNext();){
			ServerInfo serverInfo = (ServerInfo)ite.next();
			if(serverInfo.getId() == Integer.parseInt(l_Id)){
				m_selectedInstanceIndex = index;
				break;
			}
			index ++;
		}
		
		
	}
}