/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.adddb;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.postgresforest.tool.ForestToolPlugin;
import org.postgresforest.tool.bean.ServerDumpDataInfo;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class AddDbLabelProvider extends LabelProvider implements ITableLabelProvider {
	public String getColumnText(Object element, int columnIndex) {
		ServerDumpDataInfo info = (ServerDumpDataInfo)element;
		String status;
		switch(columnIndex) {
		case 0:
			return "";
		case 1:
			return info.getHost() + ":" + info.getPort();
		case 2:
			return info.getDumpData();
		}
		return null;
	}
	public Image getColumnImage(Object element, int columnIndex) {
			ImageRegistry registry = ForestToolPlugin.getDefault().getImageRegistry();

			ServerDumpDataInfo info = (ServerDumpDataInfo)element;
			if(columnIndex == 0){
				if(info.isChkFlag()){
					return registry.getDescriptor(ForestToolPlugin.IMG_CHECKED).createImage();
				}else{
					return registry.getDescriptor(ForestToolPlugin.IMG_UNCHECKED).createImage();
				}
				
			}
			

			return null;
	}
}