/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.adddb;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Item;
import org.postgresforest.tool.bean.ServerDumpDataInfo;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AddDbCellModifier implements ICellModifier {
	private TableViewer viewer;
	private boolean canDumpDataModify = false;

	
	
	public AddDbCellModifier(TableViewer viewer) {
		this.viewer = viewer;
	}
	
	public boolean canModify(Object element, String property) {
		ServerDumpDataInfo info = (ServerDumpDataInfo) element;

	    if (property == "dumpdata"){
	        if(canDumpDataModify == false){
	            return false;
	        }else{
	            return info.isChkFlag();
	        }
	    }
		return true;
	}
	
	public Object getValue(Object element, String property) {
		ServerDumpDataInfo info = (ServerDumpDataInfo) element;

		if (property == "check"){
			return new Boolean(info.isChkFlag());
		}
	    if (property == "dumpdata"){
	        return info.getDumpData();
	    }
		return null;
	}
	
	public void modify(Object element, String property, Object value) {
		if (element instanceof Item) {
			element = ((Item) element).getData();
		}
		ServerDumpDataInfo info = (ServerDumpDataInfo) element;

		if (property == "check") {
			info.setChkFlag(((Boolean) value).booleanValue());
			if(!info.isChkFlag()){
		    	info.setDumpData("");
			}
		}
	    if (property == "dumpdata") {
	    	info.setDumpData((String) value);
	    }
		// e[uEr[XV
		viewer.update(element, null);
	}
    /**
     * @param canDumpDataModify canDumpDataModify ݒB
     */
    public void setCanDumpDataModify(boolean canDumpDataModify) {
        this.canDumpDataModify = canDumpDataModify;
    }

}