/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

import org.postgresforest.tool.util.StringReplaceUtil;
import org.postgresql.jdbc3.Jdbc3Connection;

/**
 * f[^x[XANZXNX
 * 
 * GSCу[Uf[^x[Xւ̃ANZXʋ@\񋟂B
 * 
 */
public class DbBase {

	protected static final String[] protocols = { "jdbc", "postgresql" };
	protected static final String PROTOCOL = "jdbc:postgresql:";
	public static final String TEMLATE_DB = "forest_template";

	/** 쐬[h萔  */
	public static final int DB_MAKE 	= 0;
	public static final int DB_ADD	= 1;
	public static final int DB_SHIFT 	= 2;

	protected Properties m_prop = new Properties(); //[UEpX[h

	protected static ResourceBundle m_sqlResource = null;

	protected int m_selectServerIndex;
	
	protected ArrayList m_Connection = null; //

	protected ArrayList m_servers = null; //T[oڑ񃊃Xg

	protected ArrayList m_errInfoList = new ArrayList(); //G[

	{
		//JDBChCõ[h
		try {
			Class.forName("org.postgresql.Driver");
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}

	}

	public DbBase() {
		m_servers = new ArrayList();
		m_Connection = new ArrayList();
		try {
			m_sqlResource = ResourceBundle.getBundle("org.postgresforest.tool.util.SQL");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	/**
	 * RXgN^
	 * @param user	[U
	 * @param password@pX[h
	 */
	public DbBase(String user, String password) {
		//oϐɊi[
		this();
		m_prop.put("user", user);
		m_prop.put("password", password);

	}

	/**
	 * [UApX[h擾
	 * @return [UApX[hi[vpeBNX
	 */
	public Properties getUserPassword() {

		return m_prop;
	}
	/**
	 * ڑ񂩂ڑ̐B
	 * @param urlinfo ڑ
	 * @return f[^x[Xڑ
	 */
	protected String makeUrl(UrlInfo urlinfo) {

		return makeUrl(
			urlinfo.getHostName(),
			urlinfo.getPortNo(),
			urlinfo.getDbName());

	}
	/**
	 * ڑ񂩂ڑ̐B
	 * DB쐬Ȃǂ̂template1f[^x[Xւ̐ڑ𐶐
	 * @param urlinfo ڑ
	 * @return f[^x[Xڑ
	 */
	protected String makeTemplateUrl(UrlInfo urlinfo) {

		return makeUrl(urlinfo.getHostName(), urlinfo.getPortNo(), TEMLATE_DB);

	}

	/**
	 * ڑ񐶐
	 * zXgA|[gAf[^x[XDB̐ڑɕҏW
	 * @param hostName@zXg	
	 * @param portNo@|[gԍ
	 * @param dbName@f[^x[X
	 * @return f[^x[Xڑ
	 */
	static public String makeUrl(
		String hostName,
		String portNo,
		String dbName) {

		StringBuffer serverUrlWk = new StringBuffer();
		if (!hostName.equals("")) {
			serverUrlWk.append("//");
			serverUrlWk.append(hostName);
			if (!portNo.equals("")) {
				serverUrlWk.append(":");
				serverUrlWk.append(portNo);
			}
			serverUrlWk.append("/");
		}
		serverUrlWk.append(dbName);

		return serverUrlWk.toString();
	}

	/**
	 * ڑݒB
	 * zXgA|[gAf[^x[XT[ΐڑ񃊃Xgɒǉ
	 * @param hostName@zXg	
	 * @param portNo@|[gԍ
	 * @param dbName@f[^x[X
	 */
	public void addUrl(String hostName, String portNo, String dbName) {
		UrlInfo urlInfo = new UrlInfo();
		urlInfo.setHostName(hostName);
		urlInfo.setPortNo(portNo);
		urlInfo.setDbName(dbName);
		m_servers.add(urlInfo);
	}

	/**
	 * f[^x[X쐬
	 * 
	 * f[^x[Xڑ񃊃Xgɐݒ肳ꂽAf[^x[X̓o^sB
	 * f[^x[X̍쐬ɂ́Atemplate1f[^x[X֐ڑčsƁB
	 * 
	 * @param option CREATE DATABE@IvV
	 * @return	true:ڑ.false:ڑs
	 */
	public boolean makeDB(String option, int makeMode)  {

		boolean ret = true;
		String connectUrl = "";

		//SQL擾	
		StringReplaceUtil strUtil =
			new StringReplaceUtil(m_sqlResource.getString("create.db"));
			
		//f[^x[Xǉ̏ꍇAtemplate0DB쐬
		if (makeMode == DB_ADD) {
			option = option + " " + m_sqlResource.getString("create.db.option.dbadd");
		}
		//Ver3.1 f[^x[X쐬forestptemplategp
		else{
			option = option + " " + m_sqlResource.getString("create.db.option.default");
		}
		
		for (int i = 0; i < m_servers.size(); i++) {
			Connection con = (Connection) m_Connection.get(i);

			//T[oڑ擾
			UrlInfo urlInfo = (UrlInfo) m_servers.get(i);

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();

				strUtil.set(1, urlInfo.getDbName());
	
				//IvV̐ݒ
				if (option.trim().compareTo("") != 0) {
					strUtil.set(
						2,
						m_sqlResource.getString("create.db.addoption"));
					strUtil.set(3, option);
				} else {
					strUtil.set(2, "");
					strUtil.set(3, "");
				}

				Statement ps = con.createStatement();

				
				//f[^x[X쐬s
				ps.execute(strUtil.toString());

				ps.close();

			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}
		}

		return ret;

	}

	/**
	 * [U쐬
	 * 
	 * f[^x[Xڑ񃊃Xgɐݒ肳ꂽT[oփ[U̍쐬sB
	 * 
	 * @param user@[U
	 * @param password	pX[h
	 * @param option	CREATE USER ̃IvV
	 * @return	true:.false:s
	 */
	public boolean makeUser(String user, String password, String passwordOption, String option)
		{

		boolean ret = true;
		String connectUrl = "";

		//SQL擾	
		StringReplaceUtil createUserSql =
			new StringReplaceUtil(
				m_sqlResource.getString("create.user"));
				
		StringReplaceUtil alterUserSql =
			new StringReplaceUtil(
				m_sqlResource.getString("alter.user"));
					
		for (int i = 0; i < m_servers.size(); i++) {
			Connection con = (Connection) m_Connection.get(i);

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();

				//[U[݂̑`FbNB[U[݂ꍇAALTER USERs
				PreparedStatement psmt =
					con.prepareStatement(
						m_sqlResource.getString("check.user"));
	
				psmt.setString(1, user);
				ResultSet rs = psmt.executeQuery();
				
				int userCount = 0;
				if (rs.next()) {
					userCount = rs.getInt("user_count");
				}
				rs.close();
				psmt.close();
				
				if (userCount == 0){
					//[U݂Ȃ̂ō쐬
					
					//p[^ݒ
					createUserSql.set(1, user);
					createUserSql.set(2, passwordOption);
					createUserSql.set(3, password);
					createUserSql.set(4, " " + option);
					
					Statement smt = con.createStatement();
						
					//[U쐬s
					smt.execute(createUserSql.toString());
					
					smt.close();
				}
				else{
					//[Û݂ŕύX
					
					//p[^ݒ
					alterUserSql.set(1, user);
					alterUserSql.set(2, passwordOption);
					alterUserSql.set(3, password);
					alterUserSql.set(4, " " + option);
					
					Statement smt = con.createStatement();
						
					//[UύXs
					smt.execute(alterUserSql.toString());
					
					smt.close();
				}
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}

		}

		return ret;

	}

	/**
	 * [U폜
	 * 
	 * f[^x[Xڑ񃊃Xgɐݒ肳ꂽT[oփ[U̍폜sB
	 * @param user	[U
	 * @return	true:ڑ.false:ڑs
	 */
	public boolean delUser(String user)  {


		boolean ret = true;
		String connectUrl = "";

		//SQL擾	
		StringReplaceUtil createDbSql =
			new StringReplaceUtil(m_sqlResource.getString("drop.user"));

		for (int i = 0; i < m_servers.size(); i++) {
			Connection con = (Connection) m_Connection.get(i);

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();

	
				//p[^ݒ
				createDbSql.set(1, user);
	
				Statement ps = con.createStatement();
	
	
				//[U폜s	
				ps.execute(createDbSql.toString());
	
				ps.close();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}
		}

		return ret;


	}
	
	/**
	 * f[^x[X폜
	 * 
	 * f[^x[Xڑ񃊃Xgɐݒ肳ꂽAf[^x[X̍폜sB
	 * f[^x[X̍쐬ɂ́Atemplate1f[^x[X֐ڑčsƁB
	 * @return	true:ڑ.false:ڑs
	 */
	public boolean delDB()  {

		boolean ret = true;
		String connectUrl = "";


		//SQL擾
		StringReplaceUtil strUtil =
			new StringReplaceUtil(m_sqlResource.getString("drop.db"));

		for (int i = 0; i < m_servers.size(); i++) {

			//T[oڑ擾
			UrlInfo urlInfo = (UrlInfo) m_servers.get(i);

			Connection con = (Connection) m_Connection.get(i);

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();

				//f[^x[XZbg				
				strUtil.set(1, urlInfo.getDbName());
	
				//f[^x[X폜s
				Statement ps = con.createStatement();
				ps.execute(strUtil.toString());
	
				ps.close();

			
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
				ret = false;
			}
		}

		return ret;

	}

	/**
	 * RlNVڑ
	 * 
	 * template1f[^x[Xւ̐ڑsB
	 * 
	 * @param srcURL ڑURL
	 * @return	true:ڑ.false:ڑs
	 * @throws SQLException
	 */
	public boolean connectTemplate() {

		boolean ret = true;

		for (Iterator iter = m_servers.iterator(); iter.hasNext();) {
			UrlInfo url = (UrlInfo) iter.next();

			String connetStr = PROTOCOL + makeTemplateUrl(url);

			//f[^\[Xւ̃RlNVm
			try {
				Connection con = DriverManager.getConnection(connetStr, m_prop);
				m_Connection.add(con);
			} catch (SQLException e) {
				setErrInfo(connetStr, e);
				ret = false;
			}
		}
		return ret;

	}

	/**
	 * RlNVڑ
	 * 
	 * 
	 * @param srcURL ڑURL
	 * @return
	 * @throws SQLException
	 */
	public boolean connect(boolean autocommit) {
		boolean ret = true;
		for (Iterator iter = m_servers.iterator(); iter.hasNext();) {
			UrlInfo url = (UrlInfo) iter.next();
			String connetStr = PROTOCOL + makeUrl(url);

			//f[^\[Xւ̃RlNVm
			try {
				Connection con = DriverManager.getConnection(connetStr, m_prop);	
				con.setAutoCommit(autocommit);
				m_Connection.add(con);
			} catch (SQLException e) {
				setErrInfo(connetStr, e);
				ret = false;
			}
		}

		return ret;

	}


	protected Connection getSelectConnectoin(){
		return (Connection)getConnectoin(0);
	
	}

	protected Connection getConnectoin(int index){
		return (Connection)m_Connection.get(index);
	
	}

	/**
	 * RlNVڑ
	 * 
	 * p1ڑsB
	 * T[o񃊃Xg̍ŏ̃T[oɐڑB
	 * 
	 * @param srcURL ڑURL
	 * @return
	 * @throws SQLException
	 */
	public boolean connectSELECT() {


		boolean ret = true;
		UrlInfo url = (UrlInfo) m_servers.get(0);
		String connetStr = PROTOCOL + makeUrl(url);

		//f[^\[Xւ̃RlNVm
		try {
			Connection con = DriverManager.getConnection(connetStr, m_prop);
			con.setAutoCommit(false);
			m_Connection.add(con);
		} catch (SQLException e) {
			setErrInfo(connetStr, e);
			ret = false;
		}

		return ret;

	}
	

	/**
	 * N[Y
	 *
	 */
	public void close() {

		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				con.close();
			} catch (SQLException e) {
			}

		}

		m_Connection.clear();

	}

	/**
	 *	R~bg 
	 * @throws SQLException
	 */
	public void commit()  {

		String connectUrl = "";

		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				connectUrl = ((Jdbc3Connection) con).getURL();
				con.commit();
			} catch (SQLException e) {
				setErrInfo(connectUrl, e);
			}


		}

	}

	/**
	 * [obN 
	 *
	 */
	public void rollback() {

		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
			Connection con = (Connection) iter.next();

			try {
				con.rollback();
			} catch (SQLException e) {
				//@@
				System.err.println();
			}

		}

	}

	/**
	 * ڑ
	 *
	 */
	protected class UrlInfo {
		protected String m_hostName;
		protected String m_portNo;
		protected String m_dbName;

		/**
		 * @return
		 */
		public String getDbName() {
			return m_dbName;
		}

		/**
		 * @return
		 */
		public String getHostName() {
			return m_hostName;
		}

		/**
		 * @param string
		 */
		public void setDbName(String string) {
			m_dbName = string;
		}

		/**
		 * @param string
		 */
		public void setHostName(String string) {
			m_hostName = string;
		}

		/**
		 * @return
		 */
		public String getPortNo() {
			return m_portNo;
		}

		/**
		 * @param string
		 */
		public void setPortNo(String string) {
			m_portNo = string;
		}

	}

	/**
	 * @param strings
	 */
	public String[] getURL() {

		ArrayList urlList = new ArrayList();
		for (Iterator iter = m_servers.iterator(); iter.hasNext();) {
			UrlInfo url = (UrlInfo) iter.next();
			urlList.add(makeUrl(url));
		}
		//oϐɊi[

		return (String[]) urlList.toArray(new String[0]);
	}

	/**
	 * @param strings
	 */
	public String getURL(int index) {

		return 	makeUrl((UrlInfo)m_servers.get(index));

	}

	/**
	 *RlNVp̃vpeBXg쐬 
	 * @param url
	 * @return
	 */
	static public Properties parseURL(String url) {

		int state = -1;
		Properties urlProps = new Properties();

		String key = "";
		String value = "";

		StringTokenizer st = new StringTokenizer(url, ":/;=&?", true);
		for (int count = 0;(st.hasMoreTokens()); count++) {
			String token = st.nextToken();

			if (count == 0 && token.equals("/"))
				state = 0;
			else if (count == 0) {
				urlProps.put("PGDBNAME", token);
				state = -2;
			} else if (count == 1 && state == 0 && token.equals("/"))
				state = 1;
			else if (count == 1 && state == 0)
				return null;
			else if (count == 2 && state == 1)
				urlProps.put("PGHOST", token);
			else if (count == 3 && token.equals(":"))
				state = 2;
			else if (count == 4 && state == 2) {
				try {
					Integer portNumber = Integer.decode(token);
					urlProps.put("PGPORT", portNumber.toString());
				} catch (Exception e) {
					return null;
				}
			} else if (
				(count == 3 || count == 5)
					&& (state == 1 || state == 2)
					&& token.equals("/"))
				state = -1;
			else if (state == -1) {
				urlProps.put("PGDBNAME", token);
				state = -2;
			} else if (state <= -2 && (count % 2) == 1) {
				if (token.equals(";")
					|| token.equals("?")
					|| token.equals("&"))
					state = -3;
				else if (token.equals("="))
					state = -5;
			} else if (state <= -2 && (count % 2) == 0) {
				if (state == -3)
					key = token;
				else if (state == -5) {
					value = token;
					urlProps.put(key, value);
					state = -2;
				}
			}
		}

		return urlProps;

	}

	/**
	 * @return
	 */
	public boolean isErrInfo() {
		if(m_errInfoList.size() == 0){
			
			return false;
		}else{
			return true;
			
		}
	}

	/**
	 * @return
	 */
	public ArrayList getErrInfoList() {
		return m_errInfoList;
	}
	/**
	 * @return
	 */
	public void clearErrInfoList() {
		m_errInfoList.clear();
	}

	protected void setErrInfo(String url, String sql, Exception exception) {
		ErrInfo errInfo = new ErrInfo(url, sql, exception);
		m_errInfoList.add(errInfo);
	}

	protected void setErrInfo(String url, Exception exception) {
		setErrInfo(url, "", exception);
	}

	/**
	 * DB̈ꗗ擾
	 * 
	 * f[^x[X^f[^f[^x[Ẍꗗ擾B
	 * eڑɂƂɁAL[AlƂɁAf[^x[XHashMap𐶐A
	 * XgɊi[ĕԂ
	 * 
	 * @return@DB̈ꗗ
	 */
	public ArrayList getDbMapList(){

		ArrayList dbMapList = new ArrayList();
		String connectUrl = "";

		for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {

			Connection con = (Connection) iter.next();
			HashMap dbMap = new HashMap();
			try{
	
				connectUrl = ((Jdbc3Connection) con).getURL();
	
				//^񂩂e[üꗗ擾
				DatabaseMetaData dataMeta = con.getMetaData();
				
				ResultSet rs = dataMeta.getCatalogs();
				
				while (rs.next()) {
					String dbName = rs.getString("TABLE_CAT");
					//HashMapɓo^
					dbMap.put(dbName,dbMap);
				}
				
	
			} catch (SQLException e) {
			}
			//HashMapXgɓo^
			dbMapList.add(dbMap);

		}
		return dbMapList;
	
	}

	/**
	 * ڑ񃊃XgNA
	 *
	 */
	public void clearServers() {
		m_servers.clear();
	}


}
