package org.postgresforest.tool.commandline.action;

import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.action.CheckAction;
import org.postgresforest.tool.action.GscAction;
import org.postgresforest.tool.bean.GSCInfo;
import org.postgresforest.tool.bean.LoginInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

/**
 * GSCւ̃R}hCc[p̃ANV񋟂NX
 */
public class GscActions {
	
	/**
	 * GSC̐VK쐬
	 * @param loginInfo OC
	 */
	public void make(LoginInfo loginInfo) {
		GscAction gscAction = new GscAction(null);
		String gscName = loginInfo.getDbname();
		try {
			if( gscAction.makeGsc(loginInfo)) {
			    System.out.println(MessagesCommandLine.getString("cui.message.gsc.make", new Object[] {gscName})); //$NON-NLS-1$
			    return;
			}
		} catch (Exception e1) {
			e1.printStackTrace();
		}		
	    System.out.println(MessagesCommandLine.getString("cui.error.gsc.make", new Object[] {gscName})); //$NON-NLS-1$
	}

	/**
	 * GSC̒ǉ쐬
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */
	public void create(CommandParser cp, GSCdata gsc) {
		String gscName = (String)cp.getGsc().get(0);
		String serverid = (String)cp.getServer().get(0);		
		//O[oVXeJ^O쐬
		if(gscName != "" && serverid != ""){ //$NON-NLS-1$ //$NON-NLS-2$
			GscAction addGsc = new GscAction(gsc);
			if(	addGsc.addGsc(gscName, serverid) ){
				System.out.println(MessagesCommandLine.getString("cui.message.gsc.create", new Object[] {gscName, serverid})) ; //$NON-NLS-1$
				return;
			} 
		}
		System.out.println(MessagesCommandLine.getString("cui.error.gsc.create", new Object[] {gscName, serverid}) ); //$NON-NLS-1$
		
	}
	
	/**
	 * GSC̍폜
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */
	public void drop(CommandParser cp, GSCdata gsc) {
		//ŌGSC̍폜̏ꍇAmFbZ[W\
/*		if(view.isLastGsc()){
			Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
			if(!MessageDialog.openQuestion(shell, 
					Messages.getString("button.delete"), 
					Messages.getString("message.delgsc.confirm"))){
				return ;
			}
		}*/
		
		String gscName = (String)cp.getGsc().get(0);
		String serverid = (String)cp.getServer().get(0);		
		//O[oVXeJ^O폜
		if(gscName != "" && serverid != ""){ //$NON-NLS-1$ //$NON-NLS-2$
			GscAction delGsc = new GscAction(gsc);
			if(	delGsc.delGsc(gscName, serverid) ){
				System.out.println(MessagesCommandLine.getString("cui.message.gsc.drop", new Object[] {gscName, serverid}) ); //$NON-NLS-1$
				return;
			}
		}		
		System.out.println(MessagesCommandLine.getString("cui.error.gsc.drop", new Object[] {gscName, serverid}) ); //$NON-NLS-1$
	}
	
	/**
	 * GSC̐`FbN
	 * @param loginInfo OC
	 */
	public void check(LoginInfo loginInfo) {
		//O[oVXeJ^O`FbN
		try {
			CheckAction chkGsc = new CheckAction();
			if (chkGsc.execute(loginInfo)) {
				System.out.println(MessagesCommandLine.getString("cui.message.gsc.check")) ;		 //$NON-NLS-1$
				return;
			}
        } catch (Exception e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        }
		System.out.println(MessagesCommandLine.getString("cui.error.gsc.check") ); //$NON-NLS-1$
	}
	
	/**
	 * GSC̕\
	 * @param gsc GSCw̐ڑ
	 */
	public void show(GSCdata gsc) {
		//GSC擾
		ArrayList gscList = null;
		GscAction gscAct = new GscAction(gsc);
		try {
			gscList = gscAct.getGscList();
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.gsc.show")) ; //$NON-NLS-1$
			System.err.println(e);
			return;
		}

		
		//GSC\
		System.out.println(MessagesCommandLine.getString("cui.message.gsc.show")) ; //$NON-NLS-1$
		Iterator it = gscList.iterator();
		System.out.println(" DBNAME \t| HOST \t| PORT \t| SERVERID"); //$NON-NLS-1$
		System.out.println("----------------------------------------------"); //$NON-NLS-1$
		while (it.hasNext()) {
			GSCInfo gscInfo = (GSCInfo)it.next();
			System.out.print(gscInfo.getDb() + "\t| "); //$NON-NLS-1$
			System.out.print(gscInfo.getId() + "\t| "); //$NON-NLS-1$
			System.out.print(gscInfo.getHost() + "\t| "); //$NON-NLS-1$
			System.out.println(gscInfo.getPort());
		}
	}
}
