package org.postgresforest.tool.commandline.action;

import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.action.DbAction;
import org.postgresforest.tool.action.DbInstanceAction;
import org.postgresforest.tool.action.ExecDdl;
import org.postgresforest.tool.bean.AddDbInfo;
import org.postgresforest.tool.bean.DbLinkInfo;
import org.postgresforest.tool.bean.ServerDumpDataInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.DbBase;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

/**
 * f[^x[Xւ̃R}hCc[p̃ANV񋟂NX
 */
public class DbActions {

	/**
	 * DB̍쐬
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void create(CommandParser cp, GSCdata gsc) {
		//DB擾
		String dbName = (String)cp.getDB().get(0);
		//IvV擾
		String option = ""; //$NON-NLS-1$
		Iterator it = cp.getOption().iterator();
		while(it.hasNext()){
			option += (String)it.next();
		}
		
		ArrayList chkServerList = cp.getServer();
		// \p̃T[oXg̍쐬
		String serverListStr = "";
		int chksize = chkServerList.size();
		for (int i=0; i<chksize-1;i++) {
			serverListStr += (String)chkServerList.get(i) + ",";
		}
		serverListStr += chkServerList.get(chksize-1);		
		
		DbInstanceAction dbInstance = new DbInstanceAction(gsc);
		AddDbInfo addDbInfo;
		try {
			addDbInfo = dbInstance.getAddDbInfo();
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.db.create", new Object[] {dbName, serverListStr})); //$NON-NLS-1$
			System.err.println(e);
			return;
		}

		//DB쐬CX^X擾
		ArrayList serverList = addDbInfo.getServer();
		Iterator it2 = serverList.iterator();
		while(it2.hasNext()){
			ServerInfo srvInfo = (ServerInfo)it2.next();
			srvInfo.setChkFlag(false);
			int id = srvInfo.getId();
			Iterator it3 = chkServerList.iterator();
			while(it3.hasNext()){
				int chkServerId = Integer.parseInt((String)it3.next());
				if (id == chkServerId){
					srvInfo.setChkFlag(true);
				}
			}
		}
		
		//DB쐬̊i[
		addDbInfo.setDb(dbName);
		addDbInfo.setOption(option);
		addDbInfo.setMakeMode(DbBase.DB_MAKE);
		addDbInfo.setServer(serverList);

		// DB쐬
		DbAction addDb = new DbAction(gsc);
		if (addDb.add(addDbInfo)) {
			System.out.println(MessagesCommandLine.getString("cui.message.db.create", new Object[] {dbName, serverListStr}));			 //$NON-NLS-1$
			return;
		}
		System.out.println(MessagesCommandLine.getString("cui.error.db.create", new Object[] {dbName, serverListStr})); //$NON-NLS-1$
	}
	
	/**
	 * DB̍폜
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void drop(CommandParser cp, GSCdata gsc) {
		String dbName = (String)cp.getDB().get(0);
		//f[^x[X폜
		if(dbName != ""){ //$NON-NLS-1$
			//f[^x[XN擾
			ArrayList dbLinkList = getDbLinkList(gsc);
			
			//IĂf[^x[X̃T[o擾
			ArrayList dbServer = null;
			for (Iterator iter = dbLinkList.iterator(); iter.hasNext();) {
				DbLinkInfo dbInfo = (DbLinkInfo) iter.next();
				if (dbName.compareTo(dbInfo.getName()) == 0) {
					dbServer = dbInfo.getServer();
					break;
				}
			}

			for (Iterator iter= dbServer.iterator(); iter.hasNext();) {
				ServerInfo serverInfo = (ServerInfo) iter.next();
				serverInfo.setChkFlag(true); 
			}			

			//f[^x[X폜
			DbAction dbAction = new DbAction(gsc);
			try {
				if(dbAction.del(dbLinkList)){
					System.out.println(MessagesCommandLine.getString("cui.message.db.drop", new Object[] {dbName}) ); //$NON-NLS-1$
					return;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		System.out.println(MessagesCommandLine.getString("cui.error.db.drop", new Object[] {dbName}) ); //$NON-NLS-1$
	}

	/**
	 * DB̃XgA
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void restore(CommandParser cp, GSCdata gsc) {
		//DB擾
		String dbName = (String)cp.getDB().get(0);

		ArrayList chkServerList = cp.getServer();
		// \p̃T[oXg̍쐬
		String serverListStr = "";
		int chksize = chkServerList.size();
		for (int i=0; i<chksize-1;i++) {
			serverListStr += (String)chkServerList.get(i) + ",";
		}
		serverListStr += chkServerList.get(chksize-1);
		
		DbInstanceAction dbInstance = new DbInstanceAction(gsc);
		AddDbInfo addDbInfo;
		try {
			addDbInfo = dbInstance.getAddDbInfo();
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.db.restore", new Object[] {dbName, serverListStr}) ); //$NON-NLS-1$
			System.err.println(e);
			return;
		}
	
		//_vt@C擾
		ArrayList dumpFileList = cp.getDumpFile();
		//IvV擾
		String option = ""; //$NON-NLS-1$
		Iterator it = cp.getOption().iterator();
		while(it.hasNext()){
			option += (String)it.next();
		}
		//DB쐬CX^X擾
		ArrayList serverList = addDbInfo.getServer();
		Iterator it4 = serverList.iterator();
		while(it4.hasNext()){
			ServerDumpDataInfo srvInfo = (ServerDumpDataInfo)it4.next();
			int id = srvInfo.getId();
			srvInfo.setChkFlag(false);					
			Iterator it2 = chkServerList.iterator();
			Iterator it3 = dumpFileList.iterator();
			while(it2.hasNext()){
				int chkServerId = Integer.parseInt((String)it2.next());
				String dumpFile = (String)it3.next();
				if (id == chkServerId){
					srvInfo.setChkFlag(true);
					srvInfo.setDumpData(dumpFile);
				}
			}
		}

		//DB쐬̊i[
		addDbInfo.setDb(dbName);
		addDbInfo.setOption(option);
		addDbInfo.setMakeMode(DbBase.DB_SHIFT);
		addDbInfo.setServer(serverList);

		// DBIƃ_vt@C̐`FbN
		validateDumpFile(addDbInfo);
		
		//DB쐬
		DbAction addDb = new DbAction(gsc);
		if( addDb.add(addDbInfo) ){
			System.out.println(MessagesCommandLine.getString("cui.message.db.restore", new Object[] {dbName, serverListStr}) ); //$NON-NLS-1$
			return;
		}	
		System.out.println(MessagesCommandLine.getString("cui.error.db.restore", new Object[] {dbName, serverListStr}) ); //$NON-NLS-1$
	}
	
	/**
	 * DB̕\
	 * @param gsc GSCw̐ڑ
	 */	
	public void show(GSCdata gsc) {
		//DB擾
		ArrayList dbList = getDbLinkList(gsc);

		//DB\
		System.out.println(MessagesCommandLine.getString("cui.message.db.show")) ; //$NON-NLS-1$
		Iterator it = dbList.iterator();
		System.out.println(" DBNAME \t| SERVERID \t| HOST \t| PORT "); //$NON-NLS-1$
		System.out.println("----------------------------------------------"); //$NON-NLS-1$
		while (it.hasNext()) {
			DbLinkInfo dbLinkInfo = (DbLinkInfo)it.next();
			Iterator it2 = dbLinkInfo.getServer().iterator();
			while (it2.hasNext()) {
				ServerInfo srvInfo = (ServerInfo)it2.next();
				System.out.print(dbLinkInfo.getName() + "\t| "); //$NON-NLS-1$
				System.out.print(srvInfo.getId() + "\t| "); //$NON-NLS-1$
				System.out.print(srvInfo.getHost() + "\t| "); //$NON-NLS-1$
				System.out.println(srvInfo.getPort());
			}
		}
	}

	/**
	 * DBCX^X̒ǉ
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void createDbInstance(CommandParser cp, GSCdata gsc) {
		//DB擾
		String dbName = (String)cp.getDB().get(0);
		//_vt@C擾
		ArrayList dumpFileList = cp.getDumpFile();
		//IvV擾
		String option = ""; //$NON-NLS-1$
		Iterator it = cp.getOption().iterator();
		while(it.hasNext()){
			option += (String)it.next();
		}
		
		//w肳ꂽDB݂邩ǂ̃`FbN
		ArrayList dbList = getDbLinkList(gsc);
		Iterator itdb = dbList.iterator();
		boolean isDbExist = false;
		while (itdb.hasNext()) {
			DbLinkInfo dbLinkInfo = (DbLinkInfo)itdb.next();
			if (dbName.equals(dbLinkInfo.getName())){
				isDbExist = true;
			}
		}
		if (!isDbExist) {
			System.out.println(MessagesCommandLine.getString("cui.error.db.open.nosuchdb", new Object[] { dbName })) ;
			return;
		}
		
		ArrayList chkServerList = cp.getServer();
		// \p̃T[oXg̍쐬
		String serverListStr = "";
		int chksize = chkServerList.size();
		for (int i=0; i<chksize-1;i++) {
			serverListStr += (String)chkServerList.get(i) + ",";
		}
		serverListStr += chkServerList.get(chksize-1);
		
		DbInstanceAction dbInstance = new DbInstanceAction(gsc);
		AddDbInfo addDbInfo;
		try {
			addDbInfo = dbInstance.getAddDbInfo();
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.db.instance.add", new Object[] {dbName, serverListStr})) ; //$NON-NLS-1$
			System.err.println(e);
			return;
		}

 		// w肳ꂽDB̓o^ĂȂCX^X̃Xg쐬
		ArrayList existServerList = getExistServerList(gsc, dbName);
		ArrayList serverList = addDbInfo.getServer();

		for (Iterator iter2 = existServerList.iterator(); iter2.hasNext();) {
			ServerInfo existServerInfo = (ServerInfo) iter2.next();
			for (Iterator iter = serverList.iterator(); iter.hasNext();) {
				ServerInfo severInfo = (ServerInfo) iter.next();
				if( severInfo.getId() == existServerInfo.getId() ){
					serverList.remove(severInfo);
					break;
				}
			}
			
		}
	
		//DB쐬CX^X擾
		Iterator it4 = serverList.iterator();
		while(it4.hasNext()){
			ServerDumpDataInfo srvInfo = (ServerDumpDataInfo)it4.next();
			int id = srvInfo.getId();
			srvInfo.setChkFlag(false);					
			Iterator it2 = chkServerList.iterator();
			Iterator it3 = dumpFileList.iterator();
			while(it2.hasNext()){
				int chkServerId = Integer.parseInt((String)it2.next());
				String dumpFile = (String)it3.next();
				if (id == chkServerId){
					srvInfo.setChkFlag(true);
					srvInfo.setDumpData(dumpFile);
				}
			}
		}
		
		// `FbNCX^XDBɓo^ĂȂ̃`FbN
		// G[\p̃T[oXg̍쐬
		String existServerListStr = "";
		int servsize = serverList.size();
		for (int i=0; i<servsize-1;i++) {
			existServerListStr += Integer.toString(((ServerDumpDataInfo)serverList.get(i)).getId()) + ",";
		}
		if(servsize == 0) {
			System.out.println(MessagesCommandLine.getString("cui.error.db.instance.invalid.noaddinstance", new Object[] {dbName})) ; //$NON-NLS-1$				
			return;
		}
		existServerListStr += Integer.toString(((ServerDumpDataInfo)serverList.get(servsize-1)).getId()) ;
		Iterator it5 = chkServerList.iterator();
		while(it5.hasNext()){
			boolean existFlag = false;
			int chkServerId = Integer.parseInt((String)it5.next());
			Iterator it6 = serverList.iterator();
			while(it6.hasNext()){
				ServerDumpDataInfo srvInfo = (ServerDumpDataInfo)it6.next();
				int id = srvInfo.getId();
				if (id == chkServerId){
					existFlag = true;
				}
			}
			if (!existFlag) {
				System.out.println(MessagesCommandLine.getString("cui.error.db.instance.invalid", new Object[] {existServerListStr})) ; //$NON-NLS-1$				
				return;
			}
		}
		
		// DBIƃ_vt@C̐`FbN
		validateDumpFile(addDbInfo);
		
		//DB쐬̊i[
		addDbInfo.setDb(dbName);
		addDbInfo.setOption(option);
		addDbInfo.setMakeMode(DbBase.DB_ADD);
		addDbInfo.setServer(serverList);

		//DB쐬
		DbAction addDb = new DbAction(gsc);
		if( addDb.add(addDbInfo) ){
			System.out.println(MessagesCommandLine.getString("cui.message.db.instance.add", new Object[] {dbName, serverListStr})) ; //$NON-NLS-1$
			return;
		}
		System.out.println(MessagesCommandLine.getString("cui.error.db.instance.add", new Object[] {dbName, serverListStr})) ; //$NON-NLS-1$
	}
	
	/**
	 * DBCX^X̍폜
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void dropDbInstance(CommandParser cp, GSCdata gsc) {
		String dbName = (String)cp.getDB().get(0);
		int selectId = Integer.parseInt((String)cp.getServer().get(0));
		//f[^x[X폜
		if(dbName != "" && selectId >= 0){ //$NON-NLS-1$

			//ZbVvpeBf[^x[XN擾
			ArrayList dbLinkList = getDbLinkList(gsc);
			
			//IĂf[^x[X̃T[o擾
			ArrayList dbServer = null;
			for (Iterator iter = dbLinkList.iterator(); iter.hasNext();) {
				DbLinkInfo dbInfo = (DbLinkInfo) iter.next();
				if (dbName.compareTo(dbInfo.getName()) == 0) {
					dbServer = dbInfo.getServer();
					break;
				}
			}

			//
			for (Iterator iter= dbServer.iterator(); iter.hasNext();) {
				ServerInfo serverInfo = (ServerInfo) iter.next();
				if (serverInfo.getId() == selectId) {
					serverInfo.setChkFlag(true);
					break;
				}
			}

			//f[^x[X폜
			DbAction dbAction = new DbAction(gsc);
			try {
				if (dbAction.del(dbLinkList)) {
					System.out.println(MessagesCommandLine.getString("cui.message.db.instance.delete", new Object[] {dbName, Integer.toString(selectId)})) ;		
					return;
				}
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		System.out.println(MessagesCommandLine.getString("cui.error.db.instance.delete", new Object[] {dbName, Integer.toString(selectId)})) ; //$NON-NLS-1$
		
	}
	
	/**
	 * DDLR}h̎s
	 * @param gsc GSCw̐ڑ
	 * @param command DDLR}h
	 * @param selectDb f[^x[X
	 */	
	public void executeDdl(GSCdata gsc, String command, String selectDb) {
		String dbName = null;
		if (selectDb != null) {
			dbName = selectDb;
		} else {
			System.err.print(MessagesCommandLine.getString("cui.message.db.notopen", new Object[] {dbName})); //$NON-NLS-1$
			return;
		}
		ExecDdl execDdl = new ExecDdl(gsc, dbName);
		try {
			if (execDdl.executeMain(command)) {
				System.out.println(MessagesCommandLine.getString("cui.message.db.ddl.execute", new Object[] {dbName})) ;				 //$NON-NLS-1$
				return;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}				
		System.out.println(MessagesCommandLine.getString("cui.error.db.ddl.execute", new Object[] {dbName})) ;				 //$NON-NLS-1$
	}

	/**
	 * f[^x[X̃I[v
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public boolean open(CommandParser cp, GSCdata gsc) {
		boolean ret = false;		
		String dbName = (String)cp.getDB().get(0);
		//DB擾
		ArrayList dbList = getDbLinkList(gsc);
		//DB\
		Iterator it = dbList.iterator();
		while (it.hasNext()) {
			DbLinkInfo dbLinkInfo = (DbLinkInfo)it.next();
			if (dbName.compareToIgnoreCase(dbLinkInfo.getName()) == 0) {
				ret = true;
				break;
			}
		}
		return ret;
	}
	
	/**
	 * f[^x[Xꗗ̎擾
	 * @param gsc GSCw̐ڑ
	 */
	private ArrayList getDbLinkList(GSCdata gsc) {
		ArrayList dbList = null;
		DbInstanceAction dbInstance = new DbInstanceAction(gsc);
		try {
			dbList = dbInstance.getDbLinkList();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return dbList;
	}
	
	private ArrayList getExistServerList(GSCdata gsc, String dbName) {
		ArrayList serverList = null;
		ArrayList servDbList = getDbLinkList(gsc);
		Iterator it = servDbList.iterator();
		while (it.hasNext()) {
			DbLinkInfo dbLinkInfo = (DbLinkInfo)it.next();
			if (dbName.equals(dbLinkInfo.getName())) {
				serverList = dbLinkInfo.getServer();
			}
		}
		return serverList;
	}

    /* ( Javadoc)
     * @see org.postgresforest.tool.dialog.CommonDialog#validate()
     */
    private boolean validateDumpFile(AddDbInfo m_addDb) {
    	boolean isValid = false;
    	
		ArrayList serverList = m_addDb.getServer();
		for (Iterator iter = serverList.iterator(); iter.hasNext();) {
		    ServerDumpDataInfo serverInfo = (ServerDumpDataInfo) iter.next();
		    String dumpdata = serverInfo.getDumpData();
		    boolean isChkServer = serverInfo.isChkFlag();
		    if(isChkServer && (dumpdata == null || dumpdata.equals(""))){
				System.out.println(MessagesCommandLine.getString("errors.dump.input" ));
				return isValid;
		    }
            
        }
		isValid = true;
		return isValid;

    }	
}
