package org.postgresforest.tool.commandline.action;

import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.action.BrokenLogAction;
import org.postgresforest.tool.bean.BrokenLogInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.MessagesCommandLine;

/**
 * O[oVXeJ^ÕOւ̃R}hCc[p̃ANV񋟂NX
 */
public class BrokenLogActions {

	/**
	 * O̕\
	 * @param gsc GSCw̐ڑ
	 */	
	public void show(GSCdata gsc) {
		ArrayList brokenLogList = null;

		//T[o擾
		BrokenLogAction brokenLogAction = new BrokenLogAction(gsc);
		try {
			brokenLogList = brokenLogAction.getList();
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.brokenlog.show")) ; //$NON-NLS-1$
			e.printStackTrace();
			return;
		}
		
		//O\
		System.out.println(MessagesCommandLine.getString("cui.message.brokenlog.show")) ; //$NON-NLS-1$
		Iterator it = brokenLogList.iterator();
		System.out.println(" SERVERID\t| DATETIME\t| CLIENT\t| MSG\t| STATUS\t| QUERY"); //$NON-NLS-1$
		System.out.println("----------------------------------------------"); //$NON-NLS-1$
		while (it.hasNext()) {
			BrokenLogInfo logInfo = (BrokenLogInfo)it.next();
			System.out.print(logInfo.getServerid() + "\t| "); //$NON-NLS-1$
			System.out.print(logInfo.getDatetime() + "\t| "); //$NON-NLS-1$
			System.out.print(logInfo.getClient() + "\t| "); //$NON-NLS-1$
			System.out.print(logInfo.getMsg() + "\t| "); //$NON-NLS-1$
			System.out.print(logInfo.getStatus() + "\t| "); //$NON-NLS-1$
			System.out.println(logInfo.getQuery());
		}	
	}

	/**
	 * ÕNA
	 * @param gsc GSCw̐ڑ
	 */	
	public void clear(GSCdata gsc) {
		ArrayList brokenLogList = null;		
		//T[o擾
		BrokenLogAction brokenLogAction = new BrokenLogAction(gsc);
		try {
			brokenLogList = brokenLogAction.getList();
			if (brokenLogAction.del(brokenLogList)){
				System.out.println(MessagesCommandLine.getString("cui.message.brokenlog.clear")) ; //$NON-NLS-1$
				return;
			}
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		System.out.println(MessagesCommandLine.getString("cui.error.brokenlog.clear")) ; //$NON-NLS-1$
		
	}
}
