/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.actionset;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.console.IConsoleConstants;
import org.postgresforest.tool.action.CheckAction;
import org.postgresforest.tool.bean.LoginInfo;
import org.postgresforest.tool.dialog.gsccheck.CheckDialog;
import org.postgresforest.tool.util.LoginHistry;
import org.postgresforest.tool.view.ViewUtil;

/**
 *
 * GSCCheckAction
 * @version $Revision: 1.1.1.1 $
 * @since 
 */
public class GSCCheckAction implements IWorkbenchWindowActionDelegate {

    /* ( Javadoc)
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
     */
    public void dispose() {
        // TODO ꂽ\bhEX^u

    }

    /* ( Javadoc)
     * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
     */
    public void init(IWorkbenchWindow window) {
        // TODO ꂽ\bhEX^u

    }

    /* ( Javadoc)
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
		LoginHistry loginhistry = new LoginHistry(LoginHistry.CHECK);
		List loginlist = loginhistry.load();
		
		//Ǘ҃OC_CAO\
		CheckDialog dialog = new CheckDialog(loginlist);
		
		
		if (dialog.open() == Window.OK) {
		    //OCi[
			LoginInfo loginInfo = dialog.getLoginInfo();

			loginhistry.save(loginInfo);
			
			try {
                new CheckAction().execute(loginInfo);
            } catch (Exception e) {
                // TODO ꂽ catch ubN
                e.printStackTrace();
            }

            ViewUtil.updateView(IConsoleConstants.ID_CONSOLE_VIEW,true,false);

		}
    }

    /* ( Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
        // TODO ꂽ\bhEX^u

    }

}
