/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.db.UserData;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.StringReplaceUtil;

/**
 * [U쐬ANV
 * 
 * <pre>
 * ͏"userForm"Aȉ̏sBgsc	
 * E[U̍쐬(CREATE USER)
 * </pre>
 *
 */
public class UserMngAction extends ActionBase {

	/**
	 * @param gsc
	 */
	public UserMngAction(GSCdata gsc) {
		super(gsc);
		// TODO ꂽRXgN^[EX^u
	}
	/**
	 * [U쐬C
	 * 
	 * @see org.postgresforest.tool.action.AdminActionBase#executeMain(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.http.HttpSession, org.postgresforest.tool.db.GSCdata)
	 */
	public boolean addUser(String user,
			String password,
			String passwordOption,
			String createDbOption,
			String createUserOption)  {
		
		boolean ret = false;

		
		//--------------
		// ͏擾
		//--------------
		StringBuffer option = new StringBuffer();
		option.append(createDbOption);
		option.append(" ");
		option.append(createUserOption);
		option.append(" ");

		//pX[h̓`FbN
		if(password.trim().length() == 0){
//			MsgDialogUtil.err("errors.required",MessagesCommandLine.getString("form.password"));
			System.err.println(MessagesCommandLine.getString("errors.required", new Object[] { MessagesCommandLine.getString("form.password")}));
			return ret; 
		}


		UserData userData = new UserData(m_gsc.getUserPassword());

		try {
			if (!connectSelect(m_gsc)) {
				return ret; 
			}

			//CX^X擾
			ArrayList serverList;
			try {
				serverList = m_gsc.getServerList();
			} catch (SQLException e) {
				setAccessErrs( m_gsc);
				return ret; 
			}
			for (Iterator iter = serverList.iterator(); iter.hasNext();) {
				ServerInfo serverInfo = (ServerInfo) iter.next();
				String host = serverInfo.getHost();
				String port = serverInfo.getPort();

				//[UDBNXɒǉ
				userData.addUrl(host, port);
			}

			//--------------
			// [Uf[^x[XɃ[U쐬
			//--------------
			//ڑ
			if (!connectTemlate(userData)) {
				return ret;
			}

			//[U쐬
			if (!userData.makeUser(user, password, passwordOption, option.toString())) { //Ver1.1
				setAccessErrs("errors.user.create", userData);
				return ret; 
			} else {
				StringReplaceUtil strUtil =
					new StringReplaceUtil(MessagesCommandLine.getString("message.user.create"));
				strUtil.set(1, user);
				
//				MsgDialogUtil.info(strUtil.get());

			}

			userData.commit();
			ret = true;
				

		} finally {
			m_gsc.close();
			userData.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				ret = false;
			}
			if( userData.isErrInfo() ){
				setAccessErrs(userData);
				ret = false;
			}
		}

		return ret;

	}
	/**
	 * [U폜C
	 * 
	 * @see org.postgresforest.tool.action.AdminActionBase#executeMain(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.http.HttpSession, org.postgresforest.tool.db.GSCdata)
	 */
	public boolean delUser(String user)  {

		boolean ret = false;
		
		UserData userData = new UserData(m_gsc.getUserPassword());

		try {

			if (!connectSelect(m_gsc)) {
				return ret;
			}
			//CX^X擾
			ArrayList serverList;
			try {
				serverList = m_gsc.getServerList();
			} catch (SQLException e) {
				setAccessErrs(m_gsc);
				return ret;
			}
			for (Iterator iter = serverList.iterator(); iter.hasNext();) {
				ServerInfo serverInfo = (ServerInfo) iter.next();
				String host = serverInfo.getHost();
				String port = serverInfo.getPort();

				//[UDBNXɒǉ
				userData.addUrl(host, port);
			}

			//--------------
			// [Uf[^x[X烆[U폜
			//--------------
			//ڑ
			if (connectTemlate(userData)) {

				//[U쐬
				if (!userData.delUser(user)) {
					setAccessErrs("errors.user.drop", userData);
				} else {
					StringReplaceUtil strUtil =
						new StringReplaceUtil(MessagesCommandLine.getString("message.user.drop"));
					strUtil.set(1, user);

//					MsgDialogUtil.info(strUtil.get());
	
				}

				userData.commit();
				ret = true;

			}

		} finally {
			m_gsc.close();
			userData.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				ret = false;
			}
			if( userData.isErrInfo() ){
				setAccessErrs(userData);
				ret = false;
			}
		}

		return ret;
	}
    /**
     * [U[ꗗ쐬C
     * 
	 * @see org.postgresforest.tool.action.AdminActionBase#executeMain(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.http.HttpSession, org.postgresforest.tool.db.GSCdata)
     */
	public ArrayList getUserList() throws Exception {

		//[UDBNX
		UserData userData = new UserData(m_gsc.getUserPassword());

		ArrayList userList = null;
		try {

			//GSC֐ڑ
			if (!connectSelect(m_gsc)) {
				return null; 
			}


			//--------------
			// GSC@T[o擾
			//--------------

			//T[oIDŃCX^X擾
			Integer[] serverId = {new Integer(0)};
			
			ArrayList serverList = m_gsc.getServerList(serverId);

			//--------------
			// [U쐬
			//--------------
			//ڑZbg
			ServerInfo serverInfo = (ServerInfo) serverList.get(0);
			String host = serverInfo.getHost();
			String port = serverInfo.getPort();

			//[UDBNXɒǉ
			userData.addUrl(host, port, UserData.TEMLATE_DB);

			//template1DBɐڑ
			if (connectSelect(userData)) {
				userList = userData.getUserList();
			}

		} catch (SQLException e) {
			return null;

		} finally {
			m_gsc.close();
			userData.close();
		}

		return userList;
    }
	
}
