/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.db.UserData;
import org.postgresforest.tool.util.MessagesCommandLine;
//Eclipseˑr
//import org.postgresforest.tool.util.MsgDialogUtil;
import org.postgresforest.tool.util.Parser;
import org.postgresforest.tool.util.ReWriter;

/**
 * DDLsANV
 * 
 * <pre>
 * ͏"ddlform"(DynaValidatorForm)́ADDL[Uf[^x[Xɑ΂ĎsB
 * DDL͍\͂sAeDDLɑ΂ȉ̂悤ɏÁB
 * ECREATE TABLE
 *   GSCփe[uiforest_tablepart,forest_tablepartdtlj}
 *   DDLe[Uf[^x[XŎsB
 * EDROP TABLE
 *   GSCփe[uiforest_tablepart,forest_tablepartdtlj폜
 *   DDLe[Uf[^x[XŎsB
 * EALTER TABLE
 *   w肳ꂽe[uAp[eBVe[uȂ
 * @e[ue[uɒuAe[uDDLe[Uf[^x[XŎsB
 * ECREATE INDEX
 *   w肳ꂽe[uAp[eBVe[uȂ
 * @e[ue[uACfbNXCfbNX_00ip[eBVNojɒuA
 * @e[uDDLe[Uf[^x[XŎsB
 * Ȇ
 *   DDLe[Uf[^x[XŎsB
 * 
 * </pre>
 * @see org.apache.struts.validator.DynaValidatorForm
 */
public class ExecDdl extends ActionBase {

//	protected StringBuffer m_results;
	private UserData m_userData;

	/**
	 * @param gsc
	 */
	public ExecDdl(GSCdata gsc, String dbName) {
		super(gsc);
		//[U[f[^NX擾
		m_userData = new UserLoginMng(gsc).getUserDb(dbName);
	}
	/**
	 * DDLsC
	 * 
	 * @see org.postgresforest.tool.action.UserActionBase#executeMain(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.http.HttpSession, org.postgresforest.tool.db.GSCdata, org.postgresforest.tool.db.UserData)
	 */
	public boolean executeMain(String ddlSql)  {

		boolean statusOk = false;

		
		
		//[U[f[^x[X擾
		
		String dbName = m_userData.getDbName();
		

		//DDL̒o
		//';'ŋ؂ꂽDDL𒊏o
		ArrayList sqlList = new ArrayList();
		
		StringTokenizer t = new StringTokenizer( ddlSql, ";" ); //$NON-NLS-1$
		while (t.hasMoreTokens()) {
		    String wkSql =t.nextToken();
		    wkSql = wkSql.replaceFirst("\\s*",""); //$NON-NLS-1$ //$NON-NLS-2$
		    if( wkSql.length() != 0){
		        sqlList.add(wkSql);
		    }
		}


		
		//ڑ
		if (!connect(m_gsc)
			|| !connect(m_userData)) {
			return false; 
		}
		
		try {
			//DDLs
			for (Iterator iter1 = sqlList.iterator(); iter1.hasNext();) {
				ddlSql = (String) iter1.next();

				System.out.println(MessagesCommandLine.getString("message.ddl.header")); //$NON-NLS-1$
				System.out.println(ddlSql);

				statusOk = false;
				
				//͂ꂽDDL̍\
				Parser paser;
				try {
					ddlSql = ReWriter.toLowerSql(ddlSql);
					paser = new Parser(ddlSql);
				} catch (Exception e) {
					//@@\[X
					System.out.println(MessagesCommandLine.getString("message.ddl.error")); //$NON-NLS-1$
					e.printStackTrace();
					System.out.println(MessagesCommandLine.getString("message.ddl.error.detail") ); //$NON-NLS-1$
					System.out.println("\n\n"); //$NON-NLS-1$
					continue;
				}
				String tableName = null; 
				int partitionCount = 0;
				int type = paser.getType();
				switch (type) {
					case Parser.CREATE_VIEW ://CREATE VIEW 𑽏de[uƂēo^
					case Parser.CREATE_TABLE :
	
						//͂ꂽDDLCREATE TABLEꍇAforest_tableparte[uforest_tablepartdtle[uփR[hǉ܂B
	
						//----------------
						//GSCXV
						//----------------
						if (!m_gsc.addTable(dbName, (String)paser.getTables().get(0)) ) {
							m_gsc.rollback();
							setAccessErrs(m_gsc);
							break; 
						}
						
						//----------------
						//DDLs
						//----------------
						if (!m_userData.execDdl(ddlSql)) {
							m_gsc.rollback();
							m_userData.rollback();
							setAccessErrs(m_userData);
							break; 
						}
						
						//----------------
						//GSCXV
						//----------------
						if (!m_gsc.updateConfigDate()) {
							m_gsc.rollback();
							setAccessErrs(m_gsc);
							break; 
						}
						
						
						
						m_gsc.commit();
						m_userData.commit();
	
						statusOk = true;
						break;
	
					case Parser.DROP_VIEW ://CREATE VIEW 𑽏de[uƂēo^
					case Parser.DROP_TABLE :
						//͂ꂽDDLADROP TABLEꍇAforest_tableparte[uforest_tablepartdtle[u背R[h폜܂B
	
								
						//----------------
						//GSCXV
						//----------------
						for (Iterator iter = paser.getTables().iterator();
								iter.hasNext();
								) {
		
							tableName = (String)iter.next();
							if (!m_gsc.delTable(dbName, tableName)) {
								m_gsc.rollback();
								setAccessErrs(m_gsc);
								break; 
							}
						}
						//----------------
						//DDLs
						//----------------
						if (!m_userData.execDdl(ddlSql)) {
							m_gsc.rollback();
							m_userData.rollback();
							setAccessErrs(m_userData);
							break; 
						}

						//----------------
						//GSCXV
						//----------------
						if (!m_gsc.updateConfigDate()) {
							m_gsc.rollback();
							setAccessErrs(m_gsc);
							break; 
						}

						m_gsc.commit();
						m_userData.commit();
	
						statusOk = true;
						break;
	
					case Parser.ALTER_TABLE :
	
	
						//܂܂e[uAp[eBVĂ΁Ae[uփCg
						tableName = (String)paser.getTables().get(0);
						try {
							partitionCount =
								m_gsc.getPartitionCount(dbName, tableName);
						} catch (SQLException e) {
							setAccessErrs(m_gsc);
						}
						if (partitionCount > 1) {
							String ddlSqls[] =
								ReWriter.rewrite(
									ddlSql,
									tableName,
									partitionCount);
	
							//----------------
							//DDLs
							//----------------
							if (!m_userData.execDdl(ddlSqls)) {
								m_userData.rollback();
								setAccessErrs(m_userData);
								break; 
							}
	
						} else {
							//----------------
							//DDLs
							//----------------
							if (!m_userData.execDdl(ddlSql)) {
								m_userData.rollback();
								setAccessErrs(m_userData);
								break; 
							}
						}
	
						m_userData.commit();
	
						statusOk = true;
						break;
	
					case Parser.CREATE_INDEX :
	
	
						//܂܂e[uAp[eBVĂ΁Ae[uփCg
						tableName = (String)paser.getTables().get(0);
						try {
							partitionCount =
								m_gsc.getPartitionCount(dbName, tableName);
						} catch (SQLException e1) {
							setAccessErrs(m_gsc);
						}
						if (partitionCount > 1) {
							//indexp[eBVio[ăCg
							String ddlSqls[] =
								ReWriter.rewrite(
									ddlSql,
									paser.getReplaceWord(),
									tableName,
									partitionCount);
	
							//----------------
							//DDLs
							//----------------
							if (!m_userData.execDdl(ddlSqls)) {
								m_userData.rollback();
								setAccessErrs(m_userData);
								break; 
							}
	
						} else {
							//----------------
							//DDLs
							//----------------
							if (!m_userData.execDdl(ddlSql)) {
								m_userData.rollback();
								setAccessErrs(m_userData);
								break; 
							}
						}
	
						m_userData.commit();
	
						statusOk = true;
						break;
	
					case Parser.DML :
						
					    
					    System.out.println(MessagesCommandLine.getString("message.ddl.skip")); //$NON-NLS-1$
						System.out.print(MessagesCommandLine.getString("message.ddl.result")); //$NON-NLS-1$
						System.out.println(MessagesCommandLine.getString("message.ddl.skip") ); //$NON-NLS-1$
						System.out.println();
						continue;
						
					    
					    
					default :
	
	
						//----------------
						//DDLs
						//----------------
						if (!m_userData.execDdl(ddlSql)) {
							m_userData.rollback();
							setAccessErrs(m_userData);
							break; 
						}
	
					m_userData.commit();
	
						statusOk = true;
						break;
	
				}
				System.out.print(MessagesCommandLine.getString("message.ddl.result")); //$NON-NLS-1$
				if( statusOk ) {
				    System.out.println(MessagesCommandLine.getString("message.ddl.execute") ); //$NON-NLS-1$
				}else{
				    System.out.println(MessagesCommandLine.getString("message.ddl.error.detail") ); //$NON-NLS-1$
				    System.out.println("\n"); //$NON-NLS-1$
					continue;
				}
				System.out.println("\n"); //$NON-NLS-1$

			}
		} finally {
			m_gsc.close();
			m_userData.close();
		}


		return true;

	}

}
