/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.bean.AddDbInfo;
import org.postgresforest.tool.bean.ServerDumpDataInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.GSCdata;

/**
 * f[^x[XN񐶐
 * 
 * f[^x[XN쐬B
 *
 */
public class DbInstanceAction extends ActionBase {

	/**
	 * @param gsc
	 */
	public DbInstanceAction(GSCdata gsc) {
		super(gsc);
	}
	/**
	 * f[^x[XN쐬
	 * 
	 */
	public ArrayList getDbLinkList() throws Exception {
		ArrayList dbLinkList = null;
		

		//f[^쐬
		try {
			//ڑ
			if (!connectSelect(m_gsc)) {
				return null;
			}
			
			//T[o𐶐
			ArrayList serverList = m_gsc.getServerList();

			//DB-T[õN𐶐
			dbLinkList = m_gsc.getDbLinkList(serverList);
			
		} finally {
			//TODOMASU قƂɂȂƂẮH
			if(m_gsc != null){
				m_gsc.close();
			}
		}

		return dbLinkList;
	}
	
	/**
	 * f[^x[X쐬쐬
	 * 
	 */
	public AddDbInfo getAddDbInfo() throws Exception {
		AddDbInfo addDb = null;
		
		//f[^쐬
		try {
			//ڑ
			if (!connectSelect(m_gsc)) {
				throw new Exception();
			}
			
			//T[o𐶐
			ArrayList serverList = m_gsc.getServerList();

			//--------------
			//DB쐬p̃tH[Zbg
			//--------------
			addDb = new AddDbInfo();
			ArrayList serverDumpDataList = new ArrayList();
			for (Iterator iterator = serverList.iterator();iterator.hasNext();) {
				ServerInfo serverInfo = (ServerInfo) iterator.next();
				ServerDumpDataInfo info =
					new ServerDumpDataInfo();
				info.setHost(serverInfo.getHost());
				info.setId(serverInfo.getId());
				info.setPort(serverInfo.getPort());
				info.setStatus(serverInfo.getStatus());
				info.setChangeStatus(serverInfo.getChangeStatus());
				info.setChkFlag(true);
				info.setDumpData("");
				serverDumpDataList.add(info);
			}
			addDb.setServer(serverDumpDataList);
			
		} finally {
			m_gsc.close();
		}

		return addDb;
	}
	/**
	 * CX^Xo^
	 * 
	 */
	public boolean addInstance(String host, String port)  {
		
		try {
			//GSC֐ڑ
			if (!connect(m_gsc)) {
				return false; 
			}
			
			//f[^XV
			if (!m_gsc.addServer(host, port)) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false;
			}
			//----------------
			//GSCXVXV
			//----------------
			if (!m_gsc.updateConfigDate()) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false;
			}

			m_gsc.commit();

		} finally {
			m_gsc.close();
		}
		
		return true;
	}	
	/**
	 * CX^X폜
	 * 
	 */
	public boolean delInstance(String id)  {
		
		try {
			if (!connect(m_gsc)) {
				return false; 
			}

			//f[^XV
			if (!m_gsc.delServer(Integer.parseInt(id))) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false;
			}

			//----------------
			//GSCXVXV
			//----------------
			if (!m_gsc.updateConfigDate()) {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false;
			}

			m_gsc.commit();

		} finally {
			m_gsc.close();
		}
		return true;
	}	
}
