/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.ForestToolCommandLine;
import org.postgresforest.tool.db.DbBase;
import org.postgresforest.tool.db.ErrInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.StringReplaceUtil;

/**
 * ANVNX
 * 
 * ANVNXł̋ʒ`A`
 * 
 */
abstract public class ActionBase {

	protected GSCdata m_gsc = null;

	/**
	 * @param gsc
	 */
	public ActionBase(GSCdata gsc) {
		super();
		m_gsc = gsc;
	}
	
	/**
	 * f[^x[Xڑ
	 * 
	 * f[^x[XANZXNXconnect\bhĂяoAf[^x[X֐ڑB
	 * sɂ́ANGXgNXɃG[ZbgB
	 * 
	 * @param db f[^x[XANZXNX
	 * @param request	NGXgNX
	 * @return	true:ڑ.false:ڑs
	 */
	protected boolean connect(DbBase db) {


		return 	connect(db,false);

	}

	/**
	 * f[^x[Xڑ
	 * 
	 * f[^x[XANZXNXconnect\bhĂяoAf[^x[X֐ڑB
	 * sɂ́ANGXgNXɃG[ZbgB
	 * 
	 * @param db f[^x[XANZXNX
	 * @param request	NGXgNX
	 * @return	true:ڑ.false:ڑs
	 */
	protected boolean connect(DbBase db, boolean autocommit) {

		if (!db.connect(autocommit)) {

			setAccessErrs("errors.db.connect", db);

			return false;
		}

		return true;

	}

	
	/**
	 * templatef[^x[Xڑ
	 * 
	 * f[^x[XANZXNXconnectTemlate\bhĂяoA
	 * "template1"f[^x[X֐ڑB
	 * sɂ́ANGXgNXɃG[ZbgB
	 * 
	 * @param db f[^x[XANZXNX
	 * @param request	NGXgNX
	 * @return	true:ڑ.false:ڑs
	 */
	protected boolean connectTemlate(DbBase db) {

		if (!db.connectTemplate()) {

			setAccessErrs("errors.db.connect", db);

			return false;
		}

		return true;

	}

	/**
	 * pf[^x[Xڑ
	 * 
	 * f[^x[XANZXNXconnectSelect\bhĂяoA
	 * f[^x[X֐ڑB
	 * sɂ́ANGXgNXɃG[ZbgB
	 * 
	 * @param db f[^x[XANZXNX
	 * @param request	NGXgNX
	 * @return	true:ڑ.false:ڑs
	 */
	protected boolean connectSelect(DbBase db) {
		//TODOMASU قƂɂȂƂẮH
		if(db == null){
			return false;
		}
		if (!db.connectSELECT()) {

			setAccessErrs("errors.db.connect", db);

			return false;
		}

		return true;

	}

	/**
	 * f[^x[XANZXG[
	 * 
	 * bZ[Wkeyherrors.dbhActionErrors̐ݒ
	 * 
	 * @param db f[^x[XANZXNX
	 * @param request	NGXgNX
	 */
	protected void setAccessErrs(DbBase db) {
		setAccessErrs("errors.db", db);
	}

	/**
	 * f[^x[XANZXG[
	 * 
	 * G[bZ[WkeyActionError𐶐A
	 * f[^x[XANZXNXG[oA
	 * ڑƁAG[bZ[WActionError𐶐B
	 * ActionErroesɊi[ANGXgNX֓o^B
	 * 
	 * @param key@G[bZ[Wkey	
	 * @param db f[^x[XANZXNX
	 * @param request	NGXgNX
	 */
	protected void setAccessErrs(
		String key,
		DbBase db) {
		
//		ForestToolPlugin plugin = ForestToolPlugin.getDefault();
		ForestToolCommandLine plugin = ForestToolCommandLine.getDefault();

//		try{
//			Exception exception = null;
			String errMessage = "";
			
			ArrayList errInfoList = db.getErrInfoList();
			for (Iterator iter = errInfoList.iterator(); iter.hasNext();) {
				ErrInfo errInfo = (ErrInfo) iter.next();
				
				StringReplaceUtil strUtil =
					new StringReplaceUtil(MessagesCommandLine.getString("errors.db.detail"));
				strUtil.set(1, errInfo.getUrl());
				strUtil.set(2, errInfo.getErrMessage());
				errMessage = errMessage + strUtil.get() + "\n";
			}
			// @@@ Todo
			System.out.println(errMessage);
			
			/*
			IStatus status = new Status(IStatus.ERROR,
					plugin.getBundle().getSymbolicName(),
					0,
					errMessage,
					exception);
		
			throw new CoreException(status);
			
		} catch (CoreException e){
			//G[_CAO\
			MsgDialogUtil.err( 
					Messages.getString(key), 
					e.getStatus());
			
			//G[Oo
			IStatus status = new Status(IStatus.ERROR,
					plugin.getBundle().getSymbolicName(),
					0,
					Messages.getString(key),
					e);
			plugin.getLog().log(status);
		} finally{
*/
			db.clearErrInfoList();
//		}
	}

}
