/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.postgresforest.tool.view.brokenlog.BrokenLogView;
import org.postgresforest.tool.view.config.ConfigView;
import org.postgresforest.tool.view.dbinstance.DbInstanceView;
import org.postgresforest.tool.view.ddl.DdlView;
import org.postgresforest.tool.view.hash.HashView;
import org.postgresforest.tool.view.menu.AdminMenuView;
import org.postgresforest.tool.view.partitionlist.PartitionListView;
import org.postgresforest.tool.view.serverstatus.ServerStatusView;
import org.postgresforest.tool.view.tablecolumn.TableColumnView;
import org.postgresforest.tool.view.user.UserView;

/**
 * PostgresForest\zc[pp[XyNeBuNX
 *
 * PostgresForest\zc[p̃p[XyNeBuݒ肷
 */
public class ForestToolPerspective implements IPerspectiveFactory {

	/**
	 * p[XyNeBȕCAEg쐬
	 * 
	 * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
	 */
	public void createInitialLayout(IPageLayout layout) {
		
		//Ǘ҃c[̃ANVZbgǉ
	    layout.addActionSet("ForestTool.AdminActionSet");
	    
	    //GfB^̈\ɂ
	    layout.setEditorAreaVisible(false);
	    
	    //GfB^̈ID擾
	    String editorArea = layout.getEditorArea();
	    //GfB^̈̏㕔80%߂tH_쐬
	    IFolderLayout top =
	    	layout.createFolder(
	    			"top",
					IPageLayout.TOP,
					(float) 0.7f,
					editorArea);
	    //ID=top̃tH_̍50%߂tH_̍쐬
	    IFolderLayout topLeft =
	    	layout.createFolder(
	    			"topLeft",
					IPageLayout.LEFT,
					(float) 1/5f,
	    			"top");

	    //ID=topLeft̃tH_̏㑤50%߂tH_̍쐬
	    IFolderLayout topTop =
	    	layout.createFolder(
	    			"topTop",
					IPageLayout.TOP,
					(float) 0.5f,
	    			"top");

	    IFolderLayout topTopLeft =
	    	layout.createFolder(
	    			"topTopLeft",
					IPageLayout.LEFT,
					(float) 1/2f,
	    			"topTop");
	    
	    IFolderLayout topLeft1 =
	    	layout.createFolder(
	    			"topLeft1",
					IPageLayout.LEFT,
					(float) 1/2f,
	    			"top");

	    //TODOMASU e[uXg͂Ȃ
//	    IFolderLayout topLeft2 =
//	    	layout.createFolder(
//	    			"topLeft2",
//					IPageLayout.LEFT,
//					(float) 1/3f,
//	    			"top");

//	    IFolderLayout topLeft3 =
//	    	layout.createFolder(
//	    			"topLeft3",
//					IPageLayout.LEFT,
//					(float) 1/2f,
//	    			"top");

	    
	    //GfB^̈̉30%߂tH_쐬
	    IFolderLayout bottom =
	    	layout.createFolder(
	    			"bottom",
					IPageLayout.BOTTOM,
					(float) 0.3f,
					editorArea);

	    IFolderLayout bottomLeft =
	    	layout.createFolder(
	    			"bottomLeft",
					IPageLayout.LEFT,
					(float) 0.3f,
					"bottom");

	    
	    //Ǘ҃c[̃r[ǉ
	    topLeft.addView(AdminMenuView.ID);
	    topTopLeft.addView(ServerStatusView.ID);
//	    topTop.addView(GscView.ID);
	    topTop.addView(UserView.ID);
	    topTop.addView(ConfigView.ID);
	    topTop.addView(HashView.ID);
	   
	    
	    
	    topLeft1.addView(DbInstanceView.ID);
	    topLeft1.addView(TableColumnView.ID);
	    //[U[c[̃r[ǉ
	    //topLeft2.addView(TableListView.ID);
	    
	    //topLeft3.addView(TableColumnView.ID);
	    top.addView(PartitionListView.ID);
	    
	    bottomLeft.addView(DdlView.ID);
	    //R\[r[̒ǉ
	    bottom.addView(IConsoleConstants.ID_CONSOLE_VIEW);
	    bottom.addView("org.eclipse.pde.runtime.LogView");
	    //MASUCOMMENT OꗗVIEWǉ
	    bottom.addView(BrokenLogView.ID);
	}

}
