/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool;

import java.util.MissingResourceException;
import java.util.ResourceBundle;


/**
 * R}hCc[p̃\[Xoh
 * The main plugin class to be used in the desktop.
 */
public class ForestToolCommandLine  {
	//The shared instance.
	private static ForestToolCommandLine plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;	
	
	/**
	 * The constructor.
	 */
	public ForestToolCommandLine() {
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("org.postgresforest.tool.ForestToolPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static ForestToolCommandLine getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = ForestToolCommandLine.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,s
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
}
