/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.util;

import java.util.regex.Pattern;

public class StringReplaceUtil {
    protected static final String PARAM_STR = "?";
    protected Pattern m_pattern = Pattern.compile("\\?");
    protected String[] m_divStr;
    protected String[] m_valueList;

    public StringReplaceUtil(String souceStr) {
        this.reset(souceStr);
    }

    public void reset(String souceStr) {
        this.m_divStr = this.m_pattern.split(souceStr);
        this.m_valueList = new String[this.m_divStr.length - 1];
    }

    public void set(int index, String value) {
        this.m_valueList[index - 1] = value;
    }

    public void set(int index, byte[] value) {
        this.set(index, this.escapeString(StringReplaceUtil.toPGString(value)));
    }

    public String get() {
        StringBuffer replaceStr = new StringBuffer();
        for (int i = 0; i < this.m_valueList.length; ++i) {
            replaceStr.append(this.m_divStr[i]);
            if (this.m_valueList[i] == null) {
                replaceStr.append(PARAM_STR);
                continue;
            }
            replaceStr.append(this.m_valueList[i]);
        }
        replaceStr.append(this.m_divStr[this.m_valueList.length]);
        return replaceStr.toString();
    }

    private static String toPGString(byte[] p_buf) {
        if (p_buf == null) {
            return null;
        }
        StringBuffer l_strbuf = new StringBuffer(2 * p_buf.length);
        for (int i = 0; i < p_buf.length; ++i) {
            int l_int = p_buf[i];
            if (l_int < 0) {
                l_int = 256 + l_int;
            }
            if (l_int < 32 || l_int > 126) {
                l_strbuf.append("\\");
                l_strbuf.append((char)((l_int >> 6 & 3) + 48));
                l_strbuf.append((char)((l_int >> 3 & 7) + 48));
                l_strbuf.append((char)((l_int & 7) + 48));
                continue;
            }
            if (p_buf[i] == 92) {
                l_strbuf.append("\\\\");
                continue;
            }
            l_strbuf.append((char)p_buf[i]);
        }
        return l_strbuf.toString();
    }

    private String escapeString(String p_input) {
        StringBuffer p_output = new StringBuffer();
        block3: for (int i = 0; i < p_input.length(); ++i) {
            char c = p_input.charAt(i);
            switch (c) {
                case '\'': 
                case '\\': {
                    p_output.append('\\');
                    p_output.append(c);
                    continue block3;
                }
                default: {
                    p_output.append(c);
                }
            }
        }
        return p_output.toString();
    }

    public String toString() {
        return this.get();
    }
}

