/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.postgresforest.tool.bean.ColumnInfo;
import org.postgresforest.tool.db.UserData;
import org.postgresforest.tool.util.StringReplaceUtil;
import org.postgresql.jdbc3.Jdbc3Connection;

public class UserDataCheck
extends UserData {
    public UserDataCheck(String dbName, String user, String password) {
        super(dbName, user, password);
    }

    public UserDataCheck(Properties userPassword) {
        super(userPassword);
    }

    public ArrayList checkColumn(String tableName, ColumnInfo columnInfo) throws SQLException {
        ArrayList<String> errConnectionList = new ArrayList<String>();
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            int objIndex = this.m_Connection.indexOf(con);
            try {
                DatabaseMetaData dataMeta = con.getMetaData();
                ResultSet rs = dataMeta.getColumns(this.m_dbName, "public", tableName.toLowerCase(), columnInfo.getName().toLowerCase());
                if (rs.next()) {
                    int clmType = ((Jdbc3Connection)con).getSQLType(rs.getString("TYPE_NAME").toLowerCase());
                    int gscclmType = ((Jdbc3Connection)con).getSQLType(columnInfo.getType().toLowerCase());
                    if (columnInfo.getNumber() == rs.getInt("ORDINAL_POSITION") && clmType == gscclmType) continue;
                    errConnectionList.add(this.getURL(objIndex));
                    continue;
                }
                errConnectionList.add(this.getURL(objIndex));
            }
            catch (SQLException e) {
                errConnectionList.add(this.getURL(objIndex));
            }
        }
        return errConnectionList;
    }

    public boolean checkDataCount(String tableName) {
        boolean ret = true;
        String connectUrl = "";
        long recordCount = 0L;
        ArrayList<Long> recCountList = new ArrayList<Long>();
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                Statement smt = con.createStatement();
                StringReplaceUtil strUtil = new StringReplaceUtil(m_sqlResource.getString("select.record.count"));
                strUtil.set(1, tableName);
                ResultSet rs = smt.executeQuery(strUtil.get());
                while (rs.next()) {
                    recordCount = rs.getLong("RECORD_COUNT");
                    recCountList.add(new Long(recordCount));
                }
                rs.close();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        for (int i = 0; i < recCountList.size() - 1; ++i) {
            Long count2;
            Long count1 = (Long)recCountList.get(i);
            if (count1.compareTo(count2 = (Long)recCountList.get(i + 1)) == 0) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public boolean checkDataCount(String tableName, HashMap urlMap) {
        boolean ret = true;
        String connectUrl = "";
        long recordCount = 0L;
        ArrayList<Long> recCountList = new ArrayList<Long>();
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            String url = this.getURL(this.m_Connection.indexOf(con));
            if (urlMap.get(url) == null) continue;
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                Statement smt = con.createStatement();
                StringReplaceUtil strUtil = new StringReplaceUtil(m_sqlResource.getString("select.record.count"));
                strUtil.set(1, tableName);
                ResultSet rs = smt.executeQuery(strUtil.get());
                while (rs.next()) {
                    recordCount = rs.getLong("RECORD_COUNT");
                    recCountList.add(new Long(recordCount));
                }
                rs.close();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        for (int i = 0; i < recCountList.size() - 1; ++i) {
            Long count2;
            Long count1 = (Long)recCountList.get(i);
            if (count1.compareTo(count2 = (Long)recCountList.get(i + 1)) == 0) continue;
            ret = false;
            break;
        }
        return ret;
    }
}

