/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.postgresforest.tool.bean.ColumnInfo;
import org.postgresforest.tool.bean.ConData;
import org.postgresforest.tool.bean.PriorityInfo;
import org.postgresforest.tool.bean.ServerPartition2Info;
import org.postgresforest.tool.bean.ServerPriorityInfo;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.bean.UserInfo;
import org.postgresforest.tool.db.DbBase;
import org.postgresforest.tool.util.StringReplaceUtil;
import org.postgresql.jdbc3.Jdbc3Connection;

public class UserData
extends DbBase {
    public static final String TYPE_TABLE = "TABLE";
    public static final String TYPE_VIEW = "VIEW";
    protected String m_dbName = null;
    protected ArrayList m_dumpList = new ArrayList();
    protected static DecimalFormat m_dcFmt = new DecimalFormat("00");
    protected static final int SELECT_FAIL = 1;

    public UserData(String dbName, String user, String password) {
        super(user, password);
        this.m_dbName = dbName;
    }

    public UserData(Properties userPassword) {
        this.m_prop = userPassword;
    }

    public boolean execDdl(String ddl) {
        String[] ddlList = new String[]{ddl};
        return this.execDdl(ddlList);
    }

    public boolean execDdl(String[] ddl) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                Statement ps = con.createStatement();
                for (int i = 0; i < ddl.length; ++i) {
                    ps.execute(ddl[i]);
                }
                ps.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public ArrayList getColumnList(String tableName) throws SQLException {
        return this.getColumnList(this.getSelectConnectoin(), tableName);
    }

    private ArrayList getColumnList(Connection con, String tableName) throws SQLException {
        ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
        String connectUrl = "";
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            DatabaseMetaData dataMeta = con.getMetaData();
            ResultSet rs = dataMeta.getColumns(this.m_dbName, "public", tableName.toLowerCase(), "");
            PreparedStatement pSelectSmt = con.prepareStatement(m_sqlResource.getString("select.user.partition.datatype"));
            pSelectSmt.setString(1, tableName.toLowerCase());
            while (rs.next()) {
                ColumnInfo column = new ColumnInfo();
                column.setName(rs.getString("COLUMN_NAME"));
                column.setNumber(rs.getInt("ORDINAL_POSITION"));
                column.setType(rs.getString("TYPE_NAME"));
                pSelectSmt.setString(2, column.getName());
                ResultSet rs2 = pSelectSmt.executeQuery();
                rs2.next();
                column.setTypeDetail(rs2.getString(1));
                column.setNotNull(rs2.getBoolean(2));
                rs2.close();
                columnList.add(column);
            }
            pSelectSmt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return columnList;
    }

    public ArrayList getUserList() throws SQLException {
        ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Statement smt = con.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.user.list"));
            while (rs.next()) {
                UserInfo userInfo = new UserInfo();
                userInfo.setName(rs.getString("User name"));
                userInfo.setAttribute(rs.getString("Attributes"));
                userList.add(userInfo);
            }
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return userList;
    }

    public boolean releasePartition(String tableName, int partitionCount) {
        boolean ret = true;
        String connectUrl = "";
        ArrayList<String> sqlList = new ArrayList<String>();
        String tempTable = tableName + "_temp";
        String logicalTable = tableName + "_" + m_dcFmt.format(0L);
        ArrayList conList = null;
        try {
            conList = this.getConstraint(this.getSelectConnectoin(), logicalTable);
            for (int k = 0; k < conList.size(); ++k) {
                String conName = ((ConData)conList.get(k)).getName();
                conName = conName.replaceAll(logicalTable.toLowerCase(), tableName.toLowerCase());
                ((ConData)conList.get(k)).setName(conName);
                String description = ((ConData)conList.get(k)).getDesc();
                description = description.replaceAll(logicalTable.toLowerCase(), tableName.toLowerCase());
                ((ConData)conList.get(k)).setDesc(description);
            }
            Iterator iter = this.m_Connection.iterator();
            while (iter.hasNext()) {
                Connection con = (Connection)iter.next();
                connectUrl = ((Jdbc3Connection)con).getURL();
                ret = this.makeLogicalTable(con, logicalTable, tempTable);
                if (ret) continue;
                return ret;
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            ret = false;
        }
        StringReplaceUtil strUtil = new StringReplaceUtil(m_sqlResource.getString("insert.user.physicaltable.temp"));
        strUtil.set(1, tableName);
        strUtil.set(2, tableName);
        sqlList.add(strUtil.get());
        strUtil.reset(m_sqlResource.getString("drop.user.physicaltable"));
        for (int i = 0; i < partitionCount; ++i) {
            strUtil.set(1, tableName + "_" + m_dcFmt.format(i));
            sqlList.add(strUtil.get());
        }
        strUtil.reset(m_sqlResource.getString("alter.user.physicaltable"));
        strUtil.set(1, tempTable);
        strUtil.set(2, tableName);
        sqlList.add(strUtil.get());
        for (int k = 0; k < conList.size(); ++k) {
            String sql = this.makeConstraintSQL(tableName, (ConData)conList.get(k));
            sqlList.add(sql);
        }
        if (!this.execSql(sqlList)) {
            ret = false;
        }
        return ret;
    }

    public boolean releasePartition2(String tableName, int partitionCount, ArrayList servers) {
        boolean ret = true;
        String connectUrl = "";
        ArrayList<String> sqlList = new ArrayList<String>();
        String tempTable = tableName + "_temp";
        String logicalTable = tableName + "_" + m_dcFmt.format(0L);
        try {
            ArrayList createTableSqlList = new ArrayList();
            ArrayList conList = null;
            for (int i = 0; i < servers.size(); ++i) {
                try {
                    conList = this.getConstraint(this.getConnectoin(i), logicalTable);
                }
                catch (SQLException e1) {
                    this.getConnectoin(i).rollback();
                    continue;
                }
                if (conList == null || conList.size() <= 0) continue;
                ArrayList columnList = this.getColumnList(this.getConnectoin(i), logicalTable);
                createTableSqlList = this.makePhysicalTableSQL(tempTable, columnList);
                break;
            }
            for (int k = 0; k < conList.size(); ++k) {
                String conName = ((ConData)conList.get(k)).getName();
                conName = conName.replaceAll(logicalTable.toLowerCase(), tableName.toLowerCase());
                ((ConData)conList.get(k)).setName(conName);
                String description = ((ConData)conList.get(k)).getDesc();
                description = description.replaceAll(logicalTable.toLowerCase(), tableName.toLowerCase());
                ((ConData)conList.get(k)).setDesc(description);
            }
            Iterator iter = this.m_Connection.iterator();
            Iterator iterSvr = servers.iterator();
            while (iter.hasNext()) {
                Connection con = (Connection)iter.next();
                connectUrl = ((Jdbc3Connection)con).getURL();
                ServerPriorityInfo serverPriorityInfo = (ServerPriorityInfo)iterSvr.next();
                sqlList.clear();
                sqlList.addAll(createTableSqlList);
                StringReplaceUtil strUtil = new StringReplaceUtil("");
                strUtil.reset(m_sqlResource.getString("drop.user.physicaltable"));
                for (int i = 0; i < partitionCount; ++i) {
                    PriorityInfo info = serverPriorityInfo.getPartition(i);
                    if (info == null) continue;
                    strUtil.set(1, tableName + "_" + m_dcFmt.format(info.getPartitionNo()));
                    sqlList.add(strUtil.get());
                }
                strUtil.reset(m_sqlResource.getString("alter.user.physicaltable"));
                strUtil.set(1, tempTable);
                strUtil.set(2, tableName);
                sqlList.add(strUtil.get());
                for (int k = 0; k < conList.size(); ++k) {
                    String sql = this.makeConstraintSQL(tableName, (ConData)conList.get(k));
                    sqlList.add(sql);
                }
                Statement ps = con.createStatement();
                Iterator iterator = sqlList.iterator();
                while (iterator.hasNext()) {
                    String sql = (String)iterator.next();
                    ps.execute(sql);
                }
                ps.close();
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            ret = false;
        }
        return ret;
    }

    public boolean setPartition(TableInfo tableInfo, int partCount, boolean dataShift, String newHashName, byte[] hashImage) {
        boolean ret = true;
        String connectUrl = "";
        String tableName = tableInfo.getName();
        ArrayList serverList = tableInfo.getServer();
        ArrayList<String> sqlList = new ArrayList<String>();
        int serverCount = serverList.size();
        try {
            ArrayList conList = this.getConstraint(this.getSelectConnectoin(), tableName);
            Iterator iter = this.m_Connection.iterator();
            while (iter.hasNext()) {
                Connection con = (Connection)iter.next();
                connectUrl = ((Jdbc3Connection)con).getURL();
                for (int i = 0; i < partCount; ++i) {
                    String logicalTable = tableName + "_" + m_dcFmt.format(i);
                    ret = this.makeLogicalTable(con, tableName, logicalTable);
                    if (!ret) {
                        return ret;
                    }
                    ArrayList conDataWk = this.makeConstraint(tableName, logicalTable, conList);
                    ret = this.setConstraint(con, logicalTable, conDataWk);
                    if (ret) continue;
                    return ret;
                }
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            ret = false;
        }
        if (dataShift) {
            sqlList.addAll(this.makeShiftDataSQL(tableInfo.getColumn(), partCount, tableName, newHashName, hashImage));
        }
        StringReplaceUtil dropTableStrUtil = new StringReplaceUtil(m_sqlResource.getString("drop.user.table"));
        dropTableStrUtil.set(1, tableName);
        sqlList.add(dropTableStrUtil.get());
        StringBuffer ruleSetColumn = this.makeRuleSet(tableInfo.getColumn());
        StringBuffer ruleWhereColumn = this.makeRuleWhere(tableName);
        int[] partCountlist = new int[partCount];
        for (int i = 0; i < partCountlist.length; ++i) {
            partCountlist[i] = i;
        }
        sqlList.addAll(this.makeViewSQL(partCountlist, tableName, ruleSetColumn, ruleWhereColumn));
        if (!this.execSql(sqlList)) {
            ret = false;
        }
        return ret;
    }

    protected ArrayList makeViewSQL(int[] partCount, String tableName, StringBuffer ruleSetColumn, StringBuffer ruleWhereColumn) {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringReplaceUtil createViewStrUtil = new StringReplaceUtil(m_sqlResource.getString("create.view"));
        createViewStrUtil.set(1, tableName);
        StringReplaceUtil createUpdateRuleStrUtil = new StringReplaceUtil(m_sqlResource.getString("create.rule.update"));
        createUpdateRuleStrUtil.set(1, tableName);
        createUpdateRuleStrUtil.set(2, tableName);
        StringReplaceUtil createDeleteRuleStrUtil = new StringReplaceUtil(m_sqlResource.getString("create.rule.delete"));
        createDeleteRuleStrUtil.set(1, tableName);
        createDeleteRuleStrUtil.set(2, tableName);
        StringBuffer viewSelect = new StringBuffer();
        StringBuffer ruleUpdate = new StringBuffer();
        StringBuffer ruleDelate = new StringBuffer();
        for (int i = 0; i < partCount.length; ++i) {
            String logicalTable = tableName + "_" + m_dcFmt.format(partCount[i]);
            StringBuffer viewSelectWk = new StringBuffer();
            viewSelectWk.append("( SELECT  * FROM ");
            viewSelectWk.append(logicalTable);
            viewSelectWk.append(")");
            if (viewSelect.length() != 0) {
                viewSelect.append("UNION ALL");
            }
            viewSelect.append(viewSelectWk);
            ruleUpdate.append("UPDATE ");
            ruleUpdate.append(logicalTable);
            ruleUpdate.append(" SET ");
            ruleUpdate.append(ruleSetColumn);
            ruleUpdate.append(" WHERE ");
            ruleUpdate.append(ruleWhereColumn);
            ruleUpdate.append(";");
            ruleDelate.append("DELETE FROM ");
            ruleDelate.append(logicalTable);
            ruleDelate.append(" WHERE ");
            ruleDelate.append(ruleWhereColumn);
            ruleDelate.append(";");
        }
        createViewStrUtil.set(2, viewSelect.toString());
        createUpdateRuleStrUtil.set(3, ruleUpdate.toString());
        createDeleteRuleStrUtil.set(3, ruleDelate.toString());
        sqlList.add(createViewStrUtil.get());
        sqlList.add(createUpdateRuleStrUtil.get());
        sqlList.add(createDeleteRuleStrUtil.get());
        return sqlList;
    }

    protected StringBuffer makeRuleWhere(String tableName) {
        StringBuffer ruleWhereColumn = new StringBuffer();
        ArrayList primaryKeyList = this.getPrimaryKey(tableName);
        Iterator iter = primaryKeyList.iterator();
        while (iter.hasNext()) {
            String primaryKey = (String)iter.next();
            StringBuffer ruleWhereWk = new StringBuffer();
            ruleWhereWk.append("(");
            ruleWhereWk.append(primaryKey);
            ruleWhereWk.append(" = ");
            ruleWhereWk.append("old.");
            ruleWhereWk.append(primaryKey);
            ruleWhereWk.append(" OR (");
            ruleWhereWk.append(primaryKey);
            ruleWhereWk.append(" IS NULL");
            ruleWhereWk.append(" AND ");
            ruleWhereWk.append("old.");
            ruleWhereWk.append(primaryKey);
            ruleWhereWk.append(" IS NULL");
            ruleWhereWk.append("))");
            if (ruleWhereColumn.length() != 0) {
                ruleWhereColumn.append(" AND ");
            }
            ruleWhereColumn.append(ruleWhereWk);
        }
        return ruleWhereColumn;
    }

    protected StringBuffer makeRuleSet(ArrayList columnList) {
        StringBuffer ruleSetColumn = new StringBuffer();
        Iterator iter = columnList.iterator();
        while (iter.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iter.next();
            String columnName = columnInfo.getName();
            StringBuffer ruleSetWk = new StringBuffer();
            ruleSetWk.append(columnName);
            ruleSetWk.append(" = ");
            ruleSetWk.append("new.");
            ruleSetWk.append(columnName);
            if (ruleSetColumn.length() != 0) {
                ruleSetColumn.append(",");
            }
            ruleSetColumn.append(ruleSetWk);
        }
        return ruleSetColumn;
    }

    protected ArrayList getConstraint(Connection con, String tableName) throws SQLException {
        ArrayList<ConData> conList = new ArrayList<ConData>();
        PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.extractConstraint"));
        smt.setString(1, tableName.toLowerCase());
        ResultSet rs = smt.executeQuery();
        while (rs.next()) {
            ConData condata = new ConData();
            condata.setName(rs.getString("conname"));
            condata.setCategory(rs.getString("concategory"));
            condata.setAttNum(rs.getString("attnum"));
            condata.setCols(rs.getString("targetcolumn"));
            condata.setDesc(rs.getString("description"));
            conList.add(condata);
        }
        rs.close();
        smt.close();
        return conList;
    }

    protected ArrayList makeConstraint(String srcTableName, String distTableName, ArrayList conList) throws SQLException {
        boolean ret = true;
        ArrayList<ConData> distConList = new ArrayList<ConData>();
        for (int k = 0; k < conList.size(); ++k) {
            ConData orgData = (ConData)conList.get(k);
            ConData conData = new ConData();
            conData.setAttNum(orgData.getAttNum());
            conData.setCategory(orgData.getCategory());
            conData.setCols(orgData.getCols());
            conData.setDesc(orgData.getDesc());
            String conName = orgData.getName();
            conName = conName.replaceAll(srcTableName.toLowerCase(), distTableName.toLowerCase());
            conData.setName(conName);
            distConList.add(conData);
        }
        return distConList;
    }

    protected boolean setConstraint(Connection con, String logicalTable, ArrayList conList) throws SQLException {
        boolean ret = true;
        for (int k = 0; k < conList.size(); ++k) {
            String sql = this.makeConstraintSQL(logicalTable, (ConData)conList.get(k));
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt("ret") != 1) continue;
                ret = false;
            }
            rs.close();
            stmt.close();
        }
        return ret;
    }

    protected String makeConstraintSQL(String logicalTable, ConData conData) {
        String sql = "select ret from postgresforest.AddaptConstraint('" + conData.getName() + "'::name, " + conData.getCategory() + "::smallint, " + conData.getAttNum() + "::smallint, " + "'" + conData.getCols() + "'::smallint[], " + "'" + conData.getDesc() + "'::text, " + "'" + logicalTable.toLowerCase() + "'::name" + ") AS ret";
        return sql;
    }

    protected ArrayList makePhysicalTableSQL(String physicalTable, ArrayList columnList) {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringReplaceUtil strUtil = new StringReplaceUtil(m_sqlResource.getString("alter.table.notnull"));
        strUtil.set(1, physicalTable);
        StringBuffer nameList = new StringBuffer();
        Iterator iter = columnList.iterator();
        while (iter.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iter.next();
            String columnNmae = columnInfo.getName();
            if (nameList.length() != 0) {
                nameList.append(",");
            }
            nameList.append(columnNmae);
            nameList.append(" ");
            nameList.append(columnInfo.getTypeDetail());
            if (!columnInfo.isNotNull()) continue;
            strUtil.set(2, columnNmae);
            sqlList.add(strUtil.get());
        }
        strUtil.reset(m_sqlResource.getString("create.user.physicaltable"));
        strUtil.set(1, physicalTable);
        strUtil.set(2, nameList.toString());
        sqlList.add(0, strUtil.get());
        return sqlList;
    }

    protected boolean makeLogicalTable(Connection con, String srcTableName, String distTableName) throws SQLException {
        boolean ret = true;
        PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.copy.column"));
        smt.setString(1, srcTableName.toLowerCase());
        smt.setString(2, distTableName.toLowerCase());
        ResultSet rs = smt.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            if (rs.getInt("ret") != 1) continue;
            ret = false;
        }
        rs.close();
        smt.close();
        return ret;
    }

    public boolean setPartition2(TableInfo tableInfo, int partCount, boolean dataShift, String newHashName, byte[] hashImage) {
        boolean ret = true;
        String connectUrl = "";
        String tableName = tableInfo.getName();
        ArrayList serverList = tableInfo.getServer();
        ArrayList sqlDataShift = new ArrayList();
        int serverCount = serverList.size();
        int conIndex = 0;
        try {
            ArrayList conList = this.getConstraint(this.getSelectConnectoin(), tableName);
            Iterator iter = this.m_Connection.iterator();
            while (iter.hasNext()) {
                Connection con = (Connection)iter.next();
                connectUrl = ((Jdbc3Connection)con).getURL();
                ServerPartition2Info svrPartInfo = (ServerPartition2Info)serverList.get(conIndex);
                ++conIndex;
                for (int i = 0; i < partCount; ++i) {
                    if (!svrPartInfo.getMakeInstance(i).booleanValue()) continue;
                    String logicalTable = tableName + "_" + m_dcFmt.format(i);
                    ret = this.makeLogicalTable(con, tableName, logicalTable);
                    if (!ret) {
                        return ret;
                    }
                    ArrayList conDataWk = this.makeConstraint(tableName, logicalTable, conList);
                    ret = this.setConstraint(con, logicalTable, conDataWk);
                    if (ret) continue;
                    return ret;
                }
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            ret = false;
        }
        StringReplaceUtil dropTableStrUtil = new StringReplaceUtil(m_sqlResource.getString("drop.user.table"));
        dropTableStrUtil.set(1, tableName);
        StringBuffer ruleSetColumn = this.makeRuleSet(tableInfo.getColumn());
        StringBuffer ruleWhereColumn = this.makeRuleWhere(tableName);
        conIndex = 0;
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                ServerPartition2Info svrPartInfo = (ServerPartition2Info)serverList.get(conIndex);
                ++conIndex;
                int[] partCountlist = new int[svrPartInfo.getMakeInstanceCount()];
                int partindex = 0;
                for (int i = 0; i < partCount; ++i) {
                    if (!svrPartInfo.getMakeInstance(i).booleanValue()) continue;
                    partCountlist[partindex++] = i;
                }
                ArrayList<String> sqlList = new ArrayList<String>();
                if (partCountlist.length != 0 && dataShift) {
                    sqlDataShift = this.makeShiftDataSQL(partCountlist, tableInfo.getColumn(), partCount, tableName, newHashName, hashImage);
                    sqlList.addAll(sqlDataShift);
                }
                sqlList.add(dropTableStrUtil.get());
                if (partCountlist.length != 0) {
                    sqlList.addAll(this.makeViewSQL(partCountlist, tableName, ruleSetColumn, ruleWhereColumn));
                }
                Statement ps = con.createStatement();
                Iterator iterator = sqlList.iterator();
                while (iterator.hasNext()) {
                    String sql = (String)iterator.next();
                    ps.execute(sql);
                }
                ps.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    protected ArrayList makeShiftDataSQL(ArrayList columnList, int partCount, String tableName, String hashName, byte[] hashImage) {
        int[] partCountList = new int[partCount];
        for (int i = 0; i < partCountList.length; ++i) {
            partCountList[i] = i;
        }
        return this.makeShiftDataSQL(partCountList, columnList, partCount, tableName, hashName, hashImage);
    }

    protected ArrayList makeShiftDataSQL(int[] partCountList, ArrayList columnList, int partCount, String tableName, String hashName, byte[] hashImage) {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringReplaceUtil strUtil = new StringReplaceUtil("postgresforest.getHash('?', '?', ?)");
        if (hashName == null) {
            strUtil.set(1, "org.postgresql.vm.Hash01");
        } else {
            strUtil.set(1, hashName);
            strUtil.set(2, hashImage);
        }
        strUtil.set(3, Integer.toString(partCount));
        String sqlPartition = strUtil.get();
        Iterator iterator = columnList.iterator();
        while (iterator.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iterator.next();
            if (!columnInfo.isPartition()) continue;
            strUtil.reset("postgresforest.setValue(?, ?)");
            strUtil.set(1, sqlPartition);
            strUtil.set(2, columnInfo.getName());
            sqlPartition = strUtil.get();
        }
        strUtil.reset("postgresforest.getPartitionNo(?)");
        strUtil.set(1, sqlPartition);
        sqlPartition = strUtil.get();
        for (int i = 0; i < partCountList.length; ++i) {
            String logicalTable = tableName + "_" + m_dcFmt.format(partCountList[i]);
            strUtil.reset("INSERT INTO ? (select * from ? where ? = ?);");
            strUtil.set(1, logicalTable.toLowerCase());
            strUtil.set(2, tableName.toLowerCase());
            strUtil.set(3, sqlPartition);
            strUtil.set(4, Integer.toString(partCountList[i]));
            sqlList.add(strUtil.get());
        }
        return sqlList;
    }

    public boolean rePartition(TableInfo tableInfo, int partCount, String newHashName, byte[] hashImage) {
        int i;
        int i2;
        Connection con;
        boolean ret = true;
        String connectUrl = "";
        boolean RetSuccess = false;
        boolean RetFail = true;
        String tableName = tableInfo.getName();
        String srcTableName = tableName + "_" + m_dcFmt.format(0L);
        ArrayList<String> sqlList = new ArrayList<String>();
        ArrayList serverList = tableInfo.getServer();
        int serverCount = serverList.size();
        int srcPartCount = tableInfo.getPartCount();
        ArrayList columnList = tableInfo.getColumn();
        ArrayList<Long> recCountList = new ArrayList<Long>();
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con2 = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con2).getURL();
                recCountList.add(new Long(this.getRecordCount(tableName)));
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        ArrayList primaryKeyList = this.getPrimaryKey(srcTableName);
        Iterator iter2 = this.m_Connection.iterator();
        while (iter2.hasNext()) {
            con = (Connection)iter2.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                for (int i3 = 0; i3 < partCount; ++i3) {
                    String logicalTable = "temp_" + tableName + "_" + m_dcFmt.format(i3);
                    PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.copy.column"));
                    smt.setString(1, srcTableName.toLowerCase());
                    smt.setString(2, logicalTable.toLowerCase());
                    ResultSet rs = smt.executeQuery();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    while (rs.next()) {
                        if (rs.getInt("ret") != 1) continue;
                        SQLException e = new SQLException("ERROR:postgresforest.CopyColumn() ErrorCode=1");
                        this.setErrInfo(connectUrl, e);
                        ret = false;
                    }
                    rs.close();
                    smt.close();
                }
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        ArrayList<ConData> conList = new ArrayList<ConData>();
        try {
            con = this.getSelectConnectoin();
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.extractConstraint"));
            smt.setString(1, srcTableName.toLowerCase());
            ResultSet rs = smt.executeQuery();
            while (rs.next()) {
                ConData condata = new ConData();
                condata.setName(rs.getString("conname"));
                condata.setCategory(rs.getString("concategory"));
                condata.setAttNum(rs.getString("attnum"));
                condata.setCols(rs.getString("targetcolumn"));
                condata.setDesc(rs.getString("description"));
                conList.add(condata);
            }
            rs.close();
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            ret = false;
        }
        StringReplaceUtil strUtil = new StringReplaceUtil("postgresforest.getHash('?', '?', ?)");
        if (newHashName == null) {
            strUtil.set(1, "org.postgresql.vm.Hash01");
        } else {
            strUtil.set(1, newHashName);
            strUtil.set(2, hashImage);
        }
        strUtil.set(3, Integer.toString(partCount));
        String sqlPartition = strUtil.get();
        Iterator iterator = columnList.iterator();
        while (iterator.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iterator.next();
            if (!columnInfo.isPartition()) continue;
            strUtil.reset("postgresforest.setValue(?, ?)");
            strUtil.set(1, sqlPartition);
            strUtil.set(2, columnInfo.getName());
            sqlPartition = strUtil.get();
        }
        strUtil.reset("postgresforest.getPartitionNo(?)");
        strUtil.set(1, sqlPartition);
        sqlPartition = strUtil.get();
        for (i2 = 0; i2 < partCount; ++i2) {
            for (int j = 0; j < srcPartCount; ++j) {
                String logicalTable = "temp_" + tableName + "_" + m_dcFmt.format(i2);
                String srcLogicalTable = tableName + "_" + m_dcFmt.format(j);
                strUtil.reset("INSERT INTO ? (select * from ? where ? = ?);");
                strUtil.set(1, logicalTable.toLowerCase());
                strUtil.set(2, srcLogicalTable.toLowerCase());
                strUtil.set(3, sqlPartition);
                strUtil.set(4, Integer.toString(i2));
                sqlList.add(strUtil.get());
            }
        }
        if (!this.execSql(sqlList)) {
            ret = false;
        }
        sqlList.clear();
        try {
            i2 = 0;
            Iterator iter3 = this.m_Connection.iterator();
            while (iter3.hasNext()) {
                Connection con3 = (Connection)iter3.next();
                connectUrl = ((Jdbc3Connection)con3).getURL();
                Long recCount = (Long)recCountList.get(i2);
                long count = 0L;
                for (int j = 0; j < partCount; ++j) {
                    String logicalTable = "temp_" + tableName + "_" + m_dcFmt.format(j);
                    count += this.getRecordCount(logicalTable);
                }
                if (count != recCount) {
                    SQLException e = new SQLException("ERROR:Data Shift");
                    this.setErrInfo(connectUrl, e);
                    ret = false;
                    throw e;
                }
                ++i2;
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            ret = false;
        }
        for (i = 0; i < srcPartCount; ++i) {
            String logicalTable = tableName + "_" + m_dcFmt.format(i);
            StringReplaceUtil dropTableStrUtil = new StringReplaceUtil(m_sqlResource.getString("drop.user.physicaltable"));
            dropTableStrUtil.set(1, logicalTable);
            sqlList.add(dropTableStrUtil.get());
        }
        for (i = 0; i < partCount; ++i) {
            String logicalTable = tableName + "_" + m_dcFmt.format(i);
            String tempTable = "temp_" + tableName + "_" + m_dcFmt.format(i);
            strUtil.reset(m_sqlResource.getString("alter.user.physicaltable"));
            strUtil.set(1, tempTable);
            strUtil.set(2, logicalTable);
            sqlList.add(strUtil.get());
        }
        for (i = 0; i < partCount; ++i) {
            String description;
            String conName;
            int k;
            String logicalTable = tableName + "_" + m_dcFmt.format(i);
            for (k = 0; k < conList.size(); ++k) {
                conName = ((ConData)conList.get(k)).getName();
                conName = conName.replaceAll(srcTableName.toLowerCase(), logicalTable.toLowerCase());
                ((ConData)conList.get(k)).setName(conName);
                description = ((ConData)conList.get(k)).getDesc();
                description = description.replaceAll(srcTableName.toLowerCase(), logicalTable.toLowerCase());
                ((ConData)conList.get(k)).setDesc(description);
            }
            for (k = 0; k < conList.size(); ++k) {
                String sql = "select ret from postgresforest.AddaptConstraint('" + ((ConData)conList.get(k)).getName() + "'::name, " + ((ConData)conList.get(k)).getCategory() + "::smallint, " + ((ConData)conList.get(k)).getAttNum() + "::smallint, " + "'" + ((ConData)conList.get(k)).getCols() + "'::smallint[], " + "'" + ((ConData)conList.get(k)).getDesc() + "'::text, " + "'" + logicalTable.toLowerCase() + "'::name" + ") AS ret";
                sqlList.add(sql);
            }
            for (k = 0; k < conList.size(); ++k) {
                conName = ((ConData)conList.get(k)).getName();
                conName = conName.replaceAll(logicalTable.toLowerCase(), srcTableName.toLowerCase());
                ((ConData)conList.get(k)).setName(conName);
                description = ((ConData)conList.get(k)).getDesc();
                description = description.replaceAll(logicalTable.toLowerCase(), srcTableName.toLowerCase());
                ((ConData)conList.get(k)).setDesc(description);
            }
        }
        StringReplaceUtil createViewStrUtil = new StringReplaceUtil(m_sqlResource.getString("create.view"));
        createViewStrUtil.set(1, tableName);
        StringReplaceUtil createUpdateRuleStrUtil = new StringReplaceUtil(m_sqlResource.getString("create.rule.update"));
        createUpdateRuleStrUtil.set(1, tableName);
        createUpdateRuleStrUtil.set(2, tableName);
        StringReplaceUtil createDeleteRuleStrUtil = new StringReplaceUtil(m_sqlResource.getString("create.rule.delete"));
        createDeleteRuleStrUtil.set(1, tableName);
        createDeleteRuleStrUtil.set(2, tableName);
        StringBuffer ruleSetColumn = new StringBuffer();
        StringBuffer ruleWhereColumn = new StringBuffer();
        Iterator iter4 = columnList.iterator();
        while (iter4.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iter4.next();
            String columnName = columnInfo.getName();
            StringBuffer ruleSetWk = new StringBuffer();
            ruleSetWk.append(columnName);
            ruleSetWk.append(" = ");
            ruleSetWk.append("new.");
            ruleSetWk.append(columnName);
            if (ruleSetColumn.length() != 0) {
                ruleSetColumn.append(",");
            }
            ruleSetColumn.append(ruleSetWk);
        }
        iter4 = primaryKeyList.iterator();
        while (iter4.hasNext()) {
            String primaryKey = (String)iter4.next();
            StringBuffer ruleWhereWk = new StringBuffer();
            ruleWhereWk.append("(");
            ruleWhereWk.append(primaryKey);
            ruleWhereWk.append(" = ");
            ruleWhereWk.append("old.");
            ruleWhereWk.append(primaryKey);
            ruleWhereWk.append(" OR (");
            ruleWhereWk.append(primaryKey);
            ruleWhereWk.append(" IS NULL");
            ruleWhereWk.append(" AND ");
            ruleWhereWk.append("old.");
            ruleWhereWk.append(primaryKey);
            ruleWhereWk.append(" IS NULL");
            ruleWhereWk.append("))");
            if (ruleWhereColumn.length() != 0) {
                ruleWhereColumn.append(" AND ");
            }
            ruleWhereColumn.append(ruleWhereWk);
        }
        StringBuffer viewSelect = new StringBuffer();
        StringBuffer ruleUpdate = new StringBuffer();
        StringBuffer ruleDelate = new StringBuffer();
        for (int i4 = 0; i4 < partCount; ++i4) {
            String logicalTable = tableName + "_" + m_dcFmt.format(i4);
            StringBuffer viewSelectWk = new StringBuffer();
            viewSelectWk.append("( SELECT  * FROM ");
            viewSelectWk.append(logicalTable);
            viewSelectWk.append(")");
            if (viewSelect.length() != 0) {
                viewSelect.append("UNION ALL");
            }
            viewSelect.append(viewSelectWk);
            ruleUpdate.append("UPDATE ");
            ruleUpdate.append(logicalTable);
            ruleUpdate.append(" SET ");
            ruleUpdate.append(ruleSetColumn);
            ruleUpdate.append(" WHERE ");
            ruleUpdate.append(ruleWhereColumn);
            ruleUpdate.append(";");
            ruleDelate.append("DELETE FROM ");
            ruleDelate.append(logicalTable);
            ruleDelate.append(" WHERE ");
            ruleDelate.append(ruleWhereColumn);
            ruleDelate.append(";");
        }
        createViewStrUtil.set(2, viewSelect.toString());
        createUpdateRuleStrUtil.set(3, ruleUpdate.toString());
        createDeleteRuleStrUtil.set(3, ruleDelate.toString());
        sqlList.add(createViewStrUtil.get());
        sqlList.add(createUpdateRuleStrUtil.get());
        sqlList.add(createDeleteRuleStrUtil.get());
        if (!this.execSql(sqlList)) {
            ret = false;
        }
        return ret;
    }

    public void addUrl(String hostName, String portNo) {
        super.addUrl(hostName, portNo, this.m_dbName);
    }

    public String getDbName() {
        return this.m_dbName;
    }

    public void setDbName(String string) {
        this.m_dbName = string;
    }

    public long getRecordCount(String tableName) throws SQLException {
        long recordCount = 0L;
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            StringReplaceUtil strUtil = new StringReplaceUtil(m_sqlResource.getString("select.record.count"));
            strUtil.set(1, tableName);
            Statement ps = con.createStatement();
            ResultSet rs = ps.executeQuery(strUtil.get());
            while (rs.next()) {
                recordCount = rs.getLong("RECORD_COUNT");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return recordCount;
    }

    public boolean execSql(ArrayList sqlList) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                Statement ps = con.createStatement();
                Iterator iterator = sqlList.iterator();
                while (iterator.hasNext()) {
                    String sql = (String)iterator.next();
                    ps.execute(sql);
                }
                ps.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean execRestore(String dbName) {
        boolean ret = true;
        String connectUrl = "";
        String user = (String)this.m_prop.get("user");
        String password = (String)this.m_prop.get("password");
        for (int i = 0; i < this.m_servers.size(); ++i) {
            Connection con = (Connection)this.m_Connection.get(i);
            DbBase.UrlInfo urlInfo = (DbBase.UrlInfo)this.m_servers.get(i);
            String dumpData = (String)this.m_dumpList.get(i);
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.restore.setuser"));
                smt.setString(1, user);
                smt.setString(2, password);
                smt.execute();
                smt.close();
                smt = con.prepareStatement(m_sqlResource.getString("select.restore.exec"));
                smt.setString(1, urlInfo.getPortNo());
                smt.setString(2, dbName);
                smt.setString(3, dumpData);
                ResultSet rs = smt.executeQuery();
                while (rs.next()) {
                    String retString = rs.getString("ret");
                    if (retString.compareTo("") == 0) continue;
                    Exception e = new Exception(retString);
                    this.setErrInfo(connectUrl, e);
                    ret = false;
                }
                rs.close();
                smt.close();
                continue;
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public void addDumpData(String dumpData) {
        this.m_dumpList.add(dumpData);
    }

    public ArrayList getTableList() {
        ArrayList<String> tableList = new ArrayList<String>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.table.list"));
            ResultSet rs = smt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString("NAME");
                tableList.add(tableName);
            }
            rs.close();
            smt.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return tableList;
    }

    private ArrayList getPrimaryKey(Connection con, String tableName) {
        String connectUrl = "";
        ArrayList<String> primaryList = new ArrayList<String>();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            ResultSet rsmeta = databaseMetaData.getPrimaryKeys(null, "public", tableName.toLowerCase());
            while (rsmeta.next()) {
                String primartKey = rsmeta.getString("COLUMN_NAME");
                primaryList.add(primartKey);
            }
            rsmeta.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return primaryList;
    }

    public ArrayList getPrimaryKey(String tableName) {
        return this.getPrimaryKey(this.getSelectConnectoin(), tableName);
    }

    public ArrayList checkTable(String name, String type) {
        ArrayList<String> errConnectionList = new ArrayList<String>();
        String[] types = new String[]{type};
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            int objIndex = this.m_Connection.indexOf(con);
            try {
                DatabaseMetaData dataMeta = con.getMetaData();
                ResultSet rs = dataMeta.getTables(this.m_dbName, "public", name.toLowerCase(), types);
                if (rs.next()) continue;
                errConnectionList.add(this.getURL(objIndex));
            }
            catch (SQLException e) {
                errConnectionList.add(this.getURL(objIndex));
            }
        }
        return errConnectionList;
    }
}

