/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.postgresforest.tool.bean.BrokenLogInfo;
import org.postgresforest.tool.bean.ColumnInfo;
import org.postgresforest.tool.bean.ConfigInfo;
import org.postgresforest.tool.bean.DbLinkInfo;
import org.postgresforest.tool.bean.GSCInfo;
import org.postgresforest.tool.bean.HashInfo;
import org.postgresforest.tool.bean.PriorityInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.ServerPartition2Info;
import org.postgresforest.tool.bean.ServerPriorityInfo;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.DbBase;
import org.postgresforest.tool.db.ErrInfo;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresql.jdbc3.Jdbc3Connection;

public class GSCdata
extends DbBase {
    public static final int PRIMARY = 0;
    public static final int BACKUP = 1;
    public static final int SERVER_RUNNING = 1;
    public static final int SERVER_TROUBLE = -1;
    protected static DecimalFormat m_dcFmt = new DecimalFormat("00");

    public GSCdata(String user, String password) {
        super(user, password);
    }

    public GSCdata(Properties userPassword) {
        this.m_prop = userPassword;
    }

    public boolean makeDB() {
        String gscOption = m_sqlResource.getString("create.db.gsc.option");
        return this.makeDB(gscOption, 0);
    }

    public boolean makeGscTables() {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                Statement ps = con.createStatement();
                connectUrl = ((Jdbc3Connection)con).getURL();
                ps.execute(m_sqlResource.getString("create.gsc.forest_server"));
                ps.execute(m_sqlResource.getString("create.gsc.forest_servdb"));
                ps.execute(m_sqlResource.getString("create.gsc.forest_hash"));
                ps.execute(m_sqlResource.getString("create.gsc.forest_tablepart"));
                ps.execute(m_sqlResource.getString("create.gsc.forest_tablepartdtl"));
                ps.execute(m_sqlResource.getString("create.gsc.forest_partatr"));
                ps.execute(m_sqlResource.getString("create.gsc.forest_gsc"));
                ps.execute(m_sqlResource.getString("create.gsc.forest_brokenlog"));
                ps.execute(m_sqlResource.getString("create.gsc.forest_config"));
                ps.execute(m_sqlResource.getString("grant.gsc.forest_server"));
                ps.execute(m_sqlResource.getString("grant.gsc.forest_servdb"));
                ps.execute(m_sqlResource.getString("grant.gsc.forest_tablepartdtl"));
                ps.execute(m_sqlResource.getString("grant.gsc.forest_tablepart"));
                ps.execute(m_sqlResource.getString("grant.gsc.forest_partatr"));
                ps.execute(m_sqlResource.getString("grant.gsc.forest_gsc"));
                ps.execute(m_sqlResource.getString("grant.gsc.forest_brokenlog"));
                ps.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean delServer(int id) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("delete.gsc.server"));
                smt.setInt(1, id);
                smt.execute();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean addHash(String name, String description, byte[] classImage) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.hash"));
                psmt.setString(1, name);
                psmt.setString(2, description);
                psmt.setBytes(3, classImage);
                psmt.execute();
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean addConfig(ConfigInfo configInfo) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.config"));
                psmt.setString(1, configInfo.getConfigId());
                psmt.setString(2, configInfo.getDescription());
                psmt.setLong(3, configInfo.getCacheReflesh());
                psmt.setLong(4, configInfo.getRetryCount());
                psmt.setLong(5, configInfo.getDefectTimeout());
                psmt.setLong(6, configInfo.getDistributedCon());
                psmt.setBoolean(7, configInfo.isPertitionMode());
                psmt.setBoolean(8, configInfo.isSyncMode());
                psmt.setTimestamp(9, new Timestamp(configInfo.getUpdateDate().getTime()));
                psmt.execute();
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean updateConfigDate() {
        boolean ret = true;
        String connectUrl = "";
        Timestamp tm = new Timestamp(System.currentTimeMillis());
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("update,gsc,config.date"));
                psmt.setTimestamp(1, tm);
                psmt.execute();
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean delHash(String id) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("delete.gsc.hash"));
                smt.setString(1, id);
                smt.execute();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean delConfig(String id) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("delete.gsc.config"));
                smt.setString(1, id);
                smt.execute();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean delServDb(String dbName, int serverId) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("delete.gsc.servdb"));
                smt.setString(1, dbName);
                smt.setInt(2, serverId);
                smt.execute();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean addServer(String host, String port) {
        boolean ret = true;
        String connectUrl = "";
        String serverUrl = GSCdata.makeUrl(host, port, "");
        int nextServerId = 0;
        Connection conSelect = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)conSelect).getURL();
            Statement smt = conSelect.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.gsc.server.maxserverid"));
            rs.next();
            if (rs.getInt("COUNT") > 0) {
                nextServerId = rs.getInt("MAX") + 1;
            }
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            return false;
        }
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.server"));
                psmt.setInt(1, nextServerId);
                psmt.setString(2, serverUrl.toString());
                psmt.setInt(3, 1);
                psmt.execute();
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean addServDb(String dbName, Integer[] serverIdList) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement pSelectSmt = con.prepareStatement(m_sqlResource.getString("select.gsc.servdb.maxdbno"));
                PreparedStatement pInsertSmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.servdb"));
                for (int i = 0; i < serverIdList.length; ++i) {
                    if (serverIdList[i] == null) continue;
                    pSelectSmt.setString(1, dbName);
                    ResultSet rs = pSelectSmt.executeQuery();
                    int nextDbNo = 0;
                    rs.next();
                    if (rs.getInt("COUNT") > 0) {
                        nextDbNo = rs.getInt("MAX") + 1;
                    }
                    rs.close();
                    pInsertSmt.setInt(1, serverIdList[i]);
                    pInsertSmt.setString(2, dbName);
                    pInsertSmt.setInt(3, nextDbNo);
                    pInsertSmt.execute();
                }
                pSelectSmt.close();
                pInsertSmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean setPartition(String dbName, TableInfo tableInfo, int partCount, String newHashName) {
        String connectUrl = "";
        String tableName = tableInfo.getName();
        ArrayList serverList = tableInfo.getServer();
        int serverCount = serverList.size();
        ArrayList columnList = tableInfo.getColumn();
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("delete.gsc.tablepartdtl"));
                psmt.setString(1, dbName);
                psmt.setString(2, tableName);
                psmt.execute();
                Iterator iterator = serverList.iterator();
                while (iterator.hasNext()) {
                    ServerInfo svrPartInfo = (ServerInfo)iterator.next();
                    for (int partNo = 0; partNo < partCount; ++partNo) {
                        int priority = this.getDbNo(svrPartInfo.getId(), dbName);
                        if ((priority -= partNo) < 0) {
                            priority = serverCount + priority;
                        }
                        psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
                        psmt.setInt(1, this.getDbNo(svrPartInfo.getId(), dbName));
                        psmt.setString(2, dbName);
                        psmt.setString(3, tableName);
                        psmt.setInt(4, partNo);
                        psmt.setInt(5, priority);
                        psmt.execute();
                    }
                }
                psmt = con.prepareStatement(m_sqlResource.getString("update.gsc.tablepart"));
                psmt.setInt(1, partCount);
                psmt.setInt(2, tableInfo.getPartType());
                psmt.setString(3, newHashName);
                psmt.setString(4, dbName);
                psmt.setString(5, tableName);
                psmt.execute();
                psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.partatr"));
                iterator = columnList.iterator();
                while (iterator.hasNext()) {
                    ColumnInfo columnInfo = (ColumnInfo)iterator.next();
                    if (!columnInfo.isPartition()) continue;
                    psmt.setString(1, dbName);
                    psmt.setString(2, tableName);
                    psmt.setString(3, columnInfo.getName());
                    psmt.setInt(4, columnInfo.getNumber());
                    psmt.setString(5, columnInfo.getType());
                    psmt.execute();
                }
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                return false;
            }
        }
        return true;
    }

    public boolean setPartition2(String dbName, TableInfo tableInfo, int partCount, String newHashName) {
        String connectUrl = "";
        String tableName = tableInfo.getName();
        ArrayList serverList = tableInfo.getServer();
        int serverCount = serverList.size();
        ArrayList columnList = tableInfo.getColumn();
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("delete.gsc.tablepartdtl"));
                psmt.setString(1, dbName);
                psmt.setString(2, tableName);
                psmt.execute();
                int[] priorityList = new int[partCount];
                for (int i = 0; i < priorityList.length; ++i) {
                    priorityList[i] = 0;
                }
                Iterator iterator = serverList.iterator();
                while (iterator.hasNext()) {
                    ServerPartition2Info svrPartInfo = (ServerPartition2Info)iterator.next();
                    for (int partNo = 0; partNo < partCount; ++partNo) {
                        int priority;
                        if (!svrPartInfo.getMakeInstance(partNo).booleanValue()) continue;
                        int n = partNo;
                        priorityList[n] = priorityList[n] + 1;
                        psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
                        psmt.setInt(1, this.getDbNo(svrPartInfo.getId(), dbName));
                        psmt.setString(2, dbName);
                        psmt.setString(3, tableName);
                        psmt.setInt(4, partNo);
                        psmt.setInt(5, priority);
                        psmt.execute();
                    }
                }
                psmt = con.prepareStatement(m_sqlResource.getString("update.gsc.tablepart"));
                psmt.setInt(1, partCount);
                psmt.setInt(2, tableInfo.getPartType());
                psmt.setString(3, newHashName);
                psmt.setString(4, dbName);
                psmt.setString(5, tableName);
                psmt.execute();
                psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.partatr"));
                iterator = columnList.iterator();
                while (iterator.hasNext()) {
                    ColumnInfo columnInfo = (ColumnInfo)iterator.next();
                    if (!columnInfo.isPartition()) continue;
                    psmt.setString(1, dbName);
                    psmt.setString(2, tableName);
                    psmt.setString(3, columnInfo.getName());
                    psmt.setInt(4, columnInfo.getNumber());
                    psmt.setString(5, columnInfo.getType());
                    psmt.execute();
                }
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                return false;
            }
        }
        return true;
    }

    public boolean releasePartition(String dbName, String tableName, ArrayList serverList) {
        boolean ret = true;
        String connectUrl = "";
        int serverCount = serverList.size();
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("delete.gsc.tablepartdtl"));
                psmt.setString(1, dbName);
                psmt.setString(2, tableName);
                psmt.execute();
                Iterator iterator = serverList.iterator();
                while (iterator.hasNext()) {
                    ServerInfo svrInfo = (ServerInfo)iterator.next();
                    psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
                    psmt.setInt(1, this.getDbNo(svrInfo.getId(), dbName));
                    psmt.setString(2, dbName);
                    psmt.setString(3, tableName);
                    psmt.setInt(4, 0);
                    psmt.setInt(5, 0);
                    psmt.execute();
                }
                psmt = con.prepareStatement(m_sqlResource.getString("update.gsc.tablepart"));
                psmt.setInt(1, 1);
                psmt.setInt(2, 0);
                psmt.setString(3, null);
                psmt.setString(4, dbName);
                psmt.setString(5, tableName);
                psmt.execute();
                psmt = con.prepareStatement(m_sqlResource.getString("delete.gsc.partatr"));
                psmt.setString(1, dbName);
                psmt.setString(2, tableName);
                psmt.execute();
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean rePartition(String dbName, TableInfo tableInfo, int partCount) {
        ArrayList serverList;
        String connectUrl = "";
        String tableName = tableInfo.getName();
        try {
            serverList = this.getServerList(dbName);
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            return false;
        }
        int serverCount = serverList.size();
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("delete.gsc.tablepartdtl"));
                psmt.setString(1, dbName);
                psmt.setString(2, tableName);
                psmt.execute();
                Iterator iterator = serverList.iterator();
                while (iterator.hasNext()) {
                    ServerInfo serverInfo = (ServerInfo)iterator.next();
                    for (int partNo = 0; partNo < partCount; ++partNo) {
                        int priority = this.getDbNo(serverInfo.getId(), dbName);
                        if ((priority -= partNo) < 0) {
                            priority = serverCount + priority;
                        }
                        psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
                        psmt.setInt(1, this.getDbNo(serverInfo.getId(), dbName));
                        psmt.setString(2, dbName);
                        psmt.setString(3, tableName);
                        psmt.setInt(4, partNo);
                        psmt.setInt(5, priority);
                        psmt.execute();
                    }
                }
                psmt = con.prepareStatement(m_sqlResource.getString("update.gsc.tablepart"));
                psmt.setInt(1, partCount);
                psmt.setInt(2, 1);
                psmt.setString(3, tableInfo.getHashName());
                psmt.setString(4, dbName);
                psmt.setString(5, tableName);
                psmt.execute();
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                return false;
            }
        }
        return true;
    }

    public boolean addTable(String dbName, String tableName) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepart"));
                smt.setString(1, dbName);
                smt.setString(2, tableName);
                smt.execute();
                smt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepartdtl"));
                smt.setString(1, tableName);
                smt.setString(2, dbName);
                smt.execute();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean delTable(String dbName, String tableName) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("delete.gsc.tablepartdtl"));
                smt.setString(1, dbName);
                smt.setString(2, tableName);
                smt.execute();
                smt = con.prepareStatement(m_sqlResource.getString("delete.gsc.tablepart"));
                smt.setString(1, dbName);
                smt.setString(2, tableName);
                smt.execute();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public ArrayList getServerList() throws SQLException {
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Statement smt = con.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.gsc.server.status"));
            while (rs.next()) {
                ServerInfo srvInfo = new ServerInfo();
                srvInfo.setId(rs.getInt("SERVERID"));
                srvInfo.setStatus(rs.getInt("STATUS"));
                srvInfo.setChangeStatus(rs.getInt("STATUS"));
                Properties info = GSCdata.parseURL(rs.getString("URL"));
                srvInfo.setHost(info.getProperty("PGHOST", ""));
                srvInfo.setPort(info.getProperty("PGPORT", ""));
                srvInfo.setId(rs.getInt("SERVERID"));
                servers.add(srvInfo);
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return servers;
    }

    public ArrayList getHashList() throws SQLException {
        ArrayList<HashInfo> servers = new ArrayList<HashInfo>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Statement smt = con.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.gsc.hash"));
            while (rs.next()) {
                servers.add(new HashInfo(rs.getString("NAME"), rs.getString("DESCRIPTION")));
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return servers;
    }

    public byte[] getHashImage(String hashName) throws SQLException {
        byte[] classImage = null;
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("select.gsc.hash.image"));
            psmt.setString(1, hashName);
            ResultSet rs = psmt.executeQuery();
            if (rs.next()) {
                classImage = rs.getBytes("CLASS");
            }
            psmt.close();
            return classImage;
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
    }

    public ArrayList getConfigList() throws SQLException {
        ArrayList<ConfigInfo> configList = new ArrayList<ConfigInfo>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Statement smt = con.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.gsc.config"));
            while (rs.next()) {
                ConfigInfo configInfo = new ConfigInfo();
                configInfo.setConfigId(rs.getString("CONFIGID"));
                configInfo.setDescription(rs.getString("DESCRIPTION"));
                configInfo.setUpdateDate(new Date(rs.getTimestamp("UPDATE_DATE").getTime()));
                configInfo.setCacheReflesh(rs.getLong("CACHE_REFLESH"));
                configInfo.setRetryCount(rs.getLong("RETRY_COUNT"));
                configInfo.setDefectTimeout(rs.getLong("DEFECT_TIMEOUT"));
                configInfo.setDistributedCon(rs.getInt("DISTRIBUTED_CONNECTION"));
                configInfo.setPertitionMode(rs.getBoolean("PERTITION_MODE"));
                configInfo.setSyncMode(rs.getBoolean("SYNCRONIZE_MODE"));
                configList.add(configInfo);
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return configList;
    }

    public ArrayList getBrokenLogList() throws SQLException {
        ArrayList<BrokenLogInfo> brokenLogList = new ArrayList<BrokenLogInfo>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Statement smt = con.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.gsc.broken_log"));
            while (rs.next()) {
                BrokenLogInfo brokenLogInfo = new BrokenLogInfo();
                brokenLogInfo.setServerid(rs.getInt("serverid"));
                brokenLogInfo.setDatetime(new Date(rs.getTimestamp("datetime").getTime()));
                brokenLogInfo.setClient(rs.getString("client"));
                brokenLogInfo.setMsg(rs.getString("msg"));
                brokenLogInfo.setStatus(rs.getString("status"));
                brokenLogInfo.setQuery(rs.getString("query"));
                brokenLogInfo.setServerUrl(rs.getString("url"));
                brokenLogList.add(brokenLogInfo);
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return brokenLogList;
    }

    public ConfigInfo getConfigInfo(String id) throws SQLException {
        ConfigInfo configInfo = new ConfigInfo();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("select.gsc.config.detail"));
            psmt.setString(1, id);
            ResultSet rs = psmt.executeQuery();
            if (rs.next()) {
                configInfo.setConfigId(rs.getString("CONFIGID"));
                configInfo.setDescription(rs.getString("DESCRIPTION"));
                configInfo.setCacheReflesh(rs.getInt("CACHE_REFLESH"));
                configInfo.setDefectTimeout(rs.getInt("DEFECT_TIMEOUT"));
                configInfo.setDistributedCon(rs.getInt("DISTRIBUTED_CONNECTION"));
                configInfo.setRetryCount(rs.getInt("RETRY_COUNT"));
                configInfo.setPertitionMode(rs.getBoolean("PERTITION_MODE"));
                configInfo.setSyncMode(rs.getBoolean("SYNCRONIZE_MODE"));
            }
            psmt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return configInfo;
    }

    public BrokenLogInfo getBrokenLogInfo(String serverid) throws SQLException {
        BrokenLogInfo brokenLogInfo = new BrokenLogInfo();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("select.gsc.brokenlog.detail"));
            psmt.setString(1, serverid);
            ResultSet rs = psmt.executeQuery();
            if (rs.next()) {
                brokenLogInfo.setServerid(rs.getInt("SERVERID"));
                brokenLogInfo.setDatetime(new Date(rs.getTimestamp("DATETIME").getTime()));
                brokenLogInfo.setClient(rs.getString("CLIENT"));
                brokenLogInfo.setMsg(rs.getString("MSG"));
                brokenLogInfo.setStatus(rs.getString("STATUS"));
                brokenLogInfo.setQuery(rs.getString("QUERY"));
                brokenLogInfo.setServerUrl(rs.getString("URL"));
            }
            psmt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return brokenLogInfo;
    }

    public ArrayList getServerList(Integer[] ServerId) throws SQLException {
        String connectUrl = "";
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.gsc.server"));
            for (int i = 0; i < ServerId.length; ++i) {
                if (ServerId[i] == null) continue;
                smt.setInt(1, ServerId[i]);
                ResultSet rs = smt.executeQuery();
                rs.next();
                ServerInfo srvInfo = new ServerInfo();
                srvInfo.setId(rs.getInt("SERVERID"));
                srvInfo.setStatus(rs.getInt("STATUS"));
                Properties info = GSCdata.parseURL(rs.getString("URL"));
                srvInfo.setHost((String)info.get("PGHOST"));
                srvInfo.setPort((String)info.get("PGPORT"));
                srvInfo.setId(rs.getInt("SERVERID"));
                servers.add(srvInfo);
            }
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return servers;
    }

    public ArrayList getServerList(String dbName) throws SQLException {
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.gsc.server.bydbname"));
            smt.setString(1, dbName);
            ResultSet rs = smt.executeQuery();
            while (rs.next()) {
                ServerInfo srvInfo = new ServerInfo();
                srvInfo.setId(rs.getInt("SERVERID"));
                srvInfo.setStatus(rs.getInt("STATUS"));
                Properties info = GSCdata.parseURL(rs.getString("URL"));
                srvInfo.setHost((String)info.get("PGHOST"));
                srvInfo.setPort((String)info.get("PGPORT"));
                srvInfo.setId(rs.getInt("SERVERID"));
                servers.add(srvInfo);
            }
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return servers;
    }

    public ArrayList getDbLinkList(ArrayList serverList) throws SQLException {
        String connectUrl = "";
        ArrayList<DbLinkInfo> dbInfoList = new ArrayList<DbLinkInfo>();
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Statement smt = con.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.gsc.servdb.dblist"));
            String dbName = "";
            DbLinkInfo dbinfo = null;
            block2: while (rs.next()) {
                String dbNameWk = rs.getString("DBNAME");
                if (dbNameWk.compareToIgnoreCase(dbName) != 0) {
                    dbName = dbNameWk;
                    dbinfo = new DbLinkInfo();
                    dbinfo.setName(dbName);
                    dbinfo.setServer(new ArrayList());
                    dbInfoList.add(dbinfo);
                }
                int serverId = rs.getInt("SERVERID");
                ArrayList dbServerList = dbinfo.getServer();
                Iterator iter = serverList.iterator();
                while (iter.hasNext()) {
                    ServerInfo serverInfo = (ServerInfo)iter.next();
                    if (serverInfo.getId() != serverId) continue;
                    ServerInfo dbServer = new ServerInfo();
                    dbServer.setHost(serverInfo.getHost());
                    dbServer.setPort(serverInfo.getPort());
                    dbServer.setId(serverInfo.getId());
                    dbServer.setStatus(serverInfo.getStatus());
                    dbServer.setChangeStatus(serverInfo.getChangeStatus());
                    dbServer.setChkFlag(serverInfo.isChkFlag());
                    dbServerList.add(dbServer);
                    continue block2;
                }
            }
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return dbInfoList;
    }

    public ArrayList getTableList(String dbName) throws SQLException {
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.gsc.table"));
            smt.setString(1, dbName);
            ResultSet rs = smt.executeQuery();
            String tableName = "";
            TableInfo tableInfo = null;
            while (rs.next()) {
                tableInfo = new TableInfo();
                tableInfo.setName(rs.getString("TABLE_NAME"));
                tableInfo.setServer(new ArrayList());
                tableInfo.setPartCount(rs.getInt("PART_COUNT"));
                tableInfo.setPartType(rs.getInt("PART_TYPE"));
                tableInfo.setHashName(rs.getString("HASH_NAME"));
                tableInfo.setStatus(rs.getInt("STATUS"));
                tableList.add(tableInfo);
            }
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return tableList;
    }

    public ArrayList getPartitionColumn(String dbName, String tableName) throws SQLException {
        ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.gsc.partatr"));
            smt.setString(1, dbName);
            smt.setString(2, tableName.toLowerCase());
            ResultSet rs = smt.executeQuery();
            while (rs.next()) {
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.setName(rs.getString("COLUMN_NAME"));
                columnInfo.setNumber(rs.getInt("COLUMN_NO"));
                columnInfo.setPartition(true);
                columnInfo.setType(rs.getString("COLUMN_TYPE"));
                columnList.add(columnInfo);
            }
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return columnList;
    }

    public ArrayList getDbList() {
        ArrayList<String> dbList = new ArrayList<String>();
        try {
            Statement smt = this.getSelectConnectoin().createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.gsc.servdb.db"));
            String dbName = "";
            Object dbinfo = null;
            while (rs.next()) {
                dbList.add(rs.getString("DBNAME"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dbList;
    }

    public int getPartitionCount(String dbName, String tableName) throws SQLException {
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        int partCount = 0;
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement smt = this.getSelectConnectoin().prepareStatement(m_sqlResource.getString("select.gsc.tablepart.partcount"));
            smt.setString(1, dbName);
            smt.setString(2, tableName.toLowerCase());
            ResultSet rs = smt.executeQuery();
            if (rs.next()) {
                partCount = rs.getInt("PART_COUNT");
            }
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return partCount;
    }

    public boolean setDBstatus(ArrayList serverList) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("update.gsc.server.status"));
                Iterator iter2 = serverList.iterator();
                while (iter2.hasNext()) {
                    ServerInfo serverInfo = (ServerInfo)iter2.next();
                    smt.setInt(1, serverInfo.getChangeStatus());
                    smt.setInt(2, serverInfo.getId());
                    smt.execute();
                }
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public ArrayList getGscList() throws SQLException {
        ArrayList<GSCInfo> servers = new ArrayList<GSCInfo>();
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Statement smt = con.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.gsc.gsc"));
            while (rs.next()) {
                GSCInfo gscInfo = new GSCInfo();
                gscInfo.setId(rs.getInt("SERVERID"));
                gscInfo.setDb(rs.getString("DBNAME"));
                Properties info = GSCdata.parseURL(rs.getString("URL"));
                gscInfo.setHost(info.getProperty("PGHOST", ""));
                gscInfo.setPort(info.getProperty("PGPORT", ""));
                gscInfo.setStatus(rs.getInt("STATUS"));
                servers.add(gscInfo);
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return servers;
    }

    public boolean updateGscServer() {
        boolean ret = false;
        try {
            ArrayList gscList = this.getGscList();
            this.clearServers();
            if (gscList != null) {
                for (int i = 0; i < gscList.size(); ++i) {
                    GSCInfo gscinfo = (GSCInfo)gscList.get(i);
                    String hostName = gscinfo.getHost();
                    String portNo = gscinfo.getPort();
                    String dbName = gscinfo.getDb();
                    int status = gscinfo.getStatus();
                    if (dbName.compareTo("") == 0) continue;
                    this.addUrl(hostName, portNo, dbName);
                }
            }
            ret = true;
        }
        catch (SQLException e) {
            ret = false;
        }
        return ret;
    }

    public boolean addGscServer(int serverid, String dbname) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.gsc"));
                psmt.setInt(1, serverid);
                psmt.setString(2, dbname);
                psmt.execute();
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean addGscServer(String dbname, String host, String port) {
        PreparedStatement psmt;
        Connection con;
        boolean ret = true;
        String connectUrl = "";
        String serverUrl = GSCdata.makeUrl(host, port, "");
        int nextServerId = 0;
        Connection conSelect = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)conSelect).getURL();
            Statement smt = conSelect.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString("select.gsc.server.maxserverid"));
            rs.next();
            if (rs.getInt("COUNT") > 0) {
                nextServerId = rs.getInt("MAX") + 1;
            }
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            return false;
        }
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.server"));
                psmt.setInt(1, nextServerId);
                psmt.setString(2, serverUrl.toString());
                psmt.setInt(3, 1);
                psmt.execute();
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                psmt = con.prepareStatement(m_sqlResource.getString("insert.gsc.gsc"));
                psmt.setInt(1, nextServerId);
                psmt.setString(2, dbname);
                psmt.execute();
                psmt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public ArrayList getGscInsertSql() throws SQLException {
        ArrayList sqlList = new ArrayList();
        sqlList = this.getInsertSql(sqlList, "select.gsc.hash.all", "insert.gsc.hash.copy");
        sqlList = this.getInsertSql(sqlList, "select.gsc.config.all", "insert.gsc.config.copy");
        sqlList = this.getInsertSql(sqlList, "select.gsc.server.all", "insert.gsc.server.copy");
        sqlList = this.getInsertSql(sqlList, "select.gsc.servdb.all", "insert.gsc.servdb.copy");
        sqlList = this.getInsertSql(sqlList, "select.gsc.tablepart.all", "insert.gsc.tablepart.copy");
        sqlList = this.getInsertSql(sqlList, "select.gsc.tablepartdtl.all", "insert.gsc.tablepartdtl.copy");
        sqlList = this.getInsertSql(sqlList, "select.gsc.partatr.all", "insert.gsc.partatr.copy");
        sqlList = this.getInsertSql(sqlList, "select.gsc.gsc.all", "insert.gsc.gsc.copy");
        return sqlList;
    }

    public ArrayList getInsertSql(ArrayList sqlList, String sqlSelect, String sqlInsert) throws SQLException {
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Statement smt = con.createStatement();
            ResultSet rs = smt.executeQuery(m_sqlResource.getString(sqlSelect));
            ResultSetMetaData md = rs.getMetaData();
            int colCount = md.getColumnCount();
            while (rs.next()) {
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString(sqlInsert));
                for (int i = 1; i <= colCount; ++i) {
                    psmt.setObject(i, rs.getObject(i));
                }
                String sql = psmt.toString();
                sqlList.add(sql);
            }
            rs.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return sqlList;
    }

    public boolean setGscInsertSql(ArrayList sqlList) {
        boolean ret = true;
        String connectUrl = "";
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Iterator iter = sqlList.iterator();
            while (iter.hasNext()) {
                String sql = (String)iter.next();
                PreparedStatement smt = con.prepareStatement(sql);
                smt.execute();
                smt.close();
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            ret = false;
        }
        return ret;
    }

    public boolean delGscServer(int id, String dbName) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("delete.gsc.gsc"));
                smt.setInt(1, id);
                smt.setString(2, dbName);
                smt.execute();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public ArrayList getPriorityList(String dbName, String tableName, ArrayList serverList) throws SQLException {
        String connectUrl = "";
        int partCount = this.getPartitionCount(dbName, tableName);
        ArrayList<ServerPriorityInfo> priorityList = new ArrayList<ServerPriorityInfo>();
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            Iterator iter = serverList.iterator();
            while (iter.hasNext()) {
                ServerInfo serverInfo = (ServerInfo)iter.next();
                int serverId = serverInfo.getId();
                ServerPriorityInfo serverPriorityInfo = new ServerPriorityInfo();
                serverPriorityInfo.setId(serverInfo.getId());
                serverPriorityInfo.setHost(serverInfo.getHost());
                serverPriorityInfo.setPort(serverInfo.getPort());
                serverPriorityInfo.setStatus(serverInfo.getStatus());
                serverPriorityInfo.setChangeStatus(serverInfo.getChangeStatus());
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.gsc.priority"));
                smt.setInt(1, serverId);
                smt.setString(2, dbName);
                smt.setString(3, tableName);
                ResultSet rs = smt.executeQuery();
                DbBase dbBase = new DbBase(this.m_prop.getProperty("user"), this.m_prop.getProperty("password"));
                dbBase.addUrl(serverPriorityInfo.getHost(), serverInfo.getPort(), dbName);
                dbBase.connect(false);
                Connection targetDBCon = dbBase.getSelectConnectoin();
                PreparedStatement targetDBsmt = targetDBCon.prepareStatement(m_sqlResource.getString("select.tablespace"));
                int i = 0;
                while (rs.next()) {
                    PriorityInfo priorityInfo = new PriorityInfo();
                    priorityInfo.setPartitionNo(rs.getInt("PART_NO"));
                    priorityInfo.setPriority(new Integer(rs.getInt("PRIORITY")));
                    targetDBsmt.setString(1, tableName + "_" + m_dcFmt.format(priorityInfo.getPartitionNo().intValue()));
                    targetDBsmt.execute();
                    ResultSet targetDBrs = targetDBsmt.getResultSet();
                    String tblSpaceName = null;
                    if (targetDBrs.next()) {
                        tblSpaceName = targetDBrs.getString("TABLESPACE");
                    }
                    if (tblSpaceName == null) {
                        tblSpaceName = "";
                    }
                    priorityInfo.setTableSpaceName(tblSpaceName);
                    serverPriorityInfo.addPartition(priorityInfo);
                    targetDBrs.close();
                    ++i;
                }
                priorityList.add(serverPriorityInfo);
                rs.close();
                smt.close();
                targetDBsmt.close();
                dbBase.close();
            }
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
            throw e;
        }
        return priorityList;
    }

    public boolean setPriority(String dbName, String tableName, ArrayList serverList) {
        String connectUrl = "";
        int serverCount = serverList.size();
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                Iterator iterator = serverList.iterator();
                while (iterator.hasNext()) {
                    ServerPriorityInfo svrPriorityInfo = (ServerPriorityInfo)iterator.next();
                    ArrayList priorityList = svrPriorityInfo.getPartition();
                    for (int i = 0; i < priorityList.size(); ++i) {
                        PriorityInfo priorityInfo = (PriorityInfo)priorityList.get(i);
                        PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("update.gsc.tablepartdtl.partition"));
                        psmt.setInt(1, priorityInfo.getPriority());
                        psmt.setInt(2, priorityInfo.getPartitionNo());
                        psmt.setString(3, dbName);
                        psmt.setString(4, tableName);
                        psmt.setString(5, dbName);
                        psmt.setInt(6, svrPriorityInfo.getId());
                        psmt.execute();
                        psmt.close();
                    }
                }
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                return false;
            }
        }
        return true;
    }

    public boolean setDbAdd(String dbName, Integer[] serverIdList) {
        ArrayList tableList;
        String connectUrl = "";
        try {
            tableList = this.getTableList(dbName);
        }
        catch (SQLException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                Iterator iterator = tableList.iterator();
                while (iterator.hasNext()) {
                    TableInfo tableInfo = (TableInfo)iterator.next();
                    String tableName = tableInfo.getName();
                    for (int i = 0; i < serverIdList.length; ++i) {
                        if (serverIdList[i] == null) continue;
                        if (tableInfo.getPartType() == 0) {
                            PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
                            smt.setInt(1, this.getDbNo(serverIdList[i], dbName));
                            smt.setString(2, dbName);
                            smt.setString(3, tableName);
                            smt.setInt(4, 0);
                            smt.setInt(5, 0);
                            smt.execute();
                            smt.close();
                            continue;
                        }
                        if (tableInfo.getPartType() != 1) continue;
                        for (int partNo = 0; partNo < tableInfo.getPartCount(); ++partNo) {
                            int nextPriority = 0;
                            PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.gsc.tablepartdtl.max"));
                            smt.setString(1, dbName);
                            smt.setString(2, tableName);
                            smt.setInt(3, partNo);
                            ResultSet rs = smt.executeQuery();
                            rs.next();
                            if (rs.getInt("COUNT") > 0) {
                                nextPriority = rs.getInt("MAX") + 1;
                            }
                            smt.close();
                            rs.close();
                            smt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
                            smt.setInt(1, this.getDbNo(serverIdList[i], dbName));
                            smt.setString(2, dbName);
                            smt.setString(3, tableName);
                            smt.setInt(4, partNo);
                            smt.setInt(5, nextPriority);
                            smt.execute();
                            smt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                return false;
            }
        }
        return true;
    }

    public boolean setDbShift(String dbName, ArrayList tableList, ArrayList serverList) {
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                for (int i = 0; i < tableList.size(); ++i) {
                    String tableName = (String)tableList.get(i);
                    PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepart"));
                    smt.setString(1, dbName);
                    smt.setString(2, tableName);
                    smt.execute();
                    smt.close();
                    Iterator iterator = serverList.iterator();
                    while (iterator.hasNext()) {
                        ServerInfo serverInfo = (ServerInfo)iterator.next();
                        smt = con.prepareStatement(m_sqlResource.getString("insert.gsc.tablepartdtl.partition"));
                        smt.setInt(1, this.getDbNo(serverInfo.getId(), dbName));
                        smt.setString(2, dbName);
                        smt.setString(3, tableName);
                        smt.setInt(4, 0);
                        smt.setInt(5, 0);
                        smt.execute();
                        smt.close();
                    }
                }
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                return false;
            }
        }
        return true;
    }

    public int getDbNo(int serverId, String dbName) {
        String connectUrl = "";
        int dbNo = -1;
        Connection con = this.getSelectConnectoin();
        try {
            connectUrl = ((Jdbc3Connection)con).getURL();
            PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("select.gsc.servdb.dbno"));
            smt.setInt(1, serverId);
            smt.setString(2, dbName);
            ResultSet rs = smt.executeQuery();
            while (rs.next()) {
                dbNo = rs.getInt("DBNO");
            }
            rs.close();
            smt.close();
        }
        catch (SQLException e) {
            this.setErrInfo(connectUrl, e);
        }
        return dbNo;
    }

    public boolean connect(boolean autocommit) {
        boolean ret = super.connect(autocommit);
        if (!ret) {
            ret = this.removeGsc();
        }
        return ret;
    }

    private boolean removeGsc() {
        boolean ret = false;
        if (this.m_servers.size() <= 1) {
            return ret;
        }
        StringBuffer errUrls = new StringBuffer();
        Iterator iter = this.m_errInfoList.iterator();
        while (iter.hasNext()) {
            ErrInfo element = (ErrInfo)iter.next();
            errUrls.append(element.getUrl());
            errUrls.append("\n");
        }
        boolean removeGsc = true;
        System.out.println(MessagesCommandLine.getString("GSC\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n{0}\n\u51e6\u7406\u5bfe\u8c61\u304b\u3089\u9664\u5916\u3057\u307e\u3059\u3002"));
        if (removeGsc) {
            ArrayList<DbBase.UrlInfo> removeList = new ArrayList<DbBase.UrlInfo>();
            Iterator iter2 = this.m_errInfoList.iterator();
            while (iter2.hasNext()) {
                ErrInfo element = (ErrInfo)iter2.next();
                String errUrl = element.getUrl();
                Iterator iter22 = this.m_servers.iterator();
                while (iter22.hasNext()) {
                    DbBase.UrlInfo url = (DbBase.UrlInfo)iter22.next();
                    String connetStr = "jdbc:postgresql:" + this.makeUrl(url);
                    if (!errUrl.equals(connetStr)) continue;
                    removeList.add(url);
                }
            }
            this.m_servers.removeAll(removeList);
            this.clearErrInfoList();
            ret = true;
        }
        return ret;
    }

    public boolean connectTemplate() {
        boolean ret = super.connectTemplate();
        if (!ret) {
            ret = this.removeGsc();
        }
        return ret;
    }

    public boolean connectSELECT() {
        boolean ret = super.connectSELECT();
        if (!ret && (ret = this.removeGsc())) {
            ret = this.connectSELECT();
        }
        return ret;
    }

    public boolean delBrokenLog(String serverID, Date datetime) {
        boolean ret = true;
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement smt = con.prepareStatement(m_sqlResource.getString("delete.gsc.brokenlog"));
                smt.setString(1, serverID);
                smt.setTimestamp(2, new Timestamp(datetime.getTime()));
                smt.execute();
                smt.close();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean delBrokenLog(int serverID, Date datetime) {
        boolean ret = false;
        ret = this.delBrokenLog(Integer.toString(serverID), datetime);
        return ret;
    }
}

