/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.commandline.action;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.action.ChangePriority;
import org.postgresforest.tool.action.PartitionAction;
import org.postgresforest.tool.action.TableList;
import org.postgresforest.tool.bean.ColumnInfo;
import org.postgresforest.tool.bean.PriorityInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.ServerPartition2Info;
import org.postgresforest.tool.bean.ServerPriorityInfo;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

public class TableActions {
    private static final String REST_MODE = "1";
    private static final String NOREST_MODE = "0";
    private static final String DEFAULT_HASH = "default";
    private static final String HASH_OPTION_NAME = "hashname";
    private static final String REST_OPTION_NAME = "rest";
    protected static DecimalFormat m_dcFmt = new DecimalFormat("00");

    public void part(CommandParser cp, GSCdata gsc, String dbName) {
        boolean isPart2 = false;
        String tableName = (String)cp.getTables().get(0);
        String hashName = null;
        boolean isDataRestore = false;
        ArrayList paramNames = cp.getParamName();
        ArrayList paramValues = cp.getParamValue();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            if (paramName.compareToIgnoreCase(HASH_OPTION_NAME) == 0) {
                hashName = (String)paramValues.get(i);
                if (!hashName.equals(DEFAULT_HASH)) continue;
                hashName = null;
                continue;
            }
            if (paramName.compareToIgnoreCase(REST_OPTION_NAME) == 0) {
                String shiftFlag = (String)paramValues.get(i);
                if (shiftFlag.equals(REST_MODE)) {
                    isDataRestore = true;
                    continue;
                }
                if (shiftFlag.equals(NOREST_MODE)) {
                    isDataRestore = false;
                    continue;
                }
                System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
                return;
            }
            System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
            return;
        }
        TableInfo tableInfo = this.getTableInfo(gsc, dbName, tableName);
        if (tableInfo == null) {
            System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        if (this.partTable(cp, gsc, dbName, tableInfo, hashName, isDataRestore, isPart2)) {
            System.out.println(MessagesCommandLine.getString("cui.message.table.part", new Object[]{tableName}));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.error.table.part", new Object[]{tableName}));
    }

    public void part2(CommandParser cp, GSCdata gsc, String dbName) {
        boolean isPart2 = true;
        String tableName = (String)cp.getTables().get(0);
        String hashName = null;
        boolean isDataRestore = false;
        ArrayList paramNames = cp.getParamName();
        ArrayList paramValues = cp.getParamValue();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            if (paramName.compareToIgnoreCase(HASH_OPTION_NAME) == 0) {
                hashName = (String)paramValues.get(i);
                if (!hashName.equals(DEFAULT_HASH)) continue;
                hashName = null;
                continue;
            }
            if (paramName.compareToIgnoreCase(REST_OPTION_NAME) == 0) {
                String shiftFlag = (String)paramValues.get(i);
                if (shiftFlag.equals(REST_MODE)) {
                    isDataRestore = true;
                    continue;
                }
                if (shiftFlag.equals(NOREST_MODE)) {
                    isDataRestore = false;
                    continue;
                }
                System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
                return;
            }
            System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
            return;
        }
        TableInfo tableInfo = this.getTableInfo(gsc, dbName, tableName);
        if (tableInfo == null) {
            System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        ArrayList setServerList = cp.getServer();
        ArrayList part2NoList = cp.getPart2NoList();
        ArrayList servers = tableInfo.getServer();
        int partCount = Integer.parseInt((String)cp.getPartCnt().get(0));
        for (int i = 0; i < servers.size(); ++i) {
            ServerInfo servInfo = (ServerInfo)servers.get(i);
            ServerPartition2Info partition2Info = new ServerPartition2Info(servInfo, partCount);
            servers.set(i, partition2Info);
            for (int j = 0; j < setServerList.size(); ++j) {
                int k;
                int setServerId = Integer.parseInt((String)setServerList.get(j));
                if (setServerId != servInfo.getId()) continue;
                ArrayList part2No = (ArrayList)part2NoList.get(j);
                for (k = 0; k < partCount; ++k) {
                    partition2Info.setMakeInstance(k, Boolean.FALSE);
                }
                for (k = 0; k < part2No.size(); ++k) {
                    int partNo = Integer.parseInt((String)part2No.get(k));
                    partition2Info.setMakeInstance(partNo, Boolean.TRUE);
                }
                servers.set(i, partition2Info);
            }
        }
        tableInfo.setServer(servers);
        if (this.partTable(cp, gsc, dbName, tableInfo, hashName, isDataRestore, isPart2)) {
            System.out.println(MessagesCommandLine.getString("cui.message.table.part2", new Object[]{tableName}));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.error.table.part2", new Object[]{tableName}));
    }

    public void unpart(CommandParser cp, GSCdata gsc, String dbName) {
        String tableName = (String)cp.getTables().get(0);
        TableInfo tableInfo = this.getTableInfo(gsc, dbName, tableName);
        if (tableInfo == null) {
            System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        PartitionAction exec = new PartitionAction(gsc, dbName);
        try {
            if (exec.del(tableInfo)) {
                System.out.println(MessagesCommandLine.getString("cui.message.table.unpart", new Object[]{tableName}));
                return;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        System.out.println(MessagesCommandLine.getString("cui.error.table.unpart", new Object[]{tableName}));
    }

    public void repart(CommandParser cp, GSCdata gsc, String dbName) {
        int partCount = Integer.parseInt((String)cp.getPartCnt().get(0));
        String tableName = (String)cp.getTables().get(0);
        TableInfo tableInfo = this.getTableInfo(gsc, dbName, tableName);
        if (tableInfo == null) {
            System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        int serverSize = tableInfo.getServer().size();
        if (partCount < 2 || partCount > serverSize) {
            System.out.println(MessagesCommandLine.getString("cui.error.part.partno.invalid", new Object[]{new Integer(serverSize)}));
            return;
        }
        String hashName = null;
        ArrayList paramNames = cp.getParamName();
        ArrayList paramValues = cp.getParamValue();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            if (paramName.compareToIgnoreCase(HASH_OPTION_NAME) == 0) {
                hashName = (String)paramValues.get(i);
                if (!hashName.equals(DEFAULT_HASH)) continue;
                hashName = null;
                continue;
            }
            System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
            return;
        }
        if (tableInfo.getPartType() != 1) {
            System.err.println(MessagesCommandLine.getString("cui.error.table.repart.notpart1", new Object[]{tableName}));
            return;
        }
        PartitionAction rePartition = new PartitionAction(gsc, dbName);
        boolean result = false;
        result = rePartition.repartition(partCount, tableInfo, hashName);
        if (result) {
            System.out.println(MessagesCommandLine.getString("cui.message.table.repart", new Object[]{tableName}));
            return;
        }
        System.err.println(MessagesCommandLine.getString("cui.error.table.repart", new Object[]{tableName}));
    }

    public void showTable(GSCdata gsc, String dbName) {
        ArrayList tableList = null;
        TableList tableListAction = new TableList(gsc);
        try {
            tableList = tableListAction.getTableList(dbName);
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.table.show"));
            System.err.println(e);
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.message.table.show"));
        Iterator it = tableList.iterator();
        System.out.println(" TABLENAME \t| TABLETYPE \t| PARTITION_FUNC \t| STATUS");
        System.out.println("----------------------------------------------");
        while (it.hasNext()) {
            TableInfo tableInfo = (TableInfo)it.next();
            System.out.print(tableInfo.getName() + "\t| ");
            System.out.print(this.convertTableType(tableInfo.getPartType()) + "\t| ");
            System.out.print(this.convertTableHash(tableInfo.getHashName(), tableInfo) + "\t| ");
            System.out.println(this.convertTableStatus(tableInfo.getStatus()));
        }
    }

    public void showTableColumn(CommandParser cp, GSCdata gsc, String dbName) {
        String tableName = (String)cp.getTables().get(0);
        this.showTableColumn(tableName, gsc, dbName);
    }

    public void showTableColumn(String tableName, GSCdata gsc, String dbName) {
        TableInfo tableInfo = this.getTableInfo(gsc, dbName, tableName);
        if (tableInfo == null) {
            System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.message.tablecolumn.show", new Object[]{tableName}));
        Iterator it = tableInfo.getColumn().iterator();
        System.out.println(" PARTITION_KEY\t| COLUMNNAME\t| DATATYPE");
        System.out.println("----------------------------------------------");
        while (it.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)it.next();
            System.out.print(this.convertPartKey(columnInfo.getPartition()) + "\t| ");
            System.out.print(columnInfo.getName() + "\t| ");
            System.out.println(columnInfo.getTypeDetail());
        }
    }

    public void setPriority(CommandParser cp, GSCdata gsc, String dbName) {
        String tableName = (String)cp.getTables().get(0);
        String setPartNo = (String)cp.getPartNo().get(0);
        ArrayList setServerList = cp.getServer();
        TableInfo tableInfo = this.getTableInfo(gsc, dbName, tableName);
        if (tableInfo == null) {
            System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        TableList tableList = new TableList(gsc);
        try {
            TableInfo priorityTableInfo = tableList.getTableInfo(dbName, tableInfo);
            ArrayList priorityServerList = priorityTableInfo.getServer();
            if (setServerList.size() > priorityServerList.size()) {
                System.out.println(MessagesCommandLine.getString("cui.error.priority.set.invalid", new Object[]{tableName}));
                return;
            }
            int setPriorityNum = 0;
            Iterator it = priorityServerList.iterator();
            while (it.hasNext()) {
                ServerPriorityInfo serverPriorityInfo = (ServerPriorityInfo)it.next();
                int serverId = serverPriorityInfo.getId();
                for (int i = 0; i < setServerList.size(); ++i) {
                    int setServerId = Integer.parseInt((String)setServerList.get(i));
                    if (serverId != setServerId) continue;
                    ArrayList priorityInfoList = serverPriorityInfo.getPartition();
                    Iterator it2 = priorityInfoList.iterator();
                    while (it2.hasNext()) {
                        PriorityInfo priorityInfo = (PriorityInfo)it2.next();
                        int partNo = priorityInfo.getPartitionNo();
                        if (partNo != Integer.parseInt(setPartNo)) continue;
                        priorityInfo.setPriority(new Integer(i));
                        ++setPriorityNum;
                    }
                }
            }
            if (setServerList.size() != setPriorityNum) {
                System.out.println(MessagesCommandLine.getString("cui.error.priority.set.invalid", new Object[]{tableName}));
                return;
            }
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.priority.set", new Object[]{tableName}));
            e.printStackTrace();
            return;
        }
        if (!this.validatePriority(tableInfo)) {
            System.out.println(MessagesCommandLine.getString("cui.error.priority.set.invalid", new Object[]{tableName}));
            return;
        }
        ChangePriority changePriority = new ChangePriority(gsc);
        try {
            if (changePriority.execute(dbName, tableInfo)) {
                System.out.println(MessagesCommandLine.getString("cui.message.priority.set", new Object[]{tableName}));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(MessagesCommandLine.getString("cui.error.priority.set", new Object[]{tableName}));
    }

    public void showPriority(CommandParser cp, GSCdata gsc, String dbName) {
        String tableName = (String)cp.getTables().get(0);
        this.showPriority(tableName, gsc, dbName);
    }

    public void showPriority(String tableName, GSCdata gsc, String dbName) {
        TableInfo tableInfo = this.getTableInfo(gsc, dbName, tableName);
        if (tableInfo == null) {
            System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 0; i < tableInfo.getPartCount(); ++i) {
            columnList.add(tableName + "_" + m_dcFmt.format(i));
        }
        System.out.println(MessagesCommandLine.getString("cui.message.priority.show", new Object[]{tableName}));
        TableList tableList = new TableList(gsc);
        try {
            TableInfo priorityTableInfo = tableList.getTableInfo(dbName, tableInfo);
            ArrayList priorityServerList = priorityTableInfo.getServer();
            Iterator it = priorityServerList.iterator();
            System.out.print("SERVERID");
            if (priorityTableInfo.isPartition()) {
                for (int i = 0; i < columnList.size(); ++i) {
                    System.out.print("\t| " + columnList.get(i) + " ");
                }
                System.out.println();
            } else {
                System.out.println("\t| " + tableName);
            }
            System.out.println("----------------------------------------------");
            while (it.hasNext()) {
                ServerPriorityInfo serverPriorityInfo = (ServerPriorityInfo)it.next();
                int serverId = serverPriorityInfo.getId();
                System.out.print(serverId);
                if (priorityTableInfo.isPartition()) {
                    for (int i = 0; i < columnList.size(); ++i) {
                        PriorityInfo priorityInfo = serverPriorityInfo.getPartition(i);
                        if (priorityInfo != null) {
                            int priority = priorityInfo.getPriority();
                            System.out.print("\t| " + priority);
                            continue;
                        }
                        System.out.print("\t|  ");
                    }
                    System.out.println();
                    continue;
                }
                System.out.println("\t| not partitioned");
            }
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.priority.show", new Object[]{tableName}));
            e.printStackTrace();
        }
    }

    private boolean partTable(CommandParser cp, GSCdata gsc, String dbName, TableInfo tableInfo, String hashName, boolean isDataRestore, boolean isPart2) {
        boolean ret = false;
        ArrayList partColumns = cp.getKeyCol();
        int partCount = Integer.parseInt((String)cp.getPartCnt().get(0));
        int serverSize = tableInfo.getServer().size();
        if (partCount < 2 || partCount > serverSize) {
            System.out.println(MessagesCommandLine.getString("cui.error.part.partno.invalid", new Object[]{new Integer(serverSize)}));
            return ret;
        }
        Iterator it = partColumns.iterator();
        while (it.hasNext()) {
            String partColumnName = (String)it.next();
            Iterator it2 = tableInfo.getColumn().iterator();
            while (it2.hasNext()) {
                ColumnInfo columnInfo = (ColumnInfo)it2.next();
                String columnName = columnInfo.getName();
                if (columnName.compareToIgnoreCase(partColumnName) != 0) continue;
                columnInfo.setPartition(true);
            }
        }
        if (!this.validate(tableInfo)) {
            return ret;
        }
        if (isPart2) {
            tableInfo.setPartType(2);
        } else {
            tableInfo.setPartType(1);
        }
        PartitionAction makePartition = new PartitionAction(gsc, dbName);
        boolean result = false;
        try {
            result = makePartition.make(isDataRestore, partCount, tableInfo, hashName);
            if (result) {
                ret = true;
            }
            return ret;
        }
        catch (Exception e) {
            System.err.println(e);
            return ret;
        }
    }

    private boolean validate(TableInfo tableInfo) {
        boolean isChecked = false;
        Iterator iter = tableInfo.getColumn().iterator();
        while (iter.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iter.next();
            if (!columnInfo.isPartition()) continue;
            isChecked = true;
            break;
        }
        return isChecked;
    }

    private boolean validatePriority(TableInfo tableInfo) {
        int m_partCount = tableInfo.getPartCount();
        ArrayList m_servers = tableInfo.getServer();
        boolean result = true;
        block0: for (int partNo = 0; partNo < m_partCount; ++partNo) {
            ArrayList<Integer> priorityNoList = new ArrayList<Integer>();
            Iterator iterator = m_servers.iterator();
            while (iterator.hasNext()) {
                ServerPriorityInfo svrPriorityInfo = (ServerPriorityInfo)iterator.next();
                PriorityInfo priorityInfo = svrPriorityInfo.getPartition(partNo);
                if (priorityInfo == null) continue;
                priorityNoList.add(priorityInfo.getPriority());
            }
            for (int priority = 0; priority < priorityNoList.size(); ++priority) {
                boolean check = false;
                boolean duplicate = false;
                for (int i = 0; i < priorityNoList.size(); ++i) {
                    Integer priorityNo = (Integer)priorityNoList.get(i);
                    if (priority != priorityNo) continue;
                    if (check) {
                        duplicate = true;
                        break;
                    }
                    check = true;
                }
                if (duplicate) {
                    System.out.println(MessagesCommandLine.getString("errors.duplicate", m_dcFmt.format(partNo)));
                    result = false;
                    continue block0;
                }
                if (check) continue;
                Object[] param = new String[]{m_dcFmt.format(partNo), Integer.toString(priority)};
                System.out.println(MessagesCommandLine.getString("errors.priority", param));
                result = false;
                continue block0;
            }
        }
        return result;
    }

    private TableInfo getTableInfo(GSCdata gsc, String dbName, String tableName) {
        TableInfo retTableInfo = null;
        TableList tableListAction = new TableList(gsc);
        try {
            ArrayList tableList = tableListAction.getTableList(dbName);
            Iterator it = tableList.iterator();
            while (it.hasNext()) {
                TableInfo tableInfo2;
                TableInfo tableInfo = (TableInfo)it.next();
                if (!tableName.equals(tableInfo.getName())) continue;
                retTableInfo = tableInfo2 = tableListAction.getTableInfo(dbName, tableInfo);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return retTableInfo;
    }

    private String convertTableType(int type) {
        String ret = "";
        if (type == 0) {
            ret = MessagesCommandLine.getString("form.partition.type0");
        } else if (type == 1) {
            ret = MessagesCommandLine.getString("form.partition.type1");
        } else if (type == 2) {
            ret = MessagesCommandLine.getString("form.partition.type2");
        }
        return ret;
    }

    private String convertTableHash(String hash, TableInfo tableInfo) {
        String ret = "";
        ret = tableInfo.getPartType() == 0 ? "" : (tableInfo.getPartType() != 0 && hash == null ? MessagesCommandLine.getString("form.partition.hash.default") : hash);
        return ret;
    }

    private String convertPartKey(boolean key) {
        String ret = " ";
        if (key) {
            ret = " * ";
        } else if (!key) {
            ret = "   ";
        }
        return ret;
    }

    private String convertTableStatus(int status) {
        String ret = "";
        if (status == 1) {
            ret = MessagesCommandLine.getString("form.admintree.status.ng");
        } else if (status == 0) {
            ret = MessagesCommandLine.getString("form.admintree.status.ok");
        }
        return ret;
    }
}

