/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.ForestToolCommandLine;
import org.postgresforest.tool.db.DbBase;
import org.postgresforest.tool.db.ErrInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.StringReplaceUtil;

public abstract class ActionBase {
    protected GSCdata m_gsc = null;

    public ActionBase(GSCdata gsc) {
        this.m_gsc = gsc;
    }

    protected boolean connect(DbBase db) {
        return this.connect(db, false);
    }

    protected boolean connect(DbBase db, boolean autocommit) {
        if (!db.connect(autocommit)) {
            this.setAccessErrs("errors.db.connect", db);
            return false;
        }
        return true;
    }

    protected boolean connectTemlate(DbBase db) {
        if (!db.connectTemplate()) {
            this.setAccessErrs("errors.db.connect", db);
            return false;
        }
        return true;
    }

    protected boolean connectSelect(DbBase db) {
        if (db == null) {
            return false;
        }
        if (!db.connectSELECT()) {
            this.setAccessErrs("errors.db.connect", db);
            return false;
        }
        return true;
    }

    protected void setAccessErrs(DbBase db) {
        this.setAccessErrs("errors.db", db);
    }

    protected void setAccessErrs(String key, DbBase db) {
        ForestToolCommandLine plugin = ForestToolCommandLine.getDefault();
        String errMessage = "";
        ArrayList errInfoList = db.getErrInfoList();
        Iterator iter = errInfoList.iterator();
        while (iter.hasNext()) {
            ErrInfo errInfo = (ErrInfo)iter.next();
            StringReplaceUtil strUtil = new StringReplaceUtil(MessagesCommandLine.getString("errors.db.detail"));
            strUtil.set(1, errInfo.getUrl());
            strUtil.set(2, errInfo.getErrMessage());
            errMessage = errMessage + strUtil.get() + "\n";
        }
        System.out.println(errMessage);
        db.clearErrInfoList();
    }
}

