/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.HashInfo;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Table2StringUtil;

public class HashActions {
    private static final String[] SHOW_HASH_HEADER = new String[]{"HASHNAME", "DESCRIPTION"};

    public static void create(CommandParser cp, GSCdata gsc) {
        String className = cp.getHashName();
        if (className == null || className.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        String fileName = cp.getHashFile();
        if (fileName == null || fileName.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        String description = cp.getHashDescript();
        if (description == null) {
            description = "";
        }
        byte[] byteImg = null;
        try {
            byteImg = HashActions.getFileByteImage(fileName);
        }
        catch (FileNotFoundException e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.command.filenotfound", new Object[]{fileName}));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        catch (Exception e1) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.hash.create", new Object[]{className}));
            Logger.error((String)e1.getMessage());
            Logger.trace((Exception)e1);
            return;
        }
        if (gsc.registerHash(className, description, byteImg)) {
            Logger.println((String)MessagesCommandLine.getString("cui.message.hash.create", new Object[]{className}));
            return;
        }
        Logger.error((String)MessagesCommandLine.getString("cui.error.hash.create", new Object[]{className}));
    }

    public static void drop(CommandParser cp, GSCdata gsc) {
        String id = cp.getHashName();
        if (id == null || id.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        if (!gsc.unregisterHash(id)) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.hash.drop", new Object[]{id}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.hash.drop", new Object[]{id}));
    }

    public static void show(GSCdata gsc) {
        String[] hashNames;
        try {
            hashNames = gsc.getHashNames();
        }
        catch (Exception e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.hash.show"));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.hash.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_HASH_HEADER);
        if (hashNames != null) {
            for (int i = 0; i < hashNames.length; ++i) {
                HashInfo hashInfo = gsc.getHash(hashNames[i]);
                if (hashNames == null) {
                    Logger.error((String)MessagesCommandLine.getString("cui.error.hash.show"));
                    return;
                }
                ArrayList<String> row = new ArrayList<String>();
                row.add(hashInfo.getId());
                if (hashInfo.getDescription() == null) {
                    row.add("");
                } else {
                    row.add(hashInfo.getDescription());
                }
                table2StringUtil.addRow(row);
            }
        }
        table2StringUtil.print();
    }

    private static byte[] getFileByteImage(String fileName) throws FileNotFoundException, IOException {
        int nBytes;
        byte[] buf = new byte[64];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(fileName);
        while ((nBytes = in.read(buf)) > 0) {
            out.write(buf, 0, nBytes);
        }
        in.close();
        byte[] byteImg = out.toByteArray();
        out.close();
        return byteImg;
    }
}

