/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.Database;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.lib.Table;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Misc;
import org.postgresforest.tool.util.Parser;
import org.postgresforest.tool.util.Table2StringUtil;

public class DbActions {
    private static final String[] SHOW_DB_HEADER = new String[]{"DBNAME", "SERVERID", "HOST", "PORT"};

    public static void create(CommandParser cp, GSCdata gsc) {
        String dbName = cp.getDB();
        if (dbName == null || dbName.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        String option = "";
        Iterator it = cp.getOption().iterator();
        while (it.hasNext()) {
            option = option + (String)it.next();
        }
        ArrayList chkServerList = cp.getServer();
        String serverListStr = "";
        int[] ids = new int[chkServerList.size()];
        for (int i = 0; i < ids.length; ++i) {
            String idStr = (String)chkServerList.get(i);
            ids[i] = Integer.parseInt(idStr);
            serverListStr = serverListStr + idStr + ",";
        }
        try {
            Database db = option.equals("") ? gsc.createDatabase(ids, dbName) : gsc.createDatabase(ids, dbName, option);
            if (db == null) {
                Logger.error((String)MessagesCommandLine.getString("cui.error.db.create", new Object[]{dbName, serverListStr}));
                return;
            }
        }
        catch (Exception e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.db.create", new Object[]{dbName, serverListStr}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.db.create", new Object[]{dbName, serverListStr}));
    }

    public static void drop(CommandParser cp, GSCdata gsc) {
        String dbName = cp.getDB();
        if (dbName == null || dbName.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        boolean force = cp.isForce();
        if (!gsc.dropDatabase(dbName, force)) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.db.drop", new Object[]{dbName}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.db.drop", new Object[]{dbName}));
    }

    public static void restore(CommandParser cp, GSCdata gsc) {
        Logger.warning((String)"restore db ");
        Logger.warning((String)"Not implemented yet");
    }

    public static void show(GSCdata gsc) {
        String[] dbNames;
        try {
            dbNames = gsc.getDatabaseNames();
        }
        catch (ForestToolException e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.show"));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)((Object)e));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.db.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_DB_HEADER);
        for (int i = 0; i < dbNames.length; ++i) {
            Database d = null;
            try {
                d = gsc.getDatabase(dbNames[i]);
            }
            catch (Exception e) {
                Logger.error((String)e.getMessage());
                Logger.trace((Exception)e);
                return;
            }
            int[] ids = d.getInstanceIds();
            for (int j = 0; j < ids.length; ++j) {
                Instance instance = gsc.getInstance(ids[j]);
                if (instance == null) {
                    Logger.error((String)MessagesCommandLine.getString("cui.error.gsc.show"));
                    return;
                }
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(dbNames[i]);
                row.add(new Integer(instance.getId()));
                row.add(instance.getHostName());
                row.add(instance.getPortNumber());
                table2StringUtil.addRow(row);
            }
        }
        table2StringUtil.print();
    }

    public static void createDbInstance(CommandParser cp, GSCdata gsc) {
        String dbName = cp.getDB();
        if (dbName == null || dbName.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        int instanceId = Integer.parseInt((String)cp.getServer().get(0));
        boolean force = cp.isForce();
        Database database = null;
        try {
            database = gsc.getDatabase(dbName);
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        if (database == null) {
            Logger.error((String)"Databese NotFound!");
            return;
        }
        Instance instance = gsc.getInstance(instanceId);
        if (instance == null) {
            Logger.error((String)MessagesCommandLine.getString("instance notfound!"));
            return;
        }
        if (!database.addInstance(instance, force)) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.db.instance.add", new Object[]{dbName, Integer.toString(instanceId)}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.db.instance.add", new Object[]{dbName, Integer.toString(instanceId)}));
    }

    public static void dropDbInstance(CommandParser cp, GSCdata gsc) {
        boolean force;
        String dbName = cp.getDB();
        if (dbName == null || dbName.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        int instanceId = Integer.parseInt((String)cp.getServer().get(0));
        if (!gsc.dropDatabase(dbName, instanceId, force = cp.isForce())) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.db.instance.delete", new Object[]{dbName, Integer.toString(instanceId)}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.db.instance.delete", new Object[]{dbName, Integer.toString(instanceId)}));
    }

    public static void executeDdl(String command, Parser parser, Database database) {
        try {
            Logger.println((String)MessagesCommandLine.getString("message.ddl.header"));
            Logger.println((String)command);
            boolean statusOk = false;
            String tableName = null;
            int type = parser.getType();
            block2 : switch (type) {
                case 1: 
                case 3: {
                    Table table = database.createTable(command);
                    if (table == null) break;
                    statusOk = true;
                    break;
                }
                case 2: 
                case 4: {
                    tableName = (String)parser.getTables().get(0);
                    statusOk = database.dropTable(tableName);
                    break;
                }
                case 6: {
                    tableName = (String)parser.getTables().get(0);
                    Table table2 = database.getTable(tableName);
                    statusOk = table2.alter(command);
                    break;
                }
                case 5: {
                    tableName = (String)parser.getTables().get(0);
                    Table table3 = database.getTable(tableName);
                    statusOk = table3.createIndex(command);
                    break;
                }
                case 7: 
                case 8: {
                    String[] tables;
                    String dropIndexName = parser.getReplaceWord();
                    try {
                        tables = database.getTableNames();
                    }
                    catch (ForestToolException e) {
                        Logger.error((String)"Can't get table name(s) from GSC.");
                        Logger.error((String)e.getMessage());
                        Logger.trace((Exception)((Object)e));
                        break;
                    }
                    if (tables.length == 0) {
                        Logger.error((String)"No table was specified to be dropped.");
                        break;
                    }
                    for (int i = 0; i < tables.length; ++i) {
                        Table table4 = database.getTable(tables[i]);
                        String[] indexNames = table4.getIndexNames();
                        if (!Misc.containsIgnoreCase(dropIndexName, indexNames)) continue;
                        if (type == 8) {
                            statusOk = table4.alter(command);
                            break block2;
                        }
                        if (type != 7) break block2;
                        statusOk = table4.dropIndex(dropIndexName);
                        break block2;
                    }
                    break;
                }
                default: {
                    Logger.warning((String)"execute DDL");
                    Logger.warning((String)"Not implemented yet");
                }
            }
            Logger.println((String)MessagesCommandLine.getString("message.ddl.result"));
            if (statusOk) {
                Logger.println((String)MessagesCommandLine.getString("message.ddl.execute"));
            } else {
                Logger.error((String)MessagesCommandLine.getString("message.ddl.error.detail"));
                Logger.error((String)"\n");
            }
            Logger.println((String)"\n");
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
        }
    }
}

