/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class psql {
    Connection db;
    Statement st;
    DatabaseMetaData dbmd;
    boolean done = false;
    private static final String[] allUserTables = new String[]{"TABLE", "INDEX", "SEQUENCE"};
    private static final String[] usrIndices = new String[]{"INDEX"};
    private static final String[] usrTables = new String[]{"TABLE"};
    private static final String[] usrSequences = new String[]{"SEQUENCE"};
    private static final String[] sysTables = new String[]{"SYSTEM TABLE", "SYSTEM INDEX"};

    public psql(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String url = args[0];
        String usr = args[1];
        String pwd = args[2];
        Class.forName("org.postgresforest.Driver");
        System.out.println("Connecting to Database URL = " + url);
        this.db = DriverManager.getConnection(url, usr, pwd);
        this.dbmd = this.db.getMetaData();
        this.st = this.db.createStatement();
        System.out.println("Connected to " + this.dbmd.getDatabaseProductName() + " " + this.dbmd.getDatabaseProductVersion());
        System.out.println();
        StreamTokenizer input = new StreamTokenizer(new InputStreamReader(System.in));
        input.resetSyntax();
        input.slashSlashComments(true);
        input.eolIsSignificant(false);
        input.wordChars(32, 126);
        input.whitespaceChars(59, 59);
        int tt = 0;
        int lineno = 1;
        while (tt != -1 && !this.done) {
            System.out.print("[" + lineno + "] ");
            System.out.flush();
            try {
                tt = input.nextToken();
                if (tt != -3) continue;
                this.processLine(input.sval);
                ++lineno;
            }
            catch (SQLException ex) {
                System.out.println(ex.getMessage());
            }
        }
        System.out.println("Now closing the connection");
        this.st.close();
        this.db.close();
    }

    public void processLine(String line) throws SQLException {
        if (line.startsWith("\\")) {
            this.processSlashCommand(line);
            return;
        }
        boolean type = this.st.execute(line);
        boolean loop = true;
        while (loop) {
            if (type) {
                ResultSet rs = this.st.getResultSet();
                this.displayResult(rs);
            } else {
                int count = this.st.getUpdateCount();
                if (count == -1) {
                    loop = false;
                } else {
                    System.out.println("Updated " + this.st.getUpdateCount() + " rows");
                }
            }
            if (!loop) continue;
            type = this.st.getMoreResults();
        }
    }

    public void displayResult(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (i = 1; i <= cols; ++i) {
            System.out.print(rsmd.getColumnLabel(i) + (i < cols ? "\t" : "\n"));
        }
        while (rs.next()) {
            for (i = 1; i <= cols; ++i) {
                Object o = rs.getObject(i);
                if (rs.wasNull()) {
                    System.out.print("{null}" + (i < cols ? "\t" : "\n"));
                    continue;
                }
                System.out.print(o.toString() + (i < cols ? "\t" : "\n"));
            }
        }
        rs.close();
    }

    public void processSlashCommand(String line) throws SQLException {
        if (line.startsWith("\\d")) {
            if (line.startsWith("\\d ")) {
                String table = line.substring(3);
                this.displayResult(this.dbmd.getColumns(null, null, table, "%"));
            } else {
                String[] types = null;
                if (line.equals("\\d")) {
                    types = allUserTables;
                } else if (line.equals("\\di")) {
                    types = usrIndices;
                } else if (line.equals("\\dt")) {
                    types = usrTables;
                } else if (line.equals("\\ds")) {
                    types = usrSequences;
                } else if (line.equals("\\dS")) {
                    types = sysTables;
                } else {
                    throw new SQLException("Unsupported \\d command: " + line);
                }
                this.displayResult(this.dbmd.getTables(null, null, "%", types));
            }
        } else if (line.equals("\\q")) {
            this.done = true;
        } else {
            throw new SQLException("Unsupported \\ command: " + line);
        }
    }

    public static void instructions() {
        System.out.println("\nThis example shows how some of the other JDBC features work within the\ndriver. It does this by implementing a very simple psql equivalent in java.\nNot everything that psql does is implemented.\n");
        System.out.println("Useage:\n java example.psql jdbc:postgresql:database user password [debug]\n\nThe debug field can be anything. It's presence will enable DriverManager's\ndebug trace. Unless you want to see screens of items, don't put anything in\nhere.");
        System.exit(1);
    }

    public static void main(String[] args) {
        System.out.println("PostgreSQL psql example v6.3 rev 1\n");
        if (args.length < 3) {
            psql.instructions();
        }
        if (args.length > 3) {
            DriverManager.setLogStream(System.err);
        }
        try {
            psql test = new psql(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }
}

