/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Jpsql {
    private StringBuffer m_sql = new StringBuffer();
    private boolean m_isQuoteChar = false;
    private boolean m_lineComment = false;
    private int m_slashStarComments = 0;
    private static Connection db;
    private static String driver;
    private static String url;
    private static String usr;
    private static String pwd;
    private static String inputfile;
    Statement st;
    DatabaseMetaData dbmd;
    boolean done = false;
    String newLineCode = System.getProperty("line.separator");
    private static final String[] allUserTables;
    private static final String[] usrIndices;
    private static final String[] usrTables;
    private static final String[] usrSequences;
    private static final String[] sysTables;

    public Jpsql(String[] args) throws SQLException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Connecting to Database URL = " + url + " (user:" + usr + ")");
        db = DriverManager.getConnection(url, usr, pwd);
        this.dbmd = db.getMetaData();
        this.st = db.createStatement();
        System.out.println("Connected to " + this.dbmd.getDatabaseProductName() + " " + this.dbmd.getDatabaseProductVersion());
        System.out.println();
        if (inputfile != null) {
            System.out.println("Using SQL file input from " + inputfile);
            this.ProcessSqlFile(inputfile);
            System.exit(0);
        } else {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            int lineno = 1;
            try {
                while (!this.done) {
                    int contents;
                    System.out.print("[" + lineno + "] ");
                    System.out.flush();
                    StringBuffer line = new StringBuffer();
                    while ((contents = in.read()) != -1) {
                        line.append((char)contents);
                        if (contents != 10) continue;
                        this.processLine(line.toString());
                        ++lineno;
                        break;
                    }
                    if (contents != -1) continue;
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Now closing the connection");
        this.st.close();
        db.close();
    }

    public void processLine(String line) throws IOException {
        StringBuffer backSlashCmd = null;
        boolean isBackSlashCmd = false;
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(48, 57);
        tokenizer.ordinaryChar(47);
        tokenizer.eolIsSignificant(true);
        int token = -1;
        block12: while ((token = tokenizer.nextToken()) != -1) {
            if (isBackSlashCmd) {
                if (token == -3) {
                    backSlashCmd.append(tokenizer.sval);
                    continue;
                }
                if (token == 10) {
                    this.m_sql.append((char)tokenizer.ttype);
                    try {
                        this.processSlashCommand(backSlashCmd.toString().trim());
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                    }
                    continue;
                }
                backSlashCmd.append((char)tokenizer.ttype);
                continue;
            }
            if (this.m_slashStarComments > 0) {
                if (token == 42) {
                    token = tokenizer.nextToken();
                    if (token == 47) {
                        --this.m_slashStarComments;
                        continue;
                    }
                    tokenizer.pushBack();
                    continue;
                }
                if (token != 47) continue;
                token = tokenizer.nextToken();
                if (token == 42) {
                    ++this.m_slashStarComments;
                    continue;
                }
                tokenizer.pushBack();
                continue;
            }
            if (this.m_lineComment) {
                if (token != 10) continue;
                this.m_lineComment = false;
            }
            switch (token) {
                case 59: {
                    this.m_sql.append((char)tokenizer.ttype);
                    if (this.m_isQuoteChar) continue block12;
                    System.out.println("SQL:" + this.m_sql.toString());
                    String sql = this.m_sql.toString();
                    this.m_sql = new StringBuffer();
                    try {
                        boolean type = this.st.execute(sql);
                        boolean loop = true;
                        while (loop) {
                            if (type) {
                                ResultSet rs = this.st.getResultSet();
                                this.displayResult(rs);
                            } else {
                                int count = this.st.getUpdateCount();
                                if (count == -1) {
                                    loop = false;
                                } else {
                                    System.out.println("Updated " + this.st.getUpdateCount() + " rows");
                                }
                            }
                            if (!loop) continue;
                            type = this.st.getMoreResults();
                        }
                        continue block12;
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                        continue block12;
                    }
                }
                case -3: {
                    this.m_sql.append(tokenizer.sval);
                    continue block12;
                }
                case 39: {
                    if (this.m_isQuoteChar) {
                        token = tokenizer.nextToken();
                        if (token == 39) {
                            this.m_sql.append("\\'");
                            continue block12;
                        }
                        tokenizer.pushBack();
                    }
                    this.m_sql.append('\'');
                    this.m_isQuoteChar = !this.m_isQuoteChar;
                    continue block12;
                }
                case 45: {
                    if (this.m_isQuoteChar) {
                        this.m_sql.append((char)tokenizer.ttype);
                        continue block12;
                    }
                    token = tokenizer.nextToken();
                    if (token == 45) {
                        this.m_lineComment = true;
                        continue block12;
                    }
                    this.m_sql.append('-');
                    tokenizer.pushBack();
                    continue block12;
                }
                case 47: {
                    if (this.m_isQuoteChar) {
                        this.m_sql.append((char)tokenizer.ttype);
                        continue block12;
                    }
                    token = tokenizer.nextToken();
                    if (token == 42) {
                        ++this.m_slashStarComments;
                        continue block12;
                    }
                    this.m_sql.append('/');
                    tokenizer.pushBack();
                    continue block12;
                }
                case 92: {
                    if (this.m_isQuoteChar) {
                        this.m_sql.append((char)tokenizer.ttype);
                        token = tokenizer.nextToken();
                        if (token == 92 || token == 39) {
                            this.m_sql.append((char)tokenizer.ttype);
                            continue block12;
                        }
                        tokenizer.pushBack();
                        continue block12;
                    }
                    isBackSlashCmd = true;
                    backSlashCmd = new StringBuffer("\\");
                    continue block12;
                }
            }
            this.m_sql.append((char)tokenizer.ttype);
        }
    }

    public void displayResult(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (i = 1; i <= cols; ++i) {
            System.out.print(rsmd.getColumnLabel(i) + (i < cols ? "\t" : "\n"));
        }
        System.out.flush();
        while (rs.next()) {
            for (i = 1; i <= cols; ++i) {
                Object o = rs.getObject(i);
                if (rs.wasNull()) {
                    System.out.print("{null}" + (i < cols ? "\t" : "\n"));
                } else {
                    System.out.print(o.toString() + (i < cols ? "\t" : "\n"));
                }
                System.out.flush();
            }
        }
        rs.close();
    }

    public void processSlashCommand(String line) throws SQLException {
        if (line.startsWith("\\d")) {
            if (line.startsWith("\\d ")) {
                String table = line.substring(3);
                this.displayResult(this.dbmd.getColumns(null, null, table, "%"));
            } else {
                String[] types = null;
                if (line.equals("\\d")) {
                    types = allUserTables;
                } else if (line.equals("\\di")) {
                    types = usrIndices;
                } else if (line.equals("\\dt")) {
                    types = usrTables;
                } else if (line.equals("\\ds")) {
                    types = usrSequences;
                } else if (line.equals("\\dS")) {
                    types = sysTables;
                } else {
                    throw new SQLException("Unsupported \\d command: " + line);
                }
                this.displayResult(this.dbmd.getTables(null, null, "%", types));
            }
        } else if (line.equals("\\q")) {
            this.done = true;
        } else {
            throw new SQLException("Unsupported \\ command: " + line);
        }
    }

    public static void instructions() {
        System.out.println("\n\u8d77\u52d5\u30a8\u30e9\u30fc\n\tUsage :Jpsql [\u30b3\u30f3\u30d5\u30a3\u30b0\u30ec\u30fc\u30b7\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb] [SQL\u30d5\u30a1\u30a4\u30eb(\u30aa\u30d7\u30b7\u30e7\u30f3)]\n\n");
        System.exit(1);
    }

    public static void instructions(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("Jpsql", options, true);
    }

    public void ProcessSqlFile(String filename) {
        BufferedReader br;
        StringBuffer line = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            System.out.println("file " + filename + " not found.");
            return;
        }
        try {
            int contents;
            while ((contents = br.read()) != -1) {
                line.append((char)contents);
                if (contents != 10) continue;
                this.processLine(line.toString());
                line = new StringBuffer();
            }
            if (line.toString().trim().length() > 0) {
                this.processLine(line.toString());
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        System.out.println("Welcome to Jpsql, the PostgreSQL interactive terminal. ");
        try {
            Jpsql.parseOptions(args);
        }
        catch (ParseException e) {
            e.getMessage();
        }
        if (pwd == null) {
            PasswordCallback pass = new PasswordCallback("Password > ", false);
            Callback[] callbacks = new Callback[]{pass};
            InputShadowPassword cbHandler = new InputShadowPassword();
            try {
                cbHandler.handle(callbacks);
                pwd = new String(pass.getPassword());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedCallbackException e) {
                e.printStackTrace();
            }
        }
        try {
            Jpsql test = new Jpsql(args);
        }
        catch (Exception ex) {
            System.err.println("Unknown Exception caught.\n" + ex);
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static Option makeOption(boolean isRequired, boolean hasArg, String argName, String description, String longOpt, String opt) {
        OptionBuilder.isRequired((boolean)isRequired);
        OptionBuilder.hasArg((boolean)hasArg);
        OptionBuilder.withArgName((String)argName);
        OptionBuilder.withDescription((String)description);
        OptionBuilder.withLongOpt((String)longOpt);
        Option retOption = OptionBuilder.create((String)opt);
        return retOption;
    }

    private static void parseOptions(String[] args) throws ParseException {
        Options options = new Options();
        Option driverOption = Jpsql.makeOption(true, true, "driver", "PostgreSQL Driver Class Name", "driver", "d");
        Option urlOption = Jpsql.makeOption(true, true, "url", "JDBC url string(org.postgresql.driver", "url", "u");
        Option userOption = Jpsql.makeOption(true, true, "user", "DataBase user name", "user", "U");
        Option passOption = Jpsql.makeOption(false, true, "password", "DataBase user password", "password", "W");
        Option fileOption = Jpsql.makeOption(false, true, "inputfile", "SQL input file", "inputfile", "f");
        Option helpOption = Jpsql.makeOption(false, false, "", "help", "help", "h");
        options.addOption(driverOption);
        options.addOption(urlOption);
        options.addOption(userOption);
        options.addOption(passOption);
        options.addOption(fileOption);
        options.addOption(helpOption);
        GnuParser parser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            if (cmd.hasOption('h')) {
                Jpsql.instructions(options);
                System.exit(1);
            }
        }
        catch (ParseException e) {
            Jpsql.instructions(options);
            System.exit(-1);
        }
        if (cmd.hasOption('d')) {
            driver = cmd.getOptionValue('d');
        }
        if (cmd.hasOption('u')) {
            url = cmd.getOptionValue('u');
        }
        if (cmd.hasOption('U')) {
            usr = cmd.getOptionValue('U');
        }
        if (cmd.hasOption('W')) {
            pwd = cmd.getOptionValue('W');
        }
        if (cmd.hasOption('f')) {
            inputfile = cmd.getOptionValue('f');
        }
    }

    static {
        driver = null;
        url = null;
        usr = null;
        pwd = null;
        inputfile = null;
        allUserTables = new String[]{"TABLE", "INDEX", "SEQUENCE"};
        usrIndices = new String[]{"INDEX"};
        usrTables = new String[]{"TABLE"};
        usrSequences = new String[]{"SEQUENCE"};
        sysTables = new String[]{"SYSTEM TABLE", "SYSTEM INDEX"};
    }
}

