/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.lib;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.postgresforest.tool.ArrayUtil;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.SqlTokenizer;
import org.postgresforest.tool.lib.TableUtils;
import org.postgresforest.vm.Hash_I;

public class PartitionUtils {
    public static String buildPartitionName(String relname, int part) {
        return PartitionUtils.partName(relname, part);
    }

    private static String partSuffix(int part) {
        return "_" + (part < 10 ? "0" : "") + part;
    }

    private static String partName(String relname, int part) {
        return relname + PartitionUtils.partSuffix(part);
    }

    public static String buildUnionAllViewDef(int partCount, String relname) {
        int[] partNum = new int[partCount];
        for (int i = 0; i < partCount; ++i) {
            partNum[i] = i;
        }
        return PartitionUtils.buildUnionAllViewDef(partNum, relname);
    }

    public static String buildUnionAllViewDef(int[] partNum, String relname) {
        String def = "CREATE VIEW " + relname + " AS (\n";
        for (int i = 0; i < partNum.length; ++i) {
            if (i > 0) {
                def = def + "    UNION ALL\n";
            }
            def = def + "  ( SELECT * FROM " + PartitionUtils.partName(relname, partNum[i]) + " )\n";
        }
        def = def + ");\n";
        return def;
    }

    public static String buildUpdateRuleDef(int partCount, String relname, String[] pkeys, String[] cols) {
        String def = "";
        def = def + "CREATE RULE " + relname + "_upd AS ON UPDATE TO " + relname + " DO INSTEAD (\n";
        for (int i = 0; i < partCount; ++i) {
            def = def + "    UPDATE " + PartitionUtils.partName(relname, i) + " SET " + PartitionUtils.buildSetClauseForRule(cols);
            def = def + " WHERE " + PartitionUtils.buildWhereClauseForRule(relname, pkeys, i) + ";\n";
        }
        def = def + ");\n";
        return def;
    }

    public static String buildUpdateRuleDef(int[] partNum, String relname, String[] pkeys, String[] cols) {
        String def = "";
        def = def + "CREATE RULE " + relname + "_upd AS ON UPDATE TO " + relname + " DO INSTEAD (\n";
        for (int i = 0; i < partNum.length; ++i) {
            def = def + "    UPDATE " + PartitionUtils.partName(relname, partNum[i]) + " SET " + PartitionUtils.buildSetClauseForRule(cols);
            def = def + " WHERE " + PartitionUtils.buildWhereClauseForRule(relname, pkeys, i) + ";\n";
        }
        def = def + ");\n";
        return def;
    }

    public static String buildDeleteRuleDef(int partCount, String relname, String[] pkeys) {
        String def = "";
        def = def + "CREATE RULE " + relname + "_del AS ON DELETE TO " + relname + " DO INSTEAD (\n";
        for (int i = 0; i < partCount; ++i) {
            def = def + "    DELETE FROM " + PartitionUtils.partName(relname, i);
            def = def + " WHERE " + PartitionUtils.buildWhereClauseForRule(relname, pkeys, i) + ";\n";
        }
        def = def + ");\n";
        return def;
    }

    public static String buildDeleteRuleDef(int[] partNum, String relname, String[] pkeys) {
        String def = "";
        def = def + "CREATE RULE " + relname + "_del AS ON DELETE TO " + relname + " DO INSTEAD (\n";
        for (int i = 0; i < partNum.length; ++i) {
            def = def + "    DELETE FROM " + PartitionUtils.partName(relname, partNum[i]);
            def = def + " WHERE " + PartitionUtils.buildWhereClauseForRule(relname, pkeys, i) + ";\n";
        }
        def = def + ");\n";
        return def;
    }

    public static String buildPartitionDefs(int partCount, String relname, String[] partKeys, String hashName) {
        String def = "";
        for (int i = 0; i < partCount; ++i) {
            def = def + "CREATE TABLE " + PartitionUtils.partName(relname, i) + " AS SELECT * FROM " + relname;
            if (partKeys.length <= 2) {
                if (hashName == null || hashName.equals("null")) {
                    hashName = "org.postgresforest.vm.Hash01";
                }
                def = def + " WHERE postgresforest.getpartnum('" + hashName + "'," + partCount + ",";
                if (partKeys.length == 1) {
                    def = def + partKeys[0];
                } else if (partKeys.length == 2) {
                    def = def + partKeys[0] + "," + partKeys[1];
                }
                def = def + ") = " + i + ";\n";
                continue;
            }
            def = def + " LIMIT 0;\n";
        }
        return def;
    }

    private static String buildSetClauseForRule(String[] cols) {
        String def = "";
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                def = def + ",";
            }
            def = def + cols[i] + "=NEW." + cols[i];
        }
        return def;
    }

    private static String buildWhereClauseForRule(String relname, String[] pkeys, int part) {
        String buf = "";
        for (int i = 0; i < pkeys.length; ++i) {
            if (0 < i) {
                buf = buf + " AND ";
            }
            String pkey = pkeys[i];
            buf = buf + "(" + pkey + "=OLD." + pkey + " OR ( " + pkey + " IS NULL AND OLD." + pkey + " IS NULL ) )";
        }
        return buf;
    }

    public static String[] buildIndexDefs(int partCount, String relname, String[] indexDefs) {
        ArrayList<String> a = new ArrayList<String>();
        for (int j = 0; j < partCount; ++j) {
            for (int i = 0; i < indexDefs.length; ++i) {
                SqlTokenizer t = new SqlTokenizer(indexDefs[i]);
                String indexDef = "";
                boolean indexName = false;
                while (t.hasMoreToken()) {
                    String token = t.nextToken();
                    if (token.equalsIgnoreCase(relname)) {
                        indexDef = indexDef + PartitionUtils.partName(token, j);
                    } else if (indexName && t.ttype != 0) {
                        indexDef = indexDef + token + PartitionUtils.partSuffix(j);
                        indexName = false;
                    } else {
                        indexDef = indexDef + token;
                    }
                    Logger.debug("buildIndexDefs: token=" + token + ",type=" + t.ttype);
                    if (!token.equalsIgnoreCase("INDEX")) continue;
                    indexName = true;
                }
                a.add(indexDef);
                Logger.debug("buildIndexDefs: " + indexDef);
            }
        }
        return ArrayUtil.array2stringarray(a);
    }

    public static String[] buildConstraintDefs(int partCount, String relname, String[] conDefs) {
        ArrayList<String> a = new ArrayList<String>();
        relname = TableUtils.getSchemaName(relname) + "." + TableUtils.getTableName(relname);
        for (int j = 0; j < partCount; ++j) {
            for (int i = 0; i < conDefs.length; ++i) {
                SqlTokenizer t = new SqlTokenizer(conDefs[i]);
                String conDef = "";
                boolean conname = false;
                while (t.hasMoreToken()) {
                    String token = t.nextToken();
                    if (token.equalsIgnoreCase(relname)) {
                        conDef = conDef + PartitionUtils.partName(token, j);
                    } else if (t.ttype != 0 && conname) {
                        conDef = conDef + token + PartitionUtils.partSuffix(j);
                        conname = false;
                    } else {
                        conDef = conDef + token;
                    }
                    if (!token.equalsIgnoreCase("CONSTRAINT")) continue;
                    conname = true;
                }
                a.add(conDef);
                Logger.debug("buildConstraintDefs: " + conDef);
            }
        }
        return ArrayUtil.array2stringarray(a);
    }

    public static String[] rewriteAlter(String relname, int partCount, int[] partNum, String sql) {
        SqlTokenizer t = new SqlTokenizer(sql);
        String token = null;
        boolean isAlter = false;
        while (t.hasMoreToken()) {
            token = t.nextToken();
            if (t.ttype != 2) continue;
            if (!token.equalsIgnoreCase("alter")) break;
            isAlter = true;
            break;
        }
        if (!isAlter) {
            return null;
        }
        boolean isAlterTable = false;
        boolean isAlterIndex = false;
        while (t.hasMoreToken()) {
            token = t.nextToken();
            if (t.ttype != 2) continue;
            if (token.equalsIgnoreCase("table")) {
                isAlterTable = true;
                break;
            }
            if (!token.equalsIgnoreCase("index")) break;
            isAlterIndex = true;
            break;
        }
        if (isAlterTable) {
            return PartitionUtils.rewriteAlterTable(relname, partCount, partNum, sql);
        }
        if (isAlterIndex) {
            return PartitionUtils.rewriteAlterIndex(relname, partCount, partNum, sql);
        }
        return null;
    }

    private static String[] rewriteAlterIndex(String relname, int partCount, int[] partNum, String sql) {
        SqlTokenizer t = new SqlTokenizer(sql + ";");
        String indexName = null;
        String newName = null;
        boolean isRename = false;
        int word = 0;
        String newSql = "";
        Logger.debug("rewriteAlterIndex: " + sql);
        while (t.hasMoreToken()) {
            String token = t.nextToken();
            if (t.ttype == 2) {
                Logger.debug("rewriteAlterIndex: " + ++word + ",token=" + token + ",type=" + t.ttype);
                if (word == 3) {
                    indexName = token;
                    newSql = newSql + indexName + "_??";
                    continue;
                }
                if (word == 4 && token.equalsIgnoreCase("rename")) {
                    isRename = true;
                    newSql = newSql + token;
                    Logger.debug("rewriteAlterIndex: rename command detected.");
                    continue;
                }
                if (word == 6 && isRename) {
                    newName = token;
                    newSql = newSql + newName + "_??";
                    Logger.debug("rewriteAlterIndex: newName=" + newName);
                    continue;
                }
                newSql = newSql + token;
                continue;
            }
            newSql = newSql + token;
        }
        Logger.debug("rewriteAlterIndex: word=" + word);
        Logger.debug("rewriteAlterIndex: " + sql + " -> " + newSql);
        ArrayList<String> a = new ArrayList<String>();
        for (int i = 0; i < partNum.length; ++i) {
            String tmpSql = newSql.replaceAll(indexName + "_\\?\\?", indexName + PartitionUtils.partSuffix(partNum[i]));
            if (isRename) {
                tmpSql = tmpSql.replaceAll(newName + "_\\?\\?", newName + PartitionUtils.partSuffix(partNum[i]));
            }
            a.add(tmpSql);
        }
        return ArrayUtil.array2stringarray(a);
    }

    private static String[] rewriteAlterTable(String relname, int partCount, int[] partNum, String sql) {
        SqlTokenizer t = new SqlTokenizer(sql);
        String newSql = "";
        String relName = null;
        String newName = null;
        String indName = null;
        int word = 0;
        boolean isRename = false;
        boolean isCluster = false;
        boolean withOnly = false;
        while (t.hasMoreToken()) {
            String token = t.nextToken();
            if (t.ttype == 2) {
                if (++word == 3 && token.equalsIgnoreCase("only")) {
                    withOnly = true;
                    --word;
                    continue;
                }
                if (word == 3) {
                    relName = token;
                    newSql = newSql + relName + "_??";
                    continue;
                }
                if (word == 4 && token.equalsIgnoreCase("rename")) {
                    isRename = true;
                    newSql = newSql + token;
                    continue;
                }
                if (word == 4 && token.equalsIgnoreCase("cluster")) {
                    isCluster = true;
                    newSql = newSql + token;
                    continue;
                }
                if (word == 6 && isRename) {
                    newName = token;
                    newSql = newSql + token + "_??";
                    continue;
                }
                if (word == 6 && isCluster) {
                    indName = token;
                    newSql = newSql + token + "_??";
                    continue;
                }
                newSql = newSql + token;
                continue;
            }
            newSql = newSql + token;
        }
        Logger.debug("rewriteAlterTable: " + sql + " -> " + newSql);
        ArrayList<String> a = new ArrayList<String>();
        if (isRename) {
            a.add("-- rename to " + newName + ";");
            a.add("ALTER TABLE " + relname + " RENAME TO " + newName + ";");
        }
        for (int i = 0; i < partNum.length; ++i) {
            String tmpSql = newSql.replaceFirst(relName + "_\\?\\?", relName + PartitionUtils.partSuffix(partNum[i]));
            if (isRename) {
                tmpSql = tmpSql.replaceFirst(newName + "_\\?\\?", newName + PartitionUtils.partSuffix(partNum[i]));
            }
            if (isCluster) {
                tmpSql = tmpSql.replaceFirst(indName + "_\\?\\?", indName + PartitionUtils.partSuffix(partNum[i]));
            }
            Logger.debug("   : " + tmpSql);
            a.add(tmpSql);
        }
        return ArrayUtil.array2stringarray(a);
    }

    private static boolean _checkType(Object o) {
        return o instanceof Integer || o instanceof String || o instanceof Date || o instanceof Time || o instanceof Timestamp;
    }

    private static Hash_I _getHash(String hashName) {
        Hash_I h = null;
        try {
            h = (Hash_I)Class.forName(hashName).newInstance();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return h;
    }

    public static void _append(Hash_I h, Object o) {
        if (o instanceof Integer) {
            h.addCol(((Integer)o).intValue());
        } else {
            h.addCol(o.toString());
        }
    }

    public static Hash_I _init(String hashName, Integer partCount) {
        Hash_I h = PartitionUtils._getHash(hashName);
        if (h == null) {
            return null;
        }
        h.setPartNum(partCount.intValue());
        h.clearCol();
        return h;
    }

    public static Integer _getpartnum(String hashName, Integer partCount, Object col1) {
        Hash_I h = PartitionUtils._init(hashName, partCount);
        if (!PartitionUtils._checkType(col1)) {
            return null;
        }
        PartitionUtils._append(h, col1);
        return new Integer(h.getNodeNo());
    }

    public static Integer _getpartnum(String hashName, Integer partCount, Object col1, Object col2) {
        Hash_I h = PartitionUtils._init(hashName, partCount);
        if (!PartitionUtils._checkType(col1) || !PartitionUtils._checkType(col2)) {
            return null;
        }
        PartitionUtils._append(h, col1);
        PartitionUtils._append(h, col2);
        return new Integer(h.getNodeNo());
    }

    public static Integer getpartnum(String hashName, Integer partCount, Integer col1) {
        return PartitionUtils._getpartnum(hashName, partCount, col1);
    }

    public static Integer getpartnum(String hashName, Integer partCount, String col1) {
        return PartitionUtils._getpartnum(hashName, partCount, col1);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Date col1) {
        return PartitionUtils._getpartnum(hashName, partCount, col1);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Time col1) {
        return PartitionUtils._getpartnum(hashName, partCount, col1);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Timestamp col1) {
        return PartitionUtils._getpartnum(hashName, partCount, col1);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Integer col1, Integer col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Integer col1, String col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Integer col1, Date col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Integer col1, Time col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Integer col1, Timestamp col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, String col1, Integer col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, String col1, String col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, String col1, Date col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, String col1, Time col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, String col1, Timestamp col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Date col1, Integer col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Date col1, String col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Date col1, Date col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Date col1, Time col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Date col1, Timestamp col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Time col1, Integer col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Time col1, String col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Time col1, Date col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Time col1, Time col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Time col1, Timestamp col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Timestamp col1, Integer col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Timestamp col1, String col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Timestamp col1, Date col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Timestamp col1, Time col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }

    public static Integer getpartnum(String hashName, Integer partCount, Timestamp col1, Timestamp col2) {
        return PartitionUtils._getpartnum(hashName, partCount, col1, col2);
    }
}

