#!/bin/sh

. ./common/test_init_gsc.sh | tee result

. ./common/dropdb.sh tpcw
. ./common/dropdb.sh testdb1
. ./common/dropdb.sh testdb2
. ./common/dropdb.sh testdb3
. ./common/dropdb.sh testdb4

./run_tool.sh<<EOF
show instance;
create instance ${HOST_1} ${PORT_1};
show instance;
create instance ${HOST_2} ${PORT_2};
show instance;
create instance ${HOST_3} ${PORT_3};
show instance;

check gsc;

show db;
create db testdb1(0);
show db;
create db testdb2(0,3);
show db;
create db testdb3(1,2);
show db;
create db testdb4(0,2,1,3) with "encoding='utf-8'";
show db;

show gsc;
check gsc;

create gsc 3;

show gsc;
check gsc;

create dbinstance testdb1 1 force;
show db;
check gsc;

create dbinstance testdb2 1;
create dbinstance testdb2 2, force;
show db;
check gsc;

EOF
