package org.postgresforest.tool.cli.action;

import java.util.HashMap;

import org.postgresforest.tool.Logger;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

/**
 * ヘルプを提供するクラス
 */
public class HelpActions {
	
	/** コマンド・キーワードIDと文字列マッピングテーブル */
	protected static final HelpMap helpSet = new HelpMap();	

	static {
		helpSet.put(CommandParser.CREATE_INSTANCE, MessagesCommandLine.getString("cui.help.instance.add")); //$NON-NLS-1$
		helpSet.put(CommandParser.DROP_INSTANCE, MessagesCommandLine.getString("cui.help.instance.drop")); //$NON-NLS-1$
		helpSet.put(CommandParser.SHOW_INSTANCE, MessagesCommandLine.getString("cui.help.instance.show")); //$NON-NLS-1$
		helpSet.put(CommandParser.SET_INSTANCE_UP, MessagesCommandLine.getString("cui.help.instance.set")); //$NON-NLS-1$
		helpSet.put(CommandParser.SET_INSTANCE_DOWN, MessagesCommandLine.getString("cui.help.instance.set")); //$NON-NLS-1$
		helpSet.put(CommandParser.CREATE_GSC, MessagesCommandLine.getString("cui.help.gsc.create")); //$NON-NLS-1$
		helpSet.put(CommandParser.DROP_GSC, MessagesCommandLine.getString("cui.help.gsc.drop")); //$NON-NLS-1$
		helpSet.put(CommandParser.SHOW_GSC, MessagesCommandLine.getString("cui.help.gsc.show")); //$NON-NLS-1$
		helpSet.put(CommandParser.DUMP_GSC, MessagesCommandLine.getString("cui.help.gsc.dump")); //$NON-NLS-1$
		helpSet.put(CommandParser.RESTORE_GSC, MessagesCommandLine.getString("cui.help.gsc.restore")); //$NON-NLS-1$
		helpSet.put(CommandParser.CHECK_GSC, MessagesCommandLine.getString("cui.help.gsc.check")); //$NON-NLS-1$
		helpSet.put(CommandParser.CREATE_DB, MessagesCommandLine.getString("cui.help.db.create")); //$NON-NLS-1$
		helpSet.put(CommandParser.DROP_DB, MessagesCommandLine.getString("cui.help.db.drop")); //$NON-NLS-1$
		helpSet.put(CommandParser.SHOW_DB, MessagesCommandLine.getString("cui.help.db.show")); //$NON-NLS-1$
		helpSet.put(CommandParser.CREATE_DBINSTANCE, MessagesCommandLine.getString("cui.help.db.instance.create")); //$NON-NLS-1$
		helpSet.put(CommandParser.DROP_DBINSTANCE, MessagesCommandLine.getString("cui.help.db.instance.delete")); //$NON-NLS-1$
		helpSet.put(CommandParser.CREATE_CONFIG, MessagesCommandLine.getString("cui.help.config.create")); //$NON-NLS-1$
		helpSet.put(CommandParser.DROP_CONFIG, MessagesCommandLine.getString("cui.help.config.drop")); //$NON-NLS-1$
		helpSet.put(CommandParser.SHOW_CONFIG, MessagesCommandLine.getString("cui.help.config.show")); //$NON-NLS-1$
		helpSet.put(CommandParser.SET_CONFIG, MessagesCommandLine.getString("cui.help.config.set")); //$NON-NLS-1$
		helpSet.put(CommandParser.REPLICATE_CONFIG, MessagesCommandLine.getString("cui.help.config.copy")); //$NON-NLS-1$
		helpSet.put(CommandParser.CREATE_HASH, MessagesCommandLine.getString("cui.help.hash.create")); //$NON-NLS-1$
		helpSet.put(CommandParser.DROP_HASH, MessagesCommandLine.getString("cui.help.hash.drop")); //$NON-NLS-1$
		helpSet.put(CommandParser.SHOW_HASH, MessagesCommandLine.getString("cui.help.hash.show")); //$NON-NLS-1$
		helpSet.put(CommandParser.SHOW_BROKENLOG, MessagesCommandLine.getString("cui.help.brokenlog.show")); //$NON-NLS-1$
		helpSet.put(CommandParser.CLEAR_BROKENLOG, MessagesCommandLine.getString("cui.help.brokenlog.clear")); //$NON-NLS-1$
		helpSet.put(CommandParser.OPEN_DB, MessagesCommandLine.getString("cui.help.db.open")); //$NON-NLS-1$
		helpSet.put(CommandParser.CLOSE_DB, MessagesCommandLine.getString("cui.help.db.close")); //$NON-NLS-1$
		helpSet.put(CommandParser.PART_TABLE, MessagesCommandLine.getString("cui.help.table.part")); //$NON-NLS-1$
		helpSet.put(CommandParser.PART_TABLE2, MessagesCommandLine.getString("cui.help.table2.part")); //$NON-NLS-1$
		helpSet.put(CommandParser.UNPART_TABLE, MessagesCommandLine.getString("cui.help.table.unpart")); //$NON-NLS-1$
		helpSet.put(CommandParser.SHOW_TABLE, MessagesCommandLine.getString("cui.help.table.show")); //$NON-NLS-1$
		helpSet.put(CommandParser.SET_PRIORITY, MessagesCommandLine.getString("cui.help.priority.set")); //$NON-NLS-1$
		helpSet.put(CommandParser.SHOW_PRIORITY, MessagesCommandLine.getString("cui.help.priority.show")); //$NON-NLS-1$
		helpSet.put(CommandParser.SHOW_HELP, MessagesCommandLine.getString("cui.help.command.show")); //$NON-NLS-1$
	}
	
	/**
	 * ヘルプの表示
	 * @param cp コマンド解析結果
	 */	
	public static void show(CommandParser cp) {
		String command = helpSet.getString(cp.getType());
		if (command == null) {
			Logger.println(MessagesCommandLine.getString("cui.help.help.show"));		 //$NON-NLS-1$
			return;
		} else {
			Logger.println(MessagesCommandLine.getString(command));		
		}
	}
	
	/**
	 * コマンドタイプ判別用のマップ
	 */
	static class HelpMap extends HashMap {

		public String getString(int key) {
			String command = (String) get(new Integer(key));

			return command ;
		}

		public String put(int key, String command) {
			String oldcommand = (String) put(new Integer(key), new String(command));

			return oldcommand ;

		}

	}	
	

}
