/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.postgresforest.tool.action.PartitionAction;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.MsgDialogUtil;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.ViewControl;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class ReleasePartitionAction extends ActionBase {


	public static final String ID = "org.postgresforest.tool.view.action.ReleasePartitionAction";
	/* ( Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		MessageBox messageBox = 
			new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), SWT.OK|SWT.CANCEL|SWT.ICON_QUESTION);
		
		messageBox.setText(Messages.getString("title.user.partition"));
		messageBox.setMessage(Messages.getString("message.delpartition"));
		
		if( messageBox.open() != SWT.OK )
			return;

		
		TableInfo tableInfo = (TableInfo) SessionProperty.get("tableInfo");
		GSCdata gsc = (GSCdata)SessionProperty.get("gsc");
		String dbName = (String)SessionProperty.get("selectDb");

		
		PartitionAction exec = new PartitionAction(gsc,dbName);
		try {
			exec.del(tableInfo);
		} catch (Exception e) {
			ErrorLog.log("", e);
		    MsgDialogUtil.err(e.getLocalizedMessage());
		}
		ViewControl.updateUserDataView("",dbName, tableInfo.getName());

	}


}
