/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.action;

import java.util.ArrayList;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewPart;
import org.postgresforest.tool.action.GscAction;
import org.postgresforest.tool.action.ServerAction;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.dialog.addgsc.AddGscDialog;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.serverstatus.ServerStatusView;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AddGscAction extends ActionBase {
    public static final String ID = "org.postgresforest.tool.view.action.AddGscAction";
	private AddGscDialog m_dialog;
	
	public void init(IViewPart view) {
		super.init(view);
		m_dialog = new AddGscDialog();

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {

		GSCdata gsc = (GSCdata)SessionProperty.get("gsc");

		ArrayList serverList = null;

		//T[o擾
		ServerAction serverInfo = new ServerAction(gsc);
		try {
			serverList = serverInfo.getServerList();
		} catch (Exception e) {
			ErrorLog.log("", e);
		}

		
		ServerStatusView view = (ServerStatusView)m_view;
		String selectedId = view.getSelectId();
		//O[oVXeJ^O쐬_CAO\
		m_dialog.setServeList(serverList);
		m_dialog.setServerInfoSelection(selectedId);
		if (m_dialog.open() == Window.OK) {

			//zXgA|[gNo擾
			String dbName = m_dialog.getDbName();
			String id = "";
			ServerInfo info = (ServerInfo)serverList.get(m_dialog.getInstanceIndex());
			id = String.valueOf(info.getId());
			
			//O[oVXeJ^O쐬
			if(dbName != "" && id != ""){
				GscAction addGsc = new GscAction(gsc);
				if(	!addGsc.addGsc(dbName, id) ){
					return;
				}
			}
			
			
			//O[oVXeJ^Or[XV
			m_view.update();
		
		}
	}


}
