/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.partition.priority;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Item;
import org.postgresforest.tool.bean.PriorityInfo;
import org.postgresforest.tool.bean.ServerPriorityInfo;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PartitionPriorityCellModifier implements ICellModifier {
	private TableViewer viewer;
	
	public PartitionPriorityCellModifier(TableViewer viewer) {
		this.viewer = viewer;
	}
	
	public boolean canModify(Object element, String property) {
		ServerPriorityInfo info = (ServerPriorityInfo)element;
		PriorityInfo priorityInfo = info.getPartition(Integer.parseInt(property));
		if(priorityInfo != null ) 
			return true;

		return false;
		
	}
	
	public Object getValue(Object element, String property) {

		if( property != null ){
			ServerPriorityInfo info = (ServerPriorityInfo)element;
			PriorityInfo priorityInfo = info.getPartition(Integer.parseInt(property));
			if(priorityInfo != null ) 
				return priorityInfo.getPriority();
		}
		return null;
		
	}
	
	public void modify(Object element, String property, Object value) {
		if (element instanceof Item) {
			element = ((Item) element).getData();
		}

		ServerPriorityInfo info = (ServerPriorityInfo)element;
		PriorityInfo priorityInfo = info.getPartition(Integer.parseInt(property));
		priorityInfo.setPriority((Integer)value);

		
		// e[uEr[XV
		viewer.update(element, null);
	}

}