/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.partition;



import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.postgresforest.tool.bean.HashInfo;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.util.Messages;


/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class PartitionDialog extends CommonDialog {

	protected Combo m_comboPartNum = null;
	protected Combo m_comboHash = null;
	protected Button m_chkDataShift = null;
	protected Button m_chkPartition2  = null;
	protected boolean m_isDataShift = false;
	protected boolean m_isPartition2 = false;
	protected boolean m_isRePartition = false;
	protected int m_partitionCount = 2;
	protected int m_partitionMax;
	protected String m_tableName;
	protected String m_dbName;
	protected String m_hashName;
	protected ArrayList m_hashList;
	
	
	/**
	 * @return isDataShift ߂܂B
	 */
	public boolean isDataShift() {
		return m_isDataShift;
	}
	/**
	 * @return isPartition2 ߂܂B
	 */
	public boolean isPartition2() {
		return m_isPartition2;
	}
	
	
	/**
	 * @param parent
	 */
	public PartitionDialog() {
		
		
	}

	/* ( Javadoc)
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("title.user.partition"));
	
	}
	
	/* ( Javadoc)
	 * @see org.postgresforest.tool.m_dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {
		

		
		GridLayout layout = new GridLayout(2, true);
		parent.setLayout(layout);
		
		new Label(parent,SWT.NONE).setText(Messages.getString("form.db.name"));

		Label lblDbName = new Label(parent,SWT.NONE);
		lblDbName.setText(m_dbName);

		
		new Label(parent,SWT.NONE).setText(Messages.getString("form.table"));

		new Label(parent,SWT.NONE).setText(m_tableName);
		
		new Label(parent,SWT.NONE).setText(Messages.getString("form.partition.count"));
		m_comboPartNum = new Combo(parent,SWT.READ_ONLY);
		for (int i = 2; i <= m_partitionMax; i++) {
			m_comboPartNum.add(Integer.toString(i));
		}
		m_comboPartNum.setLayoutData(new GridData(30, SWT.DEFAULT));
		m_comboPartNum.select(0);

		new Label(parent,SWT.NONE).setText(Messages.getString("form.partition.hash"));
		m_comboHash = new Combo(parent,SWT.READ_ONLY);
		m_comboHash.add(Messages.getString("form.partition.hash.default"));
		for (Iterator iter = m_hashList.iterator(); iter.hasNext();) {
			HashInfo hashInfo = (HashInfo) iter.next();
			m_comboHash.add(hashInfo.getName());
		}
		if(m_hashName == null){
			m_comboHash.select(0);
		}else{
			m_comboHash.setText(m_hashName);
		}
		
		if( !m_isRePartition ){
		
			m_chkDataShift = new Button(parent,SWT.CHECK);
			m_chkDataShift.setText(Messages.getString("form.data.shift"));
			GridData gridData = new GridData();
			gridData.horizontalSpan = 2;
			m_chkDataShift.setLayoutData(gridData);
		
			m_chkPartition2 = new Button(parent,SWT.CHECK);
			m_chkPartition2.setText(Messages.getString("form.partition.type2"));
		}
		
		
	}

	
	
	/* ( Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed() {
		m_partitionCount = Integer.parseInt(m_comboPartNum.getText());	
		if( m_comboHash.getSelectionIndex() == 0){
		    m_hashName = "";
		}else {
			m_hashName = m_comboHash.getText();
		}
		
		if( !m_isRePartition ){
			m_isDataShift = m_chkDataShift.getSelection(); 
			m_isPartition2 = m_chkPartition2.getSelection(); 
		}
		super.okPressed();
		
	}
	/**
	 * @return partitionCount ߂܂B
	 */
	public int getPartitionCount() {
		return m_partitionCount;
	}
	/**
	 * @param partitionMax partitionMax ݒB
	 */
	public void setPartitionMax(int partitionMax) {
		m_partitionMax = partitionMax;
	}
	/**
	 * @param canPartition2 canPartition2 ݒB
	 */
	public void setRePartition(boolean canPartition2) {
		m_isRePartition = canPartition2;
	}
	/**
	 * @param dbName dbName ݒB
	 */
	public void setDbName(String dbName) {
		m_dbName = dbName;
	}
	/**
	 * @param tableName tableName ݒB
	 */
	public void setTableName(String tableName) {
		m_tableName = tableName;
	}
	public String getHashName() {
		if(m_hashName.equals("")){
			return null;
		}else{
			return m_hashName;
		}
	}
	public void setHashName(String hashName) {
		m_hashName = hashName;
	}
	public void setHashList(ArrayList hashList) {
		m_hashList = hashList;
	}
}
