/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.login;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.postgresforest.tool.action.GscAction;
import org.postgresforest.tool.dialog.LoginDialog;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.MsgDialogUtil;

/**
 * Ǘ҃OC_CAONX
 *  
 */
public class AdminLoginDialog extends LoginDialog {

	protected Button makeButton = null;
	


    /**
     * @param loginList
     */
    public AdminLoginDialog(List loginList) {
        super(loginList);
    }

    protected void customizeDialog(Composite parent) {

		super.customizeDialog(parent);

		m_userLbl.setText(Messages.getString("form.user.admin"));

		makeButton = new Button(parent, SWT.NONE);
		makeButton.setText(Messages.getString("button.make"));

		makeButton.addMouseListener(new MouseAdapter() { 
			public void mouseUp(MouseEvent e) {    
				//OC擾
				setDialogInfo();
				GscAction gscAction = new GscAction(null);
				try {
					if( gscAction.makeGsc(m_loginInfo)) {

					    MsgDialogUtil.info(Messages.getString("message.gsc.add", new Object[] { m_loginInfo.getHostname(), m_loginInfo.getDbname()} ));
					    
					}
				} catch (Exception e1) {
					e1.printStackTrace();
					ErrorLog.log("", e1);
					return ;
				}
			}
		});

	}

	protected String getDialogText() {
		
		return Messages.getString("title.admin.login");
	}


}