package org.postgresforest.tool.commandline.action;


import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.action.DbInstanceAction;
import org.postgresforest.tool.action.ServerAction;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

/**
 * CX^Xւ̃R}hCc[p̃ANV񋟂NX
 */
public class InstanceActions {

	/**
	 * CX^X̍쐬
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */
	public void create(CommandParser cp, GSCdata gsc) {

		//zXgA|[gNo擾
		String host = (String)cp.getHost().get(0);	
		String port = (String)cp.getPort().get(0);	
		
		//CX^Xo^
		if(host != "" && port != ""){ //$NON-NLS-1$ //$NON-NLS-2$
			DbInstanceAction instance = new DbInstanceAction(gsc);
			try {
				if (instance.addInstance(host, port)){
					System.out.println(MessagesCommandLine.getString("cui.message.instance.create", new Object[]{host, port})) ; //$NON-NLS-1$
					return;
				}
			} catch (Exception e1) {
				System.err.println(e1);
			}
		}
		System.out.println(MessagesCommandLine.getString("cui.error.instance.create", new Object[] { host, port}) ); //$NON-NLS-1$

	}
	
	/**
	 * CX^X̍폜
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 */	
	public void drop(CommandParser cp, GSCdata gsc) {
		String id = (String)cp.getServer().get(0);
		//CX^X폜
		if(id != ""){ //$NON-NLS-1$
			//ZbVvpeBO[oVXeJ^O擾
			DbInstanceAction instance = new DbInstanceAction(gsc);
			try {
				if (instance.delInstance(id)){
					System.out.println(MessagesCommandLine.getString("cui.message.instance.drop", new Object[] {id})) ; //$NON-NLS-1$
					return;
				}
			} catch (Exception e1) {
				System.err.println(e1);
			}
		}	
		System.out.println(MessagesCommandLine.getString("cui.error.instance.drop", new Object[] {id})) ; //$NON-NLS-1$
	}
	
	/**
	 * CX^X̕\
	 * @param gsc GSCw̐ڑ
	 */		
	public void show(GSCdata gsc) {
		ArrayList serverList = null;

		//T[o擾
		ServerAction serverInfo = new ServerAction(gsc);
		try {
			serverList = serverInfo.getServerList();
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.instance.show")) ; //$NON-NLS-1$
			System.err.println(e);
			return;
		}
		
		//DB\		
		System.out.println(MessagesCommandLine.getString("cui.message.instance.show")) ; //$NON-NLS-1$
		Iterator it = serverList.iterator();
		System.out.println(" SERVERID\t| HOST\t| PORT\t| STATUS"); //$NON-NLS-1$
		System.out.println("----------------------------------------------"); //$NON-NLS-1$
		while (it.hasNext()) {
			ServerInfo srvInfo = (ServerInfo)it.next();
			System.out.print(srvInfo.getId() + "\t| "); //$NON-NLS-1$
			System.out.print(srvInfo.getHost() + "\t| "); //$NON-NLS-1$
			System.out.print(srvInfo.getPort() + "\t| "); //$NON-NLS-1$
			System.out.println(convertStatus(srvInfo.getStatus()));
		}	
	}

	/**
	 * CX^X̏Ԑݒ
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 * @param status CX^X̐ݒ
	 * 	 */	
	public void set(CommandParser cp, GSCdata gsc, int status) {	
		ArrayList statusList = null;
		int id = Integer.parseInt((String)cp.getServer().get(0));

		//T[o擾
		ServerAction serverInfo = new ServerAction(gsc);
		try {
			statusList = serverInfo.getServerList();
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.instance.set", new Object[]{Integer.toString(id)})); //$NON-NLS-1$
			System.err.println(e);
			return;
		}		

		//T[oԊi[
		Iterator it = statusList.iterator(); 
		while(it.hasNext()) {
			ServerInfo srvInfo = (ServerInfo) it.next();
			if (id == srvInfo.getId()){
				srvInfo.setChangeStatus(status);
			}
		}
			
		//T[oԐݒ
		ServerAction serverAction = new ServerAction(gsc);
		if(!serverAction.setStatus(statusList)){
			System.out.println(MessagesCommandLine.getString("cui.error.instance.set.up", new Object[]{Integer.toString(id)})); //$NON-NLS-1$
			return;
		}
		if (status == GSCdata.SERVER_RUNNING){
			System.out.println(MessagesCommandLine.getString("cui.message.instance.set.up", new Object[]{Integer.toString(id)})); //$NON-NLS-1$
		} else if (status == GSCdata.SERVER_TROUBLE) {
			System.out.println(MessagesCommandLine.getString("cui.message.instance.set.down", new Object[]{Integer.toString(id)}));			 //$NON-NLS-1$
		}
	}
	
	private String convertStatus(int status) {
		String ret = "";
		if (status == 1) {
			ret = MessagesCommandLine.getString("form.running");
		} else if (status == -1) {
			ret = MessagesCommandLine.getString("form.stopping");			
		}
		return ret;
	}
}
