/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;

import org.postgresforest.tool.bean.BrokenLogInfo;
import org.postgresforest.tool.db.GSCdata;

/**
 * CX^Xo^NX
 * 
 * CX^Xo^sB
 */
public class BrokenLogAction extends ActionBase{

	/**
	 * @param gsc
	 */
	public BrokenLogAction(GSCdata gsc) {
		super(gsc);
	}
	
	/**
	 * T[oXe[^X擾
	 * 
	 */
	public ArrayList getList() throws Exception{


		//f[^쐬
		ArrayList brokenLogList = null;
		try {
			//ڑ
			if (!connectSelect(m_gsc)) {
				throw new Exception();
			}
			
			//BrokenLog쐬
			brokenLogList = m_gsc.getBrokenLogList();

		} catch (SQLException e) {
			setAccessErrs(m_gsc);
			throw e;

		} finally {
			m_gsc.close();
		}

		return brokenLogList;
	}
	
	/**
	 * 
	 */
	public BrokenLogInfo get(String id) throws Exception {


		//f[^쐬
		try {
			//ڑ
			if (!connectSelect(m_gsc)) {
				throw new Exception();
			}
			
			//BrokenLog쐬
			return m_gsc.getBrokenLogInfo(id);

		} catch (SQLException e) {
			setAccessErrs(m_gsc);
			throw e;

		} finally {
			m_gsc.close();
		}

		
	}
	

	/**
	 * BrokenLogR[h폜
	 * 
	 */
	public boolean del(ArrayList list)  {
		int i = 0;
		
		if(list.isEmpty()){
			return false;
		}
		for (i=0; i<list.size(); i++){
		try {
			if (!connect(m_gsc)) {
				return false;
			}

			//f[^XV
			BrokenLogInfo tmpBrokenLogInfo = (BrokenLogInfo)list.get(i);
			if (m_gsc.delBrokenLog(tmpBrokenLogInfo.getServerid(), tmpBrokenLogInfo.getDatetime())) {
				m_gsc.commit();
			} else {
				m_gsc.rollback();
			}

		} finally {
			m_gsc.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				return false;
			}
		}
		}
		return true;
	}
	
	//TODOMASU ȂHBrokenLogfBt@C邱Ƃ͂Ȃ
	/**
	 * nbV֐폜
	 * 
	 */
//	public boolean mod(BrokenLogInfo brokenLogInfo) {
////		
////		try {
////			if (!connect(m_gsc)) {
////				return false;
////			}
////
////			//f[^XV
////			
////			//MASUCOMMENT ServerIDƃ^CX^vō폜̂悢H
////			if (m_gsc.delBrokenLog(brokenLogInfo.getServerid())&& m_gsc.addBrokenLog(brokenLogInfo)) {
////				m_gsc.commit();
////			} else {
////				m_gsc.rollback();
////			}
////
////		} finally {
////			m_gsc.close();
////			if( m_gsc.isErrInfo() ){
////				setAccessErrs(m_gsc);
////				return false;
////			}
////		}
//		return true;
//	}

	
}
