/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.fastpath;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresforest.Driver;
import org.postgresforest.core.BaseConnection;
import org.postgresforest.core.ParameterList;
import org.postgresforest.core.QueryExecutor;
import org.postgresforest.fastpath.FastpathArg;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

public class Fastpath {
    private final Hashtable func = new Hashtable();
    private final QueryExecutor executor;
    private final BaseConnection connection;

    public Fastpath(BaseConnection conn) {
        this.connection = conn;
        this.executor = conn.getQueryExecutor();
    }

    public Object fastpath(int fnId, boolean resultType, FastpathArg[] args) throws SQLException {
        ParameterList params = this.executor.createFastpathParameters(args.length);
        for (int i = 0; i < args.length; ++i) {
            args[i].populateParameter(params, i + 1);
        }
        byte[] returnValue = this.executor.fastpathCall(fnId, params, this.connection.getAutoCommit());
        if (!resultType || returnValue == null) {
            return returnValue;
        }
        if (returnValue.length != 4) {
            throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned and we expected an integer.", new Integer(fnId)), PSQLState.NO_DATA);
        }
        return new Integer(returnValue[3] & 0xFF | (returnValue[2] & 0xFF) << 8 | (returnValue[1] & 0xFF) << 16 | (returnValue[0] & 0xFF) << 24);
    }

    public Object fastpath(String name, boolean resulttype, FastpathArg[] args) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("Fastpath: calling " + name);
        }
        return this.fastpath(this.getID(name), resulttype, args);
    }

    public int getInteger(String name, FastpathArg[] args) throws SQLException {
        Integer i = (Integer)this.fastpath(name, true, args);
        if (i == null) {
            throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned and we expected an integer.", name), PSQLState.NO_DATA);
        }
        return i;
    }

    public byte[] getData(String name, FastpathArg[] args) throws SQLException {
        return (byte[])this.fastpath(name, false, args);
    }

    public void addFunction(String name, int fnid) {
        this.func.put(name, new Integer(fnid));
    }

    public void addFunctions(ResultSet rs) throws SQLException {
        while (rs.next()) {
            this.func.put(rs.getString(1), new Integer(rs.getInt(2)));
        }
    }

    public int getID(String name) throws SQLException {
        Integer id = (Integer)this.func.get(name);
        if (id == null) {
            throw new PSQLException(GT.tr("The fastpath function {0} is unknown.", name), PSQLState.UNEXPECTED_ERROR);
        }
        return id;
    }
}

