/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.core.types;

import java.math.BigDecimal;
import org.postgresforest.core.types.PGBigDecimal;
import org.postgresforest.core.types.PGDouble;
import org.postgresforest.core.types.PGFloat;
import org.postgresforest.core.types.PGInteger;
import org.postgresforest.core.types.PGLong;
import org.postgresforest.core.types.PGShort;
import org.postgresforest.core.types.PGString;
import org.postgresforest.core.types.PGType;
import org.postgresforest.core.types.PGUnknown;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

public class PGBoolean
implements PGType {
    private Boolean val;

    public PGBoolean(Boolean x) {
        this.val = x;
    }

    public static PGType castToServerType(Boolean val, int targetType) throws PSQLException {
        try {
            switch (targetType) {
                case -5: {
                    return new PGLong(new Long(val == true ? 1L : 0L));
                }
                case 4: {
                    return new PGInteger(new Integer(val == true ? 1 : 0));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(val == true ? (short)1 : 0));
                }
                case -1: 
                case 12: {
                    return new PGString(val == true ? "true" : "false");
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(val == true ? 1.0 : 0.0));
                }
                case 7: {
                    return new PGFloat(new Float(val == true ? 1.0f : 0.0f));
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(val == true ? 1.0 : 0.0));
                }
                case -7: {
                    return new PGBoolean(val);
                }
            }
            return new PGUnknown(val);
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{val.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)ex);
        }
    }

    public String toString() {
        return this.val == true ? "true" : "false";
    }
}

