/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.Database;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.Table;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Misc;
import org.postgresforest.tool.util.Table2StringUtil;

public class TableActions {
    private static final String[] SHOW_TABLE_HEADER = new String[]{"TABLENAME", "TABLETYPE", "PARTITION_FUNC", "STATUS"};
    private static final String[] SHOW_COLUMN_HEADER = new String[]{"PARTITION_KEY", "COLUMNNAME", "DATATYPE"};
    private static final int REST_MODE = 1;
    private static final int NOREST_MODE = 0;
    private static final String DEFAULT_HASH = "default";
    private static final String HASH_OPTION_NAME = "hashname";
    protected static DecimalFormat m_dcFmt = new DecimalFormat("00");

    public static void part(CommandParser cp, Database database) {
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)"invalid argument");
            return;
        }
        String hashName = null;
        ArrayList paramNames = cp.getParamName();
        ArrayList paramValues = cp.getParamValue();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            if (paramName.equalsIgnoreCase(HASH_OPTION_NAME)) {
                hashName = (String)paramValues.get(i);
                if (!hashName.equals(DEFAULT_HASH)) continue;
                hashName = null;
                continue;
            }
            Logger.error((String)MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
            return;
        }
        int partCount = cp.getPartCnt();
        int serverSize = database.getInstanceIds().length;
        if (partCount < 2 || partCount > serverSize) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.part.partno.invalid", new Object[]{new Integer(serverSize)}));
            return;
        }
        ArrayList partColumns = cp.getKeyCol();
        String[] partColumnsName = partColumns.toArray(new String[0]);
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        try {
            if (table.part(partColumnsName, partCount, hashName)) {
                Logger.println((String)MessagesCommandLine.getString("cui.message.table.part", new Object[]{tableName}));
                return;
            }
        }
        catch (Exception e) {
            Logger.error((String)"part() failed.");
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        Logger.error((String)MessagesCommandLine.getString("cui.error.table.part", new Object[]{tableName}));
    }

    public static void part2(CommandParser cp, Database database) {
        ArrayList setServerList = cp.getServer();
        int[] serverIds = database.getInstanceIds();
        Iterator iter = setServerList.iterator();
        while (iter.hasNext()) {
            String severID = (String)iter.next();
            int setid = Integer.parseInt(severID);
            if (Misc.contains(setid, serverIds)) continue;
            return;
        }
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            return;
        }
        String hashName = null;
        ArrayList paramNames = cp.getParamName();
        ArrayList paramValues = cp.getParamValue();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            if (paramName.equalsIgnoreCase(HASH_OPTION_NAME)) {
                hashName = (String)paramValues.get(i);
                if (!hashName.equals(DEFAULT_HASH)) continue;
                hashName = null;
                continue;
            }
            Logger.error((String)MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
            return;
        }
        int partCount = cp.getPartCnt();
        int serverSize = database.getInstanceIds().length;
        if (partCount < 2 || partCount > serverSize) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.part.partno.invalid", new Object[]{new Integer(serverSize)}));
            return;
        }
        ArrayList partColumns = cp.getKeyCol();
        String[] partColumnsName = partColumns.toArray(new String[0]);
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        try {
            if (!table.part(partColumnsName, partCount, hashName)) {
                Logger.error((String)MessagesCommandLine.getString("cui.error.table.part", new Object[]{tableName}));
                return;
            }
        }
        catch (Exception e) {
            Logger.error((String)"part() failed.");
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        HashMap part2NoListMap = cp.getPart2NoListMap();
        for (int i = 0; i < serverIds.length; ++i) {
            int k;
            int serverId = serverIds[i];
            ArrayList partNoList = (ArrayList)part2NoListMap.get(String.valueOf(serverId));
            if (partNoList == null) {
                for (k = 0; k < partCount; ++k) {
                    if (table.dropPart(k, serverId)) continue;
                    Logger.error((String)MessagesCommandLine.getString("cui.error.table.part2", new Object[]{tableName}));
                    return;
                }
                continue;
            }
            for (k = 0; k < partCount; ++k) {
                if (partNoList.contains(String.valueOf(k)) || table.dropPart(k, serverId)) continue;
                Logger.error((String)MessagesCommandLine.getString("cui.error.table.part2", new Object[]{tableName}));
                return;
            }
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.table.part2", new Object[]{tableName}));
    }

    public static void unpart(CommandParser cp, Database database) {
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)"invalid argument");
            return;
        }
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        try {
            if (!table.unpart()) {
                Logger.error((String)MessagesCommandLine.getString("cui.error.table.unpart", new Object[]{tableName}));
                return;
            }
        }
        catch (Exception e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.table.unpart", new Object[]{tableName}));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.table.unpart", new Object[]{tableName}));
    }

    public static void showTable(Database database) {
        String[] tables;
        try {
            tables = database.getTableNames();
        }
        catch (ForestToolException e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.table.show"));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)((Object)e));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.table.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_TABLE_HEADER);
        for (int i = 0; i < tables.length; ++i) {
            String tableName = tables[i];
            Table table = database.getTable(tableName);
            if (table == null) {
                Logger.error((String)MessagesCommandLine.getString("cui.error.table.show"));
                return;
            }
            ArrayList<String> row = new ArrayList<String>();
            row.add(tableName);
            int type = table.getTableType();
            row.add(TableActions.convertTableType(type));
            String hashname = table.getHashName();
            if (hashname != null) {
                row.add(hashname);
            } else if (type == 1 || type == 2) {
                row.add("DEFAULT");
            } else {
                row.add("");
            }
            row.add(TableActions.convertTableStatus(table.getStatus()));
            table2StringUtil.addRow(row);
        }
        table2StringUtil.print();
    }

    public static void showTableColumn(CommandParser cp, Database database) {
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)"invalid argument");
            return;
        }
        TableActions.showTableColumn(tableName, database);
    }

    public static void showTableColumn(String tableName, Database database) {
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        String[] columnNames = null;
        ArrayList<String> partitonKeyList = null;
        try {
            columnNames = table.getColumnNames();
            partitonKeyList = new ArrayList<String>(Arrays.asList(table.getPartitionKeys()));
        }
        catch (Exception e) {
            Logger.error((String)"getColumnNames() failed.");
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.tablecolumn.show", new Object[]{tableName}));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_COLUMN_HEADER);
        try {
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                ArrayList<String> row = new ArrayList<String>();
                row.add(TableActions.convertPartKey(columnName, partitonKeyList));
                row.add(columnName);
                row.add(table.getColumnType(columnName));
                table2StringUtil.addRow(row);
            }
            table2StringUtil.print();
        }
        catch (ForestToolException e) {
            table2StringUtil.print();
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)((Object)e));
        }
    }

    public static void setPriority(CommandParser cp, Database database) {
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)"Invalid argument.");
            return;
        }
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        int partNo = cp.getPartNo();
        ArrayList serverList = cp.getServer();
        for (int pri = 0; pri < serverList.size(); ++pri) {
            int serverid = Integer.parseInt((String)serverList.get(pri));
            if (!table.setPriority(serverid, partNo, pri)) {
                Logger.error((String)MessagesCommandLine.getString("cui.error.priority.set", new Object[]{tableName}));
                return;
            }
            Logger.debug((String)("setPriority: serverid=" + serverid + ",partition=" + partNo + ",priority=" + pri));
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.priority.set", new Object[]{tableName}));
    }

    public static void showPriority(CommandParser cp, Database database) {
        String tableName = cp.getTables();
        if (tableName == null || tableName.equals("")) {
            Logger.error((String)"invalid argument");
            return;
        }
        TableActions.showPriority(tableName, database);
    }

    public static void showPriority(String tableName, Database database) {
        Table table = database.getTable(tableName);
        if (table == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}));
            return;
        }
        int partCount = table.getPartCount();
        if (partCount == 1) {
            Logger.println((String)("Table `" + tableName + "' is not a partitioned table."));
            return;
        }
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add(0, "SERVERID");
        for (int i = 0; i < table.getPartCount(); ++i) {
            columnList.add(tableName + "_" + m_dcFmt.format(i));
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.priority.show", new Object[]{tableName}));
        Table2StringUtil table2StringUtil = new Table2StringUtil(columnList);
        try {
            int[] ids = table.getInstanceIds();
            for (int j = 0; j < ids.length; ++j) {
                ArrayList<Object> row = new ArrayList<Object>();
                int serverId = ids[j];
                row.add(new Integer(serverId));
                for (int i = 1; i < columnList.size(); ++i) {
                    int priority = table.getPriority(serverId, i - 1);
                    if (priority < 0) {
                        row.add("");
                        continue;
                    }
                    row.add(new Integer(priority));
                }
                table2StringUtil.addRow(row);
            }
            table2StringUtil.print();
        }
        catch (Exception e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.priority.show", new Object[]{tableName}));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)e);
        }
    }

    private static String convertTableType(int type) {
        String ret = "";
        ret = type == 0 ? MessagesCommandLine.getString("form.partition.type0") : (type == 1 ? MessagesCommandLine.getString("form.partition.type1") : (type == 2 ? MessagesCommandLine.getString("form.partition.type2") : "UNKNOWN VALUE"));
        return ret;
    }

    private static String convertPartKey(String column, ArrayList partitionKeyList) {
        String ret = " ";
        ret = partitionKeyList.contains(column) ? " * " : "";
        return ret;
    }

    private static String convertTableStatus(int status) {
        String ret = "";
        ret = status == 1 ? MessagesCommandLine.getString("form.admintree.status.ng") : (status == 0 ? MessagesCommandLine.getString("form.admintree.status.ok") : "UNKNOWN VALUE");
        return ret;
    }
}

