/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.util.ArrayList;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Table2StringUtil;

public class InstanceActions {
    private static final String[] SHOW_INSTANCE_HEADER = new String[]{"SERVERID", "HOST", "PORT", "STATUS"};
    public static final int SERVER_RUNNING = 1;
    public static final int SERVER_TROUBLE = -1;

    public static void create(CommandParser cp, GSCdata gsc) {
        String host = cp.getHost();
        if (host == null || host.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        String port = cp.getPort();
        if (port == null || port.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        Instance instance = gsc.registerInstance(host, port);
        if (instance == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.instance.create", new Object[]{host, port}));
            return;
        }
        if (!instance.setStatus(1)) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.instance.set.up", new Object[]{Integer.toString(instance.getId())}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.instance.create", new Object[]{host, port}));
    }

    public static void drop(CommandParser cp, GSCdata gsc) {
        String id = (String)cp.getServer().get(0);
        if (id != "" && gsc.unregisterInstance(Integer.parseInt(id))) {
            Logger.println((String)MessagesCommandLine.getString("cui.message.instance.drop", new Object[]{id}));
            return;
        }
        Logger.error((String)MessagesCommandLine.getString("cui.error.instance.drop", new Object[]{id}));
    }

    public static void show(GSCdata gsc) {
        int[] ids;
        try {
            ids = gsc.getInstanceIds();
        }
        catch (ForestToolException e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.instance.show"));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)((Object)e));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.message.instance.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_INSTANCE_HEADER);
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                int id = ids[i];
                Instance instance = gsc.getInstance(id);
                if (instance == null) {
                    Logger.error((String)MessagesCommandLine.getString("cui.error.instance.show"));
                    return;
                }
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(new Integer(instance.getId()));
                row.add(instance.getHostName());
                row.add(instance.getPortNumber());
                row.add(InstanceActions.convertStatus(instance.getStatus()));
                table2StringUtil.addRow(row);
            }
        }
        table2StringUtil.print();
    }

    public static void set(CommandParser cp, GSCdata gsc, int status) {
        int id = Integer.parseInt((String)cp.getServer().get(0));
        Instance instance = gsc.getInstance(id);
        if (instance == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.instance.set", new Object[]{Integer.toString(id)}));
            return;
        }
        if (!instance.setStatus(status)) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.instance.set.up", new Object[]{Integer.toString(id)}));
            return;
        }
        if (status == 1) {
            Logger.println((String)MessagesCommandLine.getString("cui.message.instance.set.up", new Object[]{Integer.toString(id)}));
        } else if (status == -1) {
            Logger.println((String)MessagesCommandLine.getString("cui.message.instance.set.down", new Object[]{Integer.toString(id)}));
        }
    }

    private static String convertStatus(int status) {
        String ret = "";
        ret = status == 1 ? MessagesCommandLine.getString("form.running") : (status == -1 ? MessagesCommandLine.getString("form.stopping") : "unknown status");
        return ret;
    }
}

