/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.recovery;

import org.postgresforest.tool.Logger;
import org.postgresforest.tool.recovery.RecoveryException;
import org.postgresforest.tool.recovery.RecoveryManager;

public class ForestRecovery {
    private static RecoveryManager rm = null;
    private static String gscURL = null;
    private static String remoteTemp = "/tmp";
    private static String localTemp = "/tmp";
    private static String userName = "postgres";
    private static String userPass = "postgres";
    private static int refreshInterval = 0;
    private static int retryMax = 3;
    private static String sourceURL = null;
    private static String destURL = null;
    private static int timeout = 60;
    private static int server_id_src = -1;
    private static int server_id_dest = -1;
    private static final int MODE_ALL = 0;
    private static final int MODE_PHASE1 = 1;
    private static final int MODE_PHASE2 = 2;
    private static final int MODE_START_VM = 3;
    private static final int MODE_STOP_VM = 4;
    private static final int MODE_CLEANUP = 5;
    private static String dbname = null;
    private static int RECOVERY_MODE = 0;
    private static String[] tableNames = null;
    private static int nLogRecordAll = 0;

    private static void printServerStatus() {
        try {
            Logger.debug("===== SERVER STATUS =====");
            Logger.debug("  serverId=" + server_id_src + ", status=" + rm.getServerStatus(server_id_src));
            Logger.debug("  serverId=" + server_id_dest + ", status=" + rm.getServerStatus(server_id_dest));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: ForestRecovery [<options>...] [source server_id] [dest server_id] [dbname]");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("        -user [str]         Administrator's user name");
        System.out.println("        -pass [str]         Administrator's password.");
        System.out.println("        -tmpdir [str]       Temporary directory used to dump and restore table(s).");
        System.out.println("        -remotetmpdir [str] Temporary directory for the master node.");
        System.out.println("        -localtmpdir [str]  Temporary directory for the recovering node.");
        System.out.println("                            This directory must be writable by backends.");
        System.out.println("        -gsc_url [str]      GSC URL");
        System.out.println("        -retry_max [num]    Max count for retrying.");
        System.out.println("        -timeout [num]      Socket timeout time in sec. (default:" + timeout + ")");
        System.out.println("");
        System.out.println("        -phase1             Run recovery phase 1.");
        System.out.println("        -phase2             Run recovery phase 2.");
        System.out.println("        -start_vm           Start PostgresForest VM.");
        System.out.println("        -stop_vm            Stop PostgresForest VM.");
        System.out.println("        -cleanup            Run to cleanup recovering.");
        System.out.println("");
        System.out.println("        -debug              Enable debug log output.");
        System.out.println("        -help               Print this help.");
        System.out.println("");
    }

    private static void parseOptions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-gsc_url")) {
                gscURL = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-tmpdir")) {
                localTemp = remoteTemp = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-remptetmpdir")) {
                remoteTemp = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-localtmpdir")) {
                localTemp = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-user")) {
                userName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-pass")) {
                userPass = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-retry_max")) {
                retryMax = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-help")) {
                ForestRecovery.printUsage();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-timeout")) {
                timeout = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                Logger.setLogLevel(5);
                continue;
            }
            if (stringArray[i].equals("-phase1")) {
                RECOVERY_MODE = 1;
                continue;
            }
            if (stringArray[i].equals("-phase2")) {
                RECOVERY_MODE = 2;
                continue;
            }
            if (stringArray[i].equals("-start_vm")) {
                RECOVERY_MODE = 3;
                continue;
            }
            if (stringArray[i].equals("-stop_vm")) {
                RECOVERY_MODE = 4;
                continue;
            }
            if (stringArray[i].equals("-cleanup")) {
                RECOVERY_MODE = 5;
                continue;
            }
            if (server_id_src < 0) {
                server_id_src = Integer.parseInt(stringArray[i]);
                continue;
            }
            if (server_id_dest < 0) {
                server_id_dest = Integer.parseInt(stringArray[i]);
                continue;
            }
            if (dbname == null) {
                dbname = stringArray[i];
                continue;
            }
            System.err.println("Too many arguments.\n");
            ForestRecovery.printUsage();
            System.exit(-1);
        }
        if (server_id_src < 0 || server_id_dest < 0) {
            System.err.println("Too few arguments.\n");
            ForestRecovery.printUsage();
            System.exit(-1);
        }
    }

    private static int applyAllRecords() throws RecoveryException {
        String string;
        int n = 0;
        while ((string = rm.readLogRecord()) != null) {
            rm.applyLogRecord(string);
            if (++n % 50 != 0) continue;
            Logger.debug("   " + n + " log records applied.");
        }
        return n;
    }

    private static boolean preventUpdatingServer(int n) throws RecoveryException {
        int n2;
        boolean bl = false;
        Logger.debug("Set the table status to 1.");
        rm.setTableStatus(n, 1);
        try {
            n2 = 0;
            n2 = refreshInterval <= 10 ? 15 : refreshInterval + 10;
            Logger.notice("  WAITING " + n2 + " SECONDS...");
            Logger.debug("Sleeping " + n2 + " secs...");
            Thread.sleep(n2 * 1000);
        }
        catch (Exception exception) {
            throw new RecoveryException("Thread.sleep() interrupted.");
        }
        n2 = rm.getActiveTransactions();
        if (n2 == 1) {
            bl = true;
        }
        Logger.debug("active backends = " + n2);
        if (bl) {
            Logger.notice("  READY TO GO RECOVERY PHASE 2");
        }
        return bl;
    }

    private static void abortRecovery() {
        String[] stringArray = null;
        Logger.notice("Aborting recovery...");
        try {
            stringArray = rm.getPhysicalTableNames(dbname);
            for (int i = 0; i < stringArray.length; ++i) {
                rm.stopRecoveryLogging(stringArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        Logger.notice("Recovery has been aborted.");
        System.exit(-1);
    }

    public static void initRecovery() {
        Logger.notice("RECOVERY / INITIALIZATION");
        try {
            tableNames = rm.getPhysicalTableNames(dbname);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        Logger.notice("TABLE(S) TO COPY:");
        for (int i = 0; i < tableNames.length; ++i) {
            Logger.notice("  " + tableNames[i]);
        }
        if (tableNames == null) {
            System.err.println("No table found to be recovered.");
            System.exit(0);
        }
    }

    public static boolean checkGscEntries() throws RecoveryException {
        Logger.notice("GSC CHECK:");
        boolean bl = true;
        int n = rm.checkGscServdbEntry(dbname, server_id_src);
        int n2 = rm.checkGscServdbEntry(dbname, server_id_dest);
        if (n2 >= 0) {
            Logger.notice("  forest_servdb, " + dbname + ": OK");
        } else {
            Logger.notice("  forest_servdb, " + dbname + ": NG");
            bl = false;
            Logger.notice("  CREATING:");
            n2 = rm.createGscServdbEntry(dbname, server_id_dest);
            if (rm.checkGscServdbEntry(dbname, server_id_dest) >= 0) {
                Logger.notice("  forest_servdb, " + dbname + ": OK");
                bl = true;
            } else {
                Logger.notice("  forest_servdb, " + dbname + ": NG");
            }
        }
        String[] stringArray = rm.getLogicalTableNames(dbname);
        for (int i = 0; i < stringArray.length; ++i) {
            if (rm.checkGscTablepartdtlEntry(n2, dbname, stringArray[i])) {
                Logger.notice("  forest_tablepartdtl, " + stringArray[i] + ": OK");
                continue;
            }
            Logger.notice("  forest_tablepartdtl, " + stringArray[i] + ": NG");
            bl = false;
            Logger.notice("  CREATING:");
            rm.createGscTablepartdtlEntry(n, n2, dbname, stringArray[i]);
            if (rm.checkGscTablepartdtlEntry(n2, dbname, stringArray[i])) {
                Logger.notice("  forest_tablepartdtl, " + stringArray[i] + ": OK");
                bl = true;
                continue;
            }
            Logger.notice("  forest_tablepartdtl, " + stringArray[i] + ": NG");
        }
        return bl;
    }

    public static void RecoveryPhase1() {
        int n;
        int n2;
        int n3;
        Logger.notice("RECOVERY / PHASE 1: start.");
        try {
            if (!ForestRecovery.checkGscEntries()) {
                Logger.error("GSC entries invalid.");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        for (n3 = 0; n3 < tableNames.length; ++n3) {
            try {
                rm.prepareRecoveryLogging(tableNames[n3]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-1);
            }
        }
        for (n3 = 0; n3 < tableNames.length; ++n3) {
            try {
                rm.beginRecoveryLogging(tableNames[n3]);
                Logger.debug("  Logger started, table => " + tableNames[n3]);
                continue;
            }
            catch (Exception exception) {
                Logger.error(exception.getMessage());
                System.exit(-1);
            }
        }
        String[] stringArray = new String[tableNames.length];
        String[] stringArray2 = new String[tableNames.length];
        Logger.notice("COPYING ALL TABLES: start.");
        for (n2 = 0; n2 < tableNames.length; ++n2) {
            stringArray[n2] = tableNames[n2] + ".db";
            stringArray2[n2] = remoteTemp + "/" + stringArray[n2];
        }
        try {
            Logger.notice("  CREATE SNAPSHOT: start.");
            n2 = rm.createSnapshotCopy(tableNames, stringArray2);
            Logger.debug("   Snapshot xid=" + n2);
            Logger.notice("  CREATE SNAPSHOT: done.");
            Logger.notice("  REBUILD FROM SNAPSHOT: start.");
            rm.disableFKs(tableNames);
            rm.truncateTables(tableNames);
            for (n = 0; n < tableNames.length; ++n) {
                rm.copyFileToLocal(remoteTemp + "/" + stringArray[n], localTemp + "/" + stringArray[n]);
                rm.rebuildTableFromFile(tableNames[n], localTemp + "/" + stringArray[n]);
            }
            rm.enableFKs(tableNames);
            Logger.notice("  REBUILD FROM SNAPSHOT: done.");
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
            System.exit(-1);
        }
        Logger.notice("COPYING ALL TABLES: done.");
        Logger.notice("APPLYING LOG RECORD(S): start.");
        try {
            rm.openLogRecords(1, Integer.MAX_VALUE);
            int n4 = rm.getLogMaxXid();
            n = rm.getLogMinXid();
            Logger.debug("# of log records = " + rm.getNumberOfLogRecords());
            rm.beginApplyingLogRecords();
            nLogRecordAll = 0;
            boolean bl = false;
            int n5 = ForestRecovery.applyAllRecords();
            nLogRecordAll += n5;
            rm.removeLogRecords();
            rm.commitApplyingLogRecords();
            rm.closeLogRecords();
            rm.vacuumLogRecords();
            Logger.debug("Num of applied log records: " + n5);
            Logger.debug("Total num of applied log records: " + nLogRecordAll);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        Logger.notice("APPLYING LOG RECORD(S): done.");
        Logger.notice("RECOVERY / PHASE 1: done.");
    }

    public static void RecoveryPhase2() {
        Logger.notice("RECOVERY / PHASE 2: start.");
        try {
            if (rm.getTableStatus(server_id_src) == 0) {
                Logger.error("TABLE IS NOT CLOSED.");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
            System.exit(-1);
        }
        try {
            Logger.debug("Entering 2nd pass for recoverying...");
            rm.openLogRecords(1, Integer.MAX_VALUE);
            int n = rm.getLogMaxXid();
            int n2 = rm.getLogMinXid();
            rm.beginApplyingLogRecords();
            int n3 = ForestRecovery.applyAllRecords();
            nLogRecordAll += n3;
            rm.removeLogRecords();
            rm.commitApplyingLogRecords();
            rm.closeLogRecords();
            rm.vacuumLogRecords();
            Logger.debug("avoiding from recovery loop.");
            rm.openLogRecords(1, Integer.MAX_VALUE);
            n = rm.getLogMaxXid();
            n2 = rm.getLogMinXid();
            if (rm.getNumberOfLogRecords() > 0) {
                Logger.error("Log record(s) left. Recovery failed.");
                ForestRecovery.abortRecovery();
            }
            rm.closeLogRecords();
            rm.vacuumLogRecords();
            Logger.debug("Total num of applied log records: " + nLogRecordAll);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        Logger.notice("RECOVERY / PHASE 2: done");
    }

    public static void StartVM() {
        Logger.notice("RECOVERY / STARTING VM: start.");
        try {
            Logger.debug("Set the server status to 1.");
            rm.setServerStatus(server_id_dest, 1);
            rm.setTableStatus(server_id_src, 0);
            Logger.debug("Waking up.");
            ForestRecovery.printServerStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        Logger.notice("RECOVERY / STARTING VM: done.");
    }

    public static void StopVM() {
        Logger.notice("RECOVERY / STOPPING VM: start.");
        try {
            int n;
            for (n = 0; n < retryMax && !ForestRecovery.preventUpdatingServer(server_id_dest); ++n) {
                Logger.debug("preventUpdatingServer() retrying...");
            }
            if (n == retryMax) {
                Logger.error("Can't deter the transactions.");
                ForestRecovery.abortRecovery();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        Logger.notice("RECOVERY / STOPPING VM: done.");
    }

    public static void RecoveryCleanup() {
        Logger.notice("RECOVERY / CLEANING UP");
        try {
            for (int i = 0; i < tableNames.length; ++i) {
                String string = tableNames[i];
                rm.stopRecoveryLogging(string);
            }
            rm.cleanupRecoveryLogging();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        ForestRecovery.parseOptions(stringArray);
        try {
            rm = new RecoveryManager();
            rm.connectToGSC(gscURL, userName, userPass);
            destURL = rm.getUrlFromServerId(server_id_dest) + dbname;
            sourceURL = rm.getUrlFromServerId(server_id_src) + dbname;
            Logger.notice("RECOVERING:");
            Logger.notice("  FROM [" + server_id_src + "]" + sourceURL);
            Logger.notice("    TO [" + server_id_dest + "]" + destURL);
            rm.setTimeout(timeout);
            rm.createDatabaseConnections(destURL, userName, userPass, sourceURL, userName, userPass);
            refreshInterval = rm.getCacheRefresh();
            Logger.notice("SERVER STATUS:");
            Logger.notice("  Src: Server " + server_id_src + ", Status " + rm.getServerStatus(server_id_src));
            Logger.notice("  Dst: Server " + server_id_dest + ", Status " + rm.getServerStatus(server_id_dest));
            Logger.notice("RECOVERY_MODE = " + RECOVERY_MODE);
            if (RECOVERY_MODE != 5) {
                if (rm.getServerStatus(server_id_src) != 1) {
                    Logger.error("Server " + server_id_src + " is not running. " + "Can't recovery from the unavailable server.");
                    System.exit(-1);
                }
                if (rm.getServerStatus(server_id_dest) == 1) {
                    Logger.error("Server " + server_id_dest + " is running. " + "Can't start recovery on the running server.");
                    System.exit(-1);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        ForestRecovery.initRecovery();
        if (RECOVERY_MODE == 0 || RECOVERY_MODE == 1) {
            ForestRecovery.RecoveryPhase1();
        }
        if (RECOVERY_MODE == 0 || RECOVERY_MODE == 4) {
            ForestRecovery.StopVM();
        }
        if (RECOVERY_MODE == 0 || RECOVERY_MODE == 2) {
            ForestRecovery.RecoveryPhase2();
        }
        if (RECOVERY_MODE == 0 || RECOVERY_MODE == 3) {
            ForestRecovery.StartVM();
        }
        if (RECOVERY_MODE == 0 || RECOVERY_MODE == 5) {
            ForestRecovery.RecoveryCleanup();
        }
        rm.closeAllConnections();
        Logger.debug("====== Recovery finished ======");
    }
}

