/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.recovery;

import java.sql.DriverManager;
import java.sql.Statement;
import org.postgresforest.tool.Logger;

class CancelThread
extends Thread {
    private int bepid;
    private int timeout;
    private String url;
    private String user;
    private String pass;
    private boolean enabled = true;

    CancelThread(int n, int n2, String string, String string2, String string3) {
        this.bepid = n;
        this.timeout = n2;
        this.url = string;
        this.user = string2;
        this.pass = string3;
        this.enabled = true;
        Logger.debug(this.toString() + " has been created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Logger.debug("CancelThread is going to wait " + this.timeout + " secs.");
            Object object = this;
            synchronized (object) {
                this.wait(this.timeout * 1000);
            }
            if (this.enabled) {
                Logger.notice("Going to cancel the backend (" + this.bepid + ")");
                object = DriverManager.getConnection(this.url, this.user, this.pass);
                Statement statement = object.createStatement();
                statement.executeQuery("SELECT pg_cancel_backend(" + this.bepid + ")");
                statement.close();
                object.close();
            } else {
                Logger.debug(this.toString() + " has been finished without a cancel command.");
            }
        }
        catch (Exception exception) {
            this.enabled = false;
            Logger.debug(this.toString() + ": " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disable() {
        Logger.debug(this.toString() + " disabled.");
        this.enabled = false;
        CancelThread cancelThread = this;
        synchronized (cancelThread) {
            this.notify();
        }
    }

    public String toString() {
        return "CancelThread: pid=" + this.bepid + ", url=" + this.url;
    }
}

