/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresforest.PGConnection;
import org.postgresforest.largeobject.LargeObject;
import org.postgresforest.largeobject.LargeObjectManager;

public class ImageViewer
implements ItemListener {
    Connection db;
    Statement stat;
    LargeObjectManager lom;
    Frame frame;
    Label label;
    List list;
    imageCanvas canvas;
    String currentImage;

    public ImageViewer(Frame f, String url, String user, String password) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        this.frame = f;
        MenuBar mb = new MenuBar();
        f.setMenuBar(mb);
        Menu m = new Menu("PostgreSQL");
        mb.add(m);
        MenuItem i = new MenuItem("Initialise");
        m.add(i);
        i.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageViewer.this.init();
            }
        });
        i = new MenuItem("Exit");
        m.add(i);
        ActionListener exitListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageViewer.this.close();
            }
        };
        m.addActionListener(exitListener);
        m = new Menu("Image");
        mb.add(m);
        i = new MenuItem("Import");
        m.add(i);
        ActionListener importListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageViewer.this.importImage();
            }
        };
        i.addActionListener(importListener);
        i = new MenuItem("Remove");
        m.add(i);
        ActionListener removeListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageViewer.this.removeImage();
            }
        };
        i.addActionListener(removeListener);
        this.label = new Label();
        f.add("North", this.label);
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        Button b = new Button("Refresh List");
        p.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageViewer.this.refreshList();
            }
        });
        b = new Button("Import new image");
        p.add(b);
        b.addActionListener(importListener);
        b = new Button("Remove image");
        p.add(b);
        b.addActionListener(removeListener);
        b = new Button("Quit");
        p.add(b);
        b.addActionListener(exitListener);
        f.add("South", p);
        this.list = new List();
        f.add("West", this.list);
        this.list.addItemListener(this);
        this.canvas = new imageCanvas();
        f.add("Center", this.canvas);
        Class.forName("org.postgresforest.Driver");
        this.db = DriverManager.getConnection(url, user, password);
        this.stat = this.db.createStatement();
        this.lom = ((PGConnection)this.db).getLargeObjectAPI();
        this.refreshList();
    }

    public void init() {
        try {
            this.stat.executeUpdate("create table images (imgname name,imgoid oid)");
            this.label.setText("Initialised database");
            this.db.commit();
        }
        catch (SQLException ex) {
            this.label.setText(ex.toString());
        }
    }

    public void close() {
        try {
            this.db.close();
        }
        catch (SQLException ex) {
            System.err.println(ex.toString());
        }
        System.exit(0);
    }

    public void importImage() {
        FileDialog d = new FileDialog(this.frame, "Import Image", 0);
        d.setVisible(true);
        String name = d.getFile();
        String dir = d.getDirectory();
        d.dispose();
        importer t = new importer(this.db, name, dir);
        t.start();
    }

    public void refreshList() {
        try {
            ResultSet rs = this.stat.executeQuery("select imgname from images order by imgname");
            if (rs != null) {
                this.list.removeAll();
                while (rs.next()) {
                    this.list.addItem(rs.getString(1));
                }
                rs.close();
            }
        }
        catch (SQLException ex) {
            this.label.setText(ex.toString() + " Have you initialised the database?");
        }
    }

    public void removeImage() {
        try {
            ResultSet rs = this.stat.executeQuery("select imgoid from images where imgname='" + this.currentImage + "'");
            if (rs != null) {
                while (rs.next()) {
                    this.lom.delete(rs.getInt(1));
                }
            }
            rs.close();
            this.stat.executeUpdate("delete from images where imgname='" + this.currentImage + "'");
            this.label.setText(this.currentImage + " deleted");
            this.currentImage = null;
            this.refreshList();
        }
        catch (SQLException ex) {
            this.label.setText(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImage(String name) {
        try {
            this.db.setAutoCommit(false);
            ResultSet rs = this.stat.executeQuery("select imgoid from images where imgname='" + name + "'");
            if (rs != null) {
                while (rs.next()) {
                    this.canvas.setImage(this.canvas.getToolkit().createImage(rs.getBytes(1)));
                    this.currentImage = name;
                    this.label.setText(this.currentImage);
                }
            }
            rs.close();
        }
        catch (SQLException ex) {
            this.label.setText(ex.toString());
        }
        finally {
            try {
                this.db.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.displayImage(this.list.getItem((Integer)e.getItem()));
    }

    public static void instructions() {
        System.err.println("java example.ImageViewer jdbc-url user password");
        System.err.println("\nExamples:\n");
        System.err.println("java -Djdbc.driver=org.postgresforest.Driver example.ImageViewer jdbc:postgresql:test postgres password\n");
        System.err.println("This example tests the binary large object api of the driver.\nBasically, it will allow you to store and view images held in the database.");
        System.err.println("Note: If you are running this for the first time on a particular database,\nyou have to select \"Initialise\" in the \"PostgreSQL\" menu.\nThis will create a table used to store image names.");
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            ImageViewer.instructions();
            System.exit(1);
        }
        try {
            Frame frame = new Frame("PostgreSQL ImageViewer v7.0 rev 1");
            frame.setLayout(new BorderLayout());
            ImageViewer viewer = new ImageViewer(frame, args[0], args[1], args[2]);
            frame.pack();
            frame.setLocation(0, 50);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }

    class importer
    extends Thread {
        String name;
        String dir;
        Connection db;

        public importer(Connection db, String name, String dir) {
            this.db = db;
            this.name = name;
            this.dir = dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block13: {
                if (this.name != null && this.dir != null) {
                    int s;
                    Statement stat = null;
                    LargeObjectManager lom = ((PGConnection)this.db).getLargeObjectAPI();
                    this.db.setAutoCommit(false);
                    byte[] buf = new byte[2048];
                    FileInputStream fis = new FileInputStream(new File(this.dir, this.name));
                    int oid = lom.create();
                    LargeObject blob = lom.open(oid);
                    int t = 0;
                    while ((s = fis.read(buf, 0, buf.length)) > 0) {
                        t += s;
                        blob.write(buf, 0, s);
                    }
                    blob.close();
                    stat = this.db.createStatement();
                    stat.executeUpdate("insert into images values ('" + this.name + "'," + oid + ")");
                    this.db.commit();
                    this.db.setAutoCommit(false);
                    ImageViewer.this.refreshList();
                    ImageViewer.this.displayImage(this.name);
                    Object var10_10 = null;
                    try {
                        if (stat != null) {
                            stat.close();
                        }
                        break block13;
                    }
                    catch (SQLException se) {
                        System.err.println("closing of Statement failed");
                    }
                    break block13;
                    {
                        catch (Exception ex) {
                            ImageViewer.this.label.setText(ex.toString());
                            Object var10_11 = null;
                            try {
                                if (stat != null) {
                                    stat.close();
                                }
                                break block13;
                            }
                            catch (SQLException se) {
                                System.err.println("closing of Statement failed");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        try {
                            if (stat != null) {
                                stat.close();
                            }
                        }
                        catch (SQLException se) {
                            System.err.println("closing of Statement failed");
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public class imageCanvas
    extends Canvas {
        private Image image = null;
        private Image bkg;
        private Dimension size;

        public void setImage(Image img) {
            this.image = img;
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return new Dimension(400, 400);
        }

        public Dimension getPreferedSize() {
            return this.getMinimumSize();
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics gr) {
            Dimension s = this.getSize();
            if (this.size == null || this.bkg == null || !s.equals(this.size)) {
                this.size = s;
                this.bkg = this.createImage(this.size.width, this.size.height);
            }
            Graphics g = this.bkg.getGraphics();
            g.setColor(Color.gray);
            g.fillRect(0, 0, s.width, s.height);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
            g.dispose();
            gr.drawImage(this.bkg, 0, 0, this);
        }
    }
}

