/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.commandline.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.action.DbInstanceAction;
import org.postgresforest.tool.action.ServerAction;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

public class InstanceActions {
    public void create(CommandParser cp, GSCdata gsc) {
        String host = (String)cp.getHost().get(0);
        String port = (String)cp.getPort().get(0);
        if (host != "" && port != "") {
            DbInstanceAction instance = new DbInstanceAction(gsc);
            try {
                if (instance.addInstance(host, port)) {
                    System.out.println(MessagesCommandLine.getString("cui.message.instance.create", new Object[]{host, port}));
                    return;
                }
            }
            catch (Exception e1) {
                System.err.println(e1);
            }
        }
        System.out.println(MessagesCommandLine.getString("cui.error.instance.create", new Object[]{host, port}));
    }

    public void drop(CommandParser cp, GSCdata gsc) {
        String id = (String)cp.getServer().get(0);
        if (id != "") {
            DbInstanceAction instance = new DbInstanceAction(gsc);
            try {
                if (instance.delInstance(id)) {
                    System.out.println(MessagesCommandLine.getString("cui.message.instance.drop", new Object[]{id}));
                    return;
                }
            }
            catch (Exception e1) {
                System.err.println(e1);
            }
        }
        System.out.println(MessagesCommandLine.getString("cui.error.instance.drop", new Object[]{id}));
    }

    public void show(GSCdata gsc) {
        ArrayList serverList = null;
        ServerAction serverInfo = new ServerAction(gsc);
        try {
            serverList = serverInfo.getServerList();
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.instance.show"));
            System.err.println(e);
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.message.instance.show"));
        Iterator it = serverList.iterator();
        System.out.println(" SERVERID\t| HOST\t| PORT\t| STATUS");
        System.out.println("----------------------------------------------");
        while (it.hasNext()) {
            ServerInfo srvInfo = (ServerInfo)it.next();
            System.out.print(srvInfo.getId() + "\t| ");
            System.out.print(srvInfo.getHost() + "\t| ");
            System.out.print(srvInfo.getPort() + "\t| ");
            System.out.println(this.convertStatus(srvInfo.getStatus()));
        }
    }

    public void set(CommandParser cp, GSCdata gsc, int status) {
        ArrayList statusList = null;
        int id = Integer.parseInt((String)cp.getServer().get(0));
        ServerAction serverInfo = new ServerAction(gsc);
        try {
            statusList = serverInfo.getServerList();
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.instance.set", new Object[]{Integer.toString(id)}));
            System.err.println(e);
            return;
        }
        Iterator it = statusList.iterator();
        while (it.hasNext()) {
            ServerInfo srvInfo = (ServerInfo)it.next();
            if (id != srvInfo.getId()) continue;
            srvInfo.setChangeStatus(status);
        }
        ServerAction serverAction = new ServerAction(gsc);
        if (!serverAction.setStatus(statusList)) {
            System.out.println(MessagesCommandLine.getString("cui.error.instance.set.up", new Object[]{Integer.toString(id)}));
            return;
        }
        if (status == 1) {
            System.out.println(MessagesCommandLine.getString("cui.message.instance.set.up", new Object[]{Integer.toString(id)}));
        } else if (status == -1) {
            System.out.println(MessagesCommandLine.getString("cui.message.instance.set.down", new Object[]{Integer.toString(id)}));
        }
    }

    private String convertStatus(int status) {
        String ret = "";
        if (status == 1) {
            ret = MessagesCommandLine.getString("form.running");
        } else if (status == -1) {
            ret = MessagesCommandLine.getString("form.stopping");
        }
        return ret;
    }
}

