/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.commandline.action;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.action.HashAction;
import org.postgresforest.tool.bean.HashInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

public class HashActions {
    public void create(CommandParser cp, GSCdata gsc) {
        String className = (String)cp.getHashName().get(0);
        String fileName = (String)cp.getHashFile().get(0);
        String description = "";
        Iterator it = cp.getHashDescript().iterator();
        while (it.hasNext()) {
            description = description + (String)it.next();
        }
        byte[] byteImg = null;
        try {
            byteImg = this.getFileByteImage(fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println(MessagesCommandLine.getString("cui.error.command.filenotfound", new Object[]{fileName}));
            return;
        }
        catch (Exception e1) {
            System.out.println(MessagesCommandLine.getString("cui.error.hash.create", new Object[]{className}));
            e1.printStackTrace();
            return;
        }
        HashAction hashAction = new HashAction(gsc);
        if (hashAction.addHash(className, description, byteImg)) {
            System.out.println(MessagesCommandLine.getString("cui.message.hash.create", new Object[]{className}));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.error.hash.create", new Object[]{className}));
    }

    public void drop(CommandParser cp, GSCdata gsc) {
        String id = (String)cp.getHashName().get(0);
        if (id != "") {
            HashAction hashAction = new HashAction(gsc);
            try {
                if (hashAction.delHash(id)) {
                    System.out.println(MessagesCommandLine.getString("cui.message.hash.drop", new Object[]{id}));
                    return;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        System.out.println(MessagesCommandLine.getString("cui.error.hash.drop", new Object[]{id}));
    }

    public void show(GSCdata gsc) {
        ArrayList hashList = null;
        HashAction hashAction = new HashAction(gsc);
        try {
            hashList = hashAction.getHashList();
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.hash.show"));
            e.printStackTrace();
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.message.hash.show"));
        Iterator it = hashList.iterator();
        System.out.println(" HASHNAME\t| DESCRIPTION");
        System.out.println("----------------------------------------------");
        while (it.hasNext()) {
            HashInfo hashInfo = (HashInfo)it.next();
            System.out.print(hashInfo.getName() + "\t| ");
            System.out.println(hashInfo.getDescription());
        }
    }

    private byte[] getFileByteImage(String fileName) throws FileNotFoundException, IOException {
        int nBytes;
        byte[] buf = new byte[64];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(fileName);
        while ((nBytes = in.read(buf)) > 0) {
            out.write(buf, 0, nBytes);
        }
        in.close();
        byte[] byteImg = out.toByteArray();
        out.close();
        return byteImg;
    }
}

