/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.postgresforest.tool.action.ActionBase;
import org.postgresforest.tool.action.UserLoginMng;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.db.UserData;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Parser;
import org.postgresforest.tool.util.ReWriter;

public class ExecDdl
extends ActionBase {
    private UserData m_userData;

    public ExecDdl(GSCdata gsc, String dbName) {
        super(gsc);
        this.m_userData = new UserLoginMng(gsc).getUserDb(dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeMain(String ddlSql) {
        boolean statusOk = false;
        String dbName = this.m_userData.getDbName();
        ArrayList<String> sqlList = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(ddlSql, ";");
        while (t.hasMoreTokens()) {
            String wkSql = t.nextToken();
            if ((wkSql = wkSql.replaceFirst("\\s*", "")).length() == 0) continue;
            sqlList.add(wkSql);
        }
        if (!this.connect(this.m_gsc) || !this.connect(this.m_userData)) {
            return false;
        }
        try {
            Iterator iter1 = sqlList.iterator();
            block17: while (iter1.hasNext()) {
                Parser paser;
                ddlSql = (String)iter1.next();
                System.out.println(MessagesCommandLine.getString("message.ddl.header"));
                System.out.println(ddlSql);
                statusOk = false;
                try {
                    ddlSql = ReWriter.toLowerSql(ddlSql);
                    paser = new Parser(ddlSql);
                }
                catch (Exception e) {
                    System.out.println(MessagesCommandLine.getString("message.ddl.error"));
                    e.printStackTrace();
                    System.out.println(MessagesCommandLine.getString("message.ddl.error.detail"));
                    System.out.println("\n\n");
                    continue;
                }
                String tableName = null;
                int partitionCount = 0;
                int type = paser.getType();
                switch (type) {
                    case 1: 
                    case 3: {
                        if (!this.m_gsc.addTable(dbName, (String)paser.getTables().get(0))) {
                            this.m_gsc.rollback();
                            this.setAccessErrs(this.m_gsc);
                            break;
                        }
                        if (!this.m_userData.execDdl(ddlSql)) {
                            this.m_gsc.rollback();
                            this.m_userData.rollback();
                            this.setAccessErrs(this.m_userData);
                            break;
                        }
                        if (!this.m_gsc.updateConfigDate()) {
                            this.m_gsc.rollback();
                            this.setAccessErrs(this.m_gsc);
                            break;
                        }
                        this.m_gsc.commit();
                        this.m_userData.commit();
                        statusOk = true;
                        break;
                    }
                    case 2: 
                    case 4: {
                        Iterator iter = paser.getTables().iterator();
                        while (iter.hasNext()) {
                            tableName = (String)iter.next();
                            if (this.m_gsc.delTable(dbName, tableName)) continue;
                            this.m_gsc.rollback();
                            this.setAccessErrs(this.m_gsc);
                            break;
                        }
                        if (!this.m_userData.execDdl(ddlSql)) {
                            this.m_gsc.rollback();
                            this.m_userData.rollback();
                            this.setAccessErrs(this.m_userData);
                            break;
                        }
                        if (!this.m_gsc.updateConfigDate()) {
                            this.m_gsc.rollback();
                            this.setAccessErrs(this.m_gsc);
                            break;
                        }
                        this.m_gsc.commit();
                        this.m_userData.commit();
                        statusOk = true;
                        break;
                    }
                    case 6: {
                        String[] ddlSqls;
                        tableName = (String)paser.getTables().get(0);
                        try {
                            partitionCount = this.m_gsc.getPartitionCount(dbName, tableName);
                        }
                        catch (SQLException e) {
                            this.setAccessErrs(this.m_gsc);
                        }
                        if (partitionCount > 1) {
                            ddlSqls = ReWriter.rewrite(ddlSql, tableName, partitionCount);
                            if (!this.m_userData.execDdl(ddlSqls)) {
                                this.m_userData.rollback();
                                this.setAccessErrs(this.m_userData);
                                break;
                            }
                        } else if (!this.m_userData.execDdl(ddlSql)) {
                            this.m_userData.rollback();
                            this.setAccessErrs(this.m_userData);
                            break;
                        }
                        this.m_userData.commit();
                        statusOk = true;
                        break;
                    }
                    case 5: {
                        String[] ddlSqls;
                        tableName = (String)paser.getTables().get(0);
                        try {
                            partitionCount = this.m_gsc.getPartitionCount(dbName, tableName);
                        }
                        catch (SQLException e1) {
                            this.setAccessErrs(this.m_gsc);
                        }
                        if (partitionCount > 1) {
                            ddlSqls = ReWriter.rewrite(ddlSql, paser.getReplaceWord(), tableName, partitionCount);
                            if (!this.m_userData.execDdl(ddlSqls)) {
                                this.m_userData.rollback();
                                this.setAccessErrs(this.m_userData);
                                break;
                            }
                        } else if (!this.m_userData.execDdl(ddlSql)) {
                            this.m_userData.rollback();
                            this.setAccessErrs(this.m_userData);
                            break;
                        }
                        this.m_userData.commit();
                        statusOk = true;
                        break;
                    }
                    case 200: {
                        System.out.println(MessagesCommandLine.getString("message.ddl.skip"));
                        System.out.print(MessagesCommandLine.getString("message.ddl.result"));
                        System.out.println(MessagesCommandLine.getString("message.ddl.skip"));
                        System.out.println();
                        continue block17;
                    }
                    default: {
                        if (!this.m_userData.execDdl(ddlSql)) {
                            this.m_userData.rollback();
                            this.setAccessErrs(this.m_userData);
                            break;
                        }
                        this.m_userData.commit();
                        statusOk = true;
                    }
                }
                System.out.print(MessagesCommandLine.getString("message.ddl.result"));
                if (!statusOk) {
                    System.out.println(MessagesCommandLine.getString("message.ddl.error.detail"));
                    System.out.println("\n");
                    continue;
                }
                System.out.println(MessagesCommandLine.getString("message.ddl.execute"));
                System.out.println("\n");
            }
        }
        finally {
            this.m_gsc.close();
            this.m_userData.close();
        }
        return true;
    }
}

