/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.posterdivider;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NumberField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private static Pattern pattern = Pattern.compile("(-)?[0-9,]+(\\.[0-9,]+)?");
    private static final double initValue = 0.0;
    private double value = 0.0;
    private double unitIncrement = 0.0;
    private int displayDigit = 0;
    private DecimalFormat decimalFormat = NumberField.createDecimalFormat(0);
    private int countIncrement = 0;

    private static DecimalFormat createDecimalFormat(int n) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(n);
        return decimalFormat;
    }

    private double calcValue(String string) {
        Matcher matcher = pattern.matcher(string);
        return matcher.find() ? Double.valueOf(matcher.group().replace(",", "")) : 0.0;
    }

    private void updateText() {
        super.setText(this.decimalFormat.format(this.value));
    }

    private void numberField_actionPerformed() {
        this.updateText();
    }

    private void numberField_focusLost(FocusEvent focusEvent) {
        this.countIncrement = 0;
        this.fireActionPerformed();
    }

    private void numberField_textChanged() {
        this.value = this.calcValue(super.getText());
    }

    private void numberField_keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (this.countIncrement >= 19) {
                    this.setValue(this.value + this.unitIncrement * 100.0);
                } else if (this.countIncrement >= 10) {
                    this.setValue(this.value + this.unitIncrement * 10.0);
                } else {
                    this.setValue(this.value + this.unitIncrement);
                }
                ++this.countIncrement;
                keyEvent.consume();
                break;
            }
            case 40: {
                if (this.countIncrement >= 19) {
                    this.setValue(this.value - this.unitIncrement * 100.0);
                } else if (this.countIncrement >= 10) {
                    this.setValue(this.value - this.unitIncrement * 10.0);
                } else {
                    this.setValue(this.value - this.unitIncrement);
                }
                ++this.countIncrement;
                keyEvent.consume();
                break;
            }
        }
    }

    private void numberField_keyReleased(KeyEvent keyEvent) {
        this.countIncrement = 0;
    }

    private void numberField_keyTyped(KeyEvent keyEvent) {
        switch (keyEvent.getKeyChar()) {
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                keyEvent.consume();
            }
        }
    }

    public NumberField() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberField.this.numberField_actionPerformed();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NumberField.this.numberField_focusLost(focusEvent);
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                NumberField.this.numberField_textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                NumberField.this.numberField_textChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                NumberField.this.numberField_keyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                NumberField.this.numberField_keyReleased(keyEvent);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                NumberField.this.numberField_keyTyped(keyEvent);
            }
        });
        this.updateText();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
        this.updateText();
    }

    @Override
    public void setText(String string) {
        this.value = this.calcValue(string);
        this.updateText();
    }

    public double getUnitIncrement() {
        return this.unitIncrement;
    }

    public void setUnitIncrement(double d) {
        this.unitIncrement = d;
    }

    public int getDisplayDigit() {
        return this.displayDigit;
    }

    public void setDisplayDigit(int n) {
        this.displayDigit = n;
        this.decimalFormat = NumberField.createDecimalFormat(n);
        this.updateText();
    }
}

