/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.posterdivider;

import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;
import jp.sourceforge.posterdivider.Lib;

public class FileContainer {
    private byte[] data;
    private int fileType;
    private PdfReader pdf;
    private Image image;
    private BufferedImage awtImage;

    private void init(byte[] byArray) throws Exception {
        Object object;
        this.data = byArray;
        this.fileType = 0;
        if (this.fileType == 0) {
            try {
                object = new PdfReader(byArray);
                this.fileType = 1;
                this.pdf = object;
            }
            catch (Throwable throwable) {
                this.fileType = 0;
            }
        }
        if (this.fileType == 0) {
            try {
                object = Image.getInstance(byArray);
                this.fileType = Lib.getImageFileType((Image)object);
                this.image = object;
            }
            catch (Exception exception) {
                this.fileType = 0;
            }
        }
        if (this.fileType == 0) {
            throw new Exception();
        }
        try {
            object = new ByteArrayInputStream(byArray);
            this.awtImage = ImageIO.read((InputStream)object);
            ((ByteArrayInputStream)object).close();
        }
        catch (Exception exception) {
            this.awtImage = null;
        }
    }

    public FileContainer(File file) throws Exception {
        byte[] byArray = Lib.FileReadAllBytes(file);
        this.init(byArray);
    }

    public FileContainer(byte[] byArray) throws Exception {
        this.init(byArray);
    }

    public int getFileType() {
        return this.fileType;
    }

    public PdfReader getPdf() {
        return this.pdf;
    }

    public Image getImage() {
        return this.image;
    }

    public int getPageCount() {
        switch (this.fileType) {
            case 1: {
                return this.pdf.getNumberOfPages();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 1;
            }
        }
        return -1;
    }

    public BufferedImage getAwtImage() {
        return this.awtImage;
    }
}

