//
// posterdivider.c
// This file is part of PosterDivider.
//

#include <string.h>
#include <windows.h>
//#include <commctrl.h>

#include "jvm.h"

#define APPCLASS "jp/sourceforge/posterdivider/Program"
#define CLASSPATH "%JAVAROOT%/iText.jar;%JAVAROOT%/PosterDivider.jar"

char *strreplace(char *str, char *s1, char *s2)
{
	int i;
	char *p;
	int cstr, cs1, cs2;
	char *start[257], *end[257];
	int count;
	char *ret;
	
	cstr = strlen(str);
	cs1 = strlen(s1);
	cs2 = strlen(s2);
	p = str;
	for(i=0; i<256; i++)
	{
		start[i] = p;
		p = strstr(p, s1);
		if(p == NULL) break;
		
		end[i] = p;
		p += cs1;
	}
	end[i] = str + cstr;
	count = i;
	
	ret = malloc(sizeof(char)*(cstr+(cs2-cs1)*count+1));
	p = ret;
	for(i=0; i<count; i++)
	{
		p = strncpy(p, start[i], end[i]-start[i])+(end[i]-start[i]);
		p = strncpy(p, s2, cs2)+cs2;
	}
	p = strncpy(p, start[i], end[i]-start[i])+(end[i]-start[i]);
	*p = '\0';
	return ret;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	TCHAR text[1024];
	int c, i;
	char *p;
	LPTSTR lpTCmdLine;
	LPWSTR lpWCmdLine;
	LPWSTR *lpCmdArgs;
	int nCmdArgs;
	char **cmdArgs;
	char *exePath;
	char *javaRoot;
	char *classPath;
	
	// コマンドライン引数の解析
	lpTCmdLine = GetCommandLine();
#ifdef UNICODE
	lpWCmdLine = lpTCmdLine;
#else
	c = MultiByteToWideChar(CP_ACP, 0, lpTCmdLine, -1, NULL, 0);
	lpWCmdLine = malloc(sizeof(LPWSTR)*(c+1));
	MultiByteToWideChar(CP_ACP, 0, lpTCmdLine, -1, lpWCmdLine, c);
#endif
	lpCmdArgs = CommandLineToArgvW(lpWCmdLine, &nCmdArgs);
#ifndef UNICODE
	free(lpWCmdLine);
#endif
	
	c = WideCharToMultiByte(CP_ACP, 0, lpCmdArgs[0], -1, NULL, 0, NULL, NULL);
	exePath = malloc(sizeof(char)*(c+10));
	WideCharToMultiByte(CP_ACP, 0, lpCmdArgs[0], -1, exePath, c, NULL, NULL);
	// exeパスからディレクトリ名に変換
	p = strrchr(exePath, '\\');
	if(p == NULL) p = exePath;
	else p++;
	*p = '\0';
	javaRoot = exePath;
	strcat(javaRoot, "Jar");
	
	nCmdArgs = nCmdArgs-1;
	cmdArgs = malloc(sizeof(char*)*(nCmdArgs+1));
	for(i=0; i<nCmdArgs; i++)
	{
		c = WideCharToMultiByte(CP_UTF8, 0, lpCmdArgs[i+1], -1, NULL, 0, NULL, NULL);
		cmdArgs[i] = malloc(sizeof(char)*(c+1));
		WideCharToMultiByte(CP_UTF8, 0, lpCmdArgs[i+1], -1, cmdArgs[i], c, NULL, NULL);
	}
	LocalFree(lpCmdArgs);
	
	classPath = strreplace(CLASSPATH, "%JAVAROOT%", javaRoot);
	//MessageBox(NULL, classPath, NULL, MB_OK);
	free(javaRoot);
	
	//InitCommonControls();
	
	c = execJVM(APPCLASS, classPath, cmdArgs, nCmdArgs);
	if(c)
	{
		switch(c)
		{
			case 1:
			case 2:
			case 3:
			case 4:
			case 5:
			case 6:
				wsprintf(text, "Java Environment Not Found (error: %d)", c);
				break;
			case 7:
				wsprintf(text, "Failed Create JavaVM (error: %d)", c);
				break;
			case 8:
			case 9:
				wsprintf(text, "Jar Files Not Found (error: %d)", c);
				break;
			default:
				wsprintf(text, "error: %d", c);
				break;
		}
		MessageBox(NULL, text, NULL, MB_OK);
	}
	
	return 0;
}
