package PositLogConfig;

# --------------------------------------------------------
# PositLogConfig.pm
#      global configuration file for PositLog
#  (tested under perl 5.8.4)
#
#  This file is part of PositLog.
# --------------------------------------------------------

#-------------------------------------------------------------------
# Examples below presume the following website structure.
#
# /var/www/html/positlog/positlog.cgi
# /var/www/html/positlog/pages/
#
# URL which maps positlog.cgi is 
# http://xxx.com/positlog/positlog.cgi
#-------------------------------------------------------------------

#-------------------------------------------------------------------
# PositLog Root URL
#  Don't omit the last "/".
# e.g) http://xxx.com/positlog/

my $rooturl = "http://xxx.com/positlog/";

#-------------------------------------------------------------------
# Page Data Directory
#  Write the relative path from the directory of positlog.cgi.
#  Use the directory deeper than the directory of positlog.cgi.
#  Don't omit the last "/".
# e.g.) ./pages/

$datapath = "./pages/";

#-------------------------------------------------------------------
# Maximum Size of Uploaded File
#  Write the maximum bytes size of the attached file uploaded by 
#  Simple Editor.
# e.g.) 100 kbytes : $uploadmax = 102400;
# 1Mbytes : $uploadmax = 1048576;
# Uploaded file size cannot be limited in Rich Editor.

$uploadmax = 102400;

#-------------------------------------------------------------------
# Language of System Message 
#  English: en
#  Japanese: ja

$language = "ja";

#-------------------------------------------------------------------
# mod_rewrite on the web server
#
# Avaliable: 1
# Not available: 0
#
# If mod_rewrite is available on the web server, set
# $mod_rewrite = 1; 
# and rename "htaccess_mod_rewrite" into ".htaccess".
# And then put it under PositLog Root Directory.
# (See also the install document.)
#

$mod_rewrite = 0;

#-------------------------------------------------------------------
# Gzip Compressed Transfer
#
# Available: 1
# Not available: 0
#
# If gzip is available on the web server, set 
# $gzip = 1;
# to compress the html file genereated by positlog.cgi by gzip.
# It reduce the page loading time.
#
# Set the correct path in $gzippath.

$gzip = 0;
$gzippath = "/bin/gzip";


#-------------------------------------------------------------------
# Security of Uploaded File
#
# Uploaded files can be accessed without authentication
# by directly indicating their URLs. 
# This problem can be avoided by using fileuploader.cgi. 
# mod_rewrite is required to do it.
#
# 1. Set HTTP inaccessible path to $datapath in PositLogConfig.pm.
# 2. Set rewrite rules to .htaccess as follows : 
#  (change the pass of fileloader.cgi according to the server environment)
#
# RewriteRule ^(.*)([0-9]{6}[a-zA-Z]{2})(/images/.+)$ /fileloader.cgi?page=$2&path=$3 [L]
# RewriteRule ^(.*)([0-9]{6}[a-zA-Z]{2})(/files/.+)$ /fileloader.cgi?page=$2&path=$3 [L]
# 
# 3. Set fileloader.cgi in the same directory of positlog.cgi
# 4. Set 1 to $filesecure below.

$filesecure = 0;

# Notice that the file access through fileuploader.cgi is slower than direct access.
#
# If mod_rewrite is not available, set 
# $filesecure = 0;
# In this case, you need to pay attention not to be known the URL of secret files.
#

# You need not to edit following values.

$helpurl = "http://positlog.com/071208MM.html"; 

$rooturl =~ /^http:\/\/.+?(\/.*)$/;
$cgipath = $1;
$systempath = $cgipath . "system/";
$bgimagespath = "./bgimages/";
$bgimagesurl = $bgimagespath;
$adminpath = "./admindata/";
$admintoolscgipath = "./admintools/";
$admintoolsfilepath = "./admintools/";
$dataurl = $datapath;
$fckuploadurl = $cgipath . $datapath;
$fckconnector = $systempath . "fckeditor/editor/filemanager/connectors/perl/connector.cgi";
$fckuploader = $systempath . "fckeditor/editor/filemanager/connectors/perl/upload.cgi";
$rooturl =~ /^(http:\/\/.+?\/).*$/;
$site = $1;

1;
